/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.wrappedio.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.io.wrappedio.impl.DynamicWrappedStatistics;
import org.apache.hadoop.io.wrappedio.impl.TestWrappedIO;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.Tuples;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWrappedStatistics
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestWrappedIO.class);
    private static final Serializable SERIALIZABLE = new Serializable(){};
    private final DynamicWrappedStatistics statistics = new DynamicWrappedStatistics();
    private LocalFileSystem local;
    private Path jsonPath;

    @Before
    public void setUp() throws Exception {
        String testDataDir = new FileSystemTestHelper().getTestRootDir();
        File tempDir = new File(testDataDir);
        this.local = FileSystem.getLocal((Configuration)new Configuration());
        File jsonFile = new File(tempDir, "snapshot.json");
        this.jsonPath = new Path(jsonFile.toURI());
    }

    @Test
    public void testLoaded() throws Throwable {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.statistics.ioStatisticsAvailable()).describedAs("IOStatistics class must be available", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.statistics.ioStatisticsContextAvailable()).describedAs("IOStatisticsContext must be available", new Object[0])).isTrue();
    }

    @Test
    public void testCreateEmptySnapshot() throws Throwable {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsSnapshot_create()).describedAs("iostatisticsSnapshot_create()", new Object[0])).isInstanceOf(IOStatisticsSnapshot.class)).satisfies(arg_0 -> ((DynamicWrappedStatistics)this.statistics).isIOStatisticsSnapshot(arg_0))).satisfies(arg_0 -> ((DynamicWrappedStatistics)this.statistics).isIOStatistics(arg_0));
    }

    @Test
    public void testCreateNullSource() throws Throwable {
        ((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsSnapshot_create(null)).describedAs("iostatisticsSnapshot_create(null)", new Object[0])).isInstanceOf(IOStatisticsSnapshot.class);
    }

    @Test
    public void testCreateOther() throws Throwable {
        ((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsSnapshot_create(null)).describedAs("iostatisticsSnapshot_create(null)", new Object[0])).isInstanceOf(IOStatisticsSnapshot.class);
    }

    @Test
    public void testCreateNonIOStatsSource() throws Throwable {
        LambdaTestUtils.intercept(ClassCastException.class, () -> this.statistics.iostatisticsSnapshot_create((Object)"hello"));
    }

    @Test
    public void testRetrieveNullSource() throws Throwable {
        ((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsSnapshot_retrieve(null)).describedAs("iostatisticsSnapshot_retrieve(null)", new Object[0])).isNull();
    }

    @Test
    public void testRetrieveNonIOStatsSource() throws Throwable {
        ((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsSnapshot_retrieve((Object)this)).describedAs("iostatisticsSnapshot_retrieve(this)", new Object[0])).isNull();
    }

    @Test
    public void testNullInstanceToJson() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.toJsonString(null));
    }

    @Test
    public void testWrongSerializableTypeToJson() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.toJsonString(SERIALIZABLE));
    }

    @Test
    public void testAggregateWrongSerializable() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.statistics.iostatisticsSnapshot_aggregate(SERIALIZABLE, this.statistics.iostatisticsContext_getCurrent()));
    }

    @Test
    public void testSaveWrongSerializable() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.statistics.iostatisticsSnapshot_save(SERIALIZABLE, (FileSystem)this.local, this.jsonPath, true));
    }

    @Test
    public void testIOStatisticsContextMethods() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.statistics.ioStatisticsContextAvailable()).describedAs("ioStatisticsContextAvailable() of %s", new Object[]{this.statistics})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.statistics.iostatisticsContext_enabled()).describedAs("iostatisticsContext_enabled() of %s", new Object[]{this.statistics})).isTrue();
        Object current = this.statistics.iostatisticsContext_getCurrent();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)current).describedAs("IOStatisticsContext", new Object[0])).isInstanceOf(IOStatisticsContext.class)).satisfies(arg_0 -> ((DynamicWrappedStatistics)this.statistics).isIOStatisticsSource(arg_0));
        Serializable snapshot = this.statistics.iostatisticsContext_snapshot();
        Assertions.assertThat((Object)snapshot).satisfies(arg_0 -> ((DynamicWrappedStatistics)this.statistics).isIOStatisticsSnapshot(arg_0));
        Serializable retrieved = this.statistics.iostatisticsSnapshot_retrieve(current);
        this.assertJsonEqual(retrieved, snapshot);
        String json = this.toJsonString(snapshot);
        LOG.info("Serialized to json {}", (Object)json);
        Serializable snap2 = this.statistics.iostatisticsSnapshot_fromJsonString(json);
        this.assertJsonEqual(snap2, snapshot);
        this.statistics.iostatistics_counters(snapshot);
        this.statistics.iostatistics_gauges(snapshot);
        this.statistics.iostatistics_minimums(snapshot);
        this.statistics.iostatistics_maximums(snapshot);
        this.statistics.iostatistics_means(snapshot);
        this.statistics.iostatisticsContext_setThreadIOStatisticsContext(null);
        ((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsContext_getCurrent()).describedAs("current IOStatisticsContext after resetting", new Object[0])).isNotSameAs(current);
        this.statistics.iostatisticsContext_setThreadIOStatisticsContext(current);
        ((ObjectAssert)Assertions.assertThat((Object)this.statistics.iostatisticsContext_getCurrent()).describedAs("current IOStatisticsContext after resetting", new Object[0])).isSameAs(current);
        this.statistics.iostatisticsContext_reset();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.statistics.iostatisticsContext_aggregate((Object)retrieved)).describedAs("iostatisticsContext_aggregate of %s", new Object[]{retrieved})).isTrue();
    }

    @Test
    public void testIOStatisticsContextInteraction() {
        this.statistics.iostatisticsContext_reset();
        IOStatisticsSnapshot snapshot = (IOStatisticsSnapshot)this.statistics.iostatisticsSnapshot_create();
        snapshot.setCounter("c1", 10L);
        this.statistics.iostatisticsContext_aggregate((Object)snapshot);
        this.statistics.iostatisticsContext_aggregate((Object)snapshot);
        IOStatisticsSnapshot snap2 = (IOStatisticsSnapshot)this.statistics.iostatisticsContext_snapshot();
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)snap2, "c1").isEqualTo(20L);
    }

    private void assertJsonEqual(Serializable actual, Serializable expected) {
        ((AbstractStringAssert)Assertions.assertThat((String)this.toJsonString(actual)).describedAs("JSON format string of %s", new Object[]{actual})).isEqualTo((Object)this.toJsonString(expected));
    }

    private String toJsonString(Serializable snapshot) {
        return this.statistics.iostatisticsSnapshot_toJsonString(snapshot);
    }

    @Test
    public void testLocalSaveOfEmptySnapshot() throws Throwable {
        Serializable snapshot = this.statistics.iostatisticsSnapshot_create();
        this.statistics.iostatisticsSnapshot_save(snapshot, (FileSystem)this.local, this.jsonPath, true);
        Serializable loaded = this.statistics.iostatisticsSnapshot_load((FileSystem)this.local, this.jsonPath);
        LOG.info("loaded statistics {}", (Object)this.statistics.iostatistics_toPrettyString((Object)loaded));
        LambdaTestUtils.intercept(UncheckedIOException.class, () -> this.statistics.iostatisticsSnapshot_save(snapshot, (FileSystem)this.local, this.jsonPath, false));
        this.local.delete(this.jsonPath, false);
        LambdaTestUtils.intercept(UncheckedIOException.class, () -> this.statistics.iostatisticsSnapshot_load((FileSystem)this.local, this.jsonPath));
    }

    @Test
    public void testStatisticExtraction() throws Throwable {
        IOStatisticsStore store = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{"c1", "c2"}).withGauges(new String[]{"g1"}).withDurationTracking(new String[]{"d1", "d2"}).build();
        store.incrementCounter("c1");
        store.setGauge("g1", 10L);
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)store, (String)"d1", () -> TestWrappedStatistics.sleep(20));
        store.trackDuration("d1").close();
        LambdaTestUtils.intercept(IOException.class, () -> IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)store, (String)"d2", () -> {
            TestWrappedStatistics.sleep(10);
            throw new IOException("generated");
        }));
        Serializable snapshot = this.statistics.iostatisticsSnapshot_create((Object)store);
        this.statistics.iostatisticsSnapshot_save(snapshot, (FileSystem)this.local, this.jsonPath, true);
        Serializable loaded = this.statistics.iostatisticsSnapshot_load((FileSystem)this.local, this.jsonPath);
        LOG.info("loaded statistics {}", (Object)this.statistics.iostatistics_toPrettyString((Object)loaded));
        this.assertJsonEqual(loaded, snapshot);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.statistics.iostatistics_counters(loaded)).containsOnlyKeys((Object[])new String[]{"c1", "c2", "d1", "d1.failures", "d2", "d2.failures"}).containsEntry((Object)"c1", (Object)1L)).containsEntry((Object)"d1", (Object)2L)).containsEntry((Object)"d2", (Object)1L);
        Assertions.assertThat((Map)this.statistics.iostatistics_gauges(loaded)).containsOnlyKeys((Object[])new String[]{"g1"}).containsEntry((Object)"g1", (Object)10L);
        Map minimums = this.statistics.iostatistics_minimums(snapshot);
        Assertions.assertThat((Map)minimums).containsEntry((Object)"d1.min", (Object)0L);
        long d2FailuresMin = (Long)minimums.get("d2.failures.min");
        ((AbstractLongAssert)Assertions.assertThat((long)d2FailuresMin).describedAs("min d2.failures", new Object[0])).isGreaterThan(0L);
        Map maximums = this.statistics.iostatistics_maximums(snapshot);
        Assertions.assertThat((Map)maximums).containsEntry((Object)"d2.failures.max", (Object)d2FailuresMin);
        long d1Max = (Long)maximums.get("d1.max");
        Map means = this.statistics.iostatistics_means(snapshot);
        ((MapAssert)Assertions.assertThat((Map)means).containsEntry((Object)"d1.mean", (Object)Tuples.pair((Object)2L, (Object)d1Max))).containsEntry((Object)"d2.failures.mean", (Object)Tuples.pair((Object)1L, (Object)d2FailuresMin));
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingIOStatisticsMethods() throws Throwable {
        DynamicWrappedStatistics missing = new DynamicWrappedStatistics(StubClass.class.getName());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)missing.ioStatisticsAvailable()).describedAs("ioStatisticsAvailable() of %s", new Object[]{missing})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)missing.isIOStatistics((Object)SERIALIZABLE)).describedAs("isIOStatistics() of %s", new Object[]{missing})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)missing.isIOStatisticsSource((Object)SERIALIZABLE)).describedAs("isIOStatisticsSource() of %s", new Object[]{missing})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)missing.isIOStatisticsSnapshot(SERIALIZABLE)).describedAs("isIOStatisticsSnapshot() of %s", new Object[]{missing})).isFalse();
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_create());
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_create((Object)this));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_aggregate(SERIALIZABLE, (Object)this));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_fromJsonString("{}"));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_toJsonString(SERIALIZABLE));
        Path path = new Path("/");
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_load((FileSystem)this.local, path));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_save(SERIALIZABLE, (FileSystem)this.local, path, true));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsSnapshot_retrieve((Object)this));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatistics_toPrettyString((Object)this));
    }

    @Test
    public void testMissingContextMethods() throws Throwable {
        DynamicWrappedStatistics missing = new DynamicWrappedStatistics(StubClass.class.getName());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)missing.ioStatisticsContextAvailable()).describedAs("ioStatisticsContextAvailable() of %s", new Object[]{missing})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)missing.iostatisticsContext_enabled()).describedAs("iostatisticsContext_enabled() of %s", new Object[]{missing})).isFalse();
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> ((DynamicWrappedStatistics)missing).iostatisticsContext_reset());
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> ((DynamicWrappedStatistics)missing).iostatisticsContext_getCurrent());
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> ((DynamicWrappedStatistics)missing).iostatisticsContext_snapshot());
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> missing.iostatisticsContext_setThreadIOStatisticsContext(null));
    }

    @Test
    public void testStatisticCasting() throws Throwable {
        Serializable iostats = this.statistics.iostatisticsSnapshot_create(null);
        String wrongType = "wrong type";
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.statistics.iostatisticsSnapshot_aggregate(iostats, (Object)"wrong type"));
    }

    private static final class StubClass {
        private StubClass() {
        }
    }
}

