/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.io.compress.bzip2.CBZip2InputStream;

public final class BZip2Utils {
    private BZip2Utils() {
    }

    public static List<Long> getNextBlockMarkerOffsets(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        try (FSDataInputStream fileIn = fs.open(path);){
            List<Long> list = BZip2Utils.getNextBlockMarkerOffsets((InputStream)fileIn);
            return list;
        }
    }

    public static List<Long> getNextBlockMarkerOffsets(InputStream rawIn) throws IOException {
        try (CBZip2InputStream in = new CBZip2InputStream(rawIn, SplittableCompressionCodec.READ_MODE.BYBLOCK);){
            ArrayList<Long> offsets = new ArrayList<Long>();
            while (in.skipToNextBlockMarker()) {
                offsets.add(in.getProcessedByteCount());
            }
            ArrayList<Long> arrayList = offsets;
            return arrayList;
        }
    }
}

