/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.io.IOException;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.AbstractObjectInputStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.impl.streams.StreamFactoryRequirements;
import org.apache.hadoop.fs.s3a.impl.streams.StreamIntegration;
import org.apache.hadoop.util.StringUtils;

public class ClassicObjectInputStreamFactory
extends AbstractObjectInputStreamFactory {
    public ClassicObjectInputStreamFactory() {
        super("ClassicObjectInputStreamFactory");
    }

    @Override
    public ObjectInputStream readObject(ObjectReadParameters parameters) throws IOException {
        return new S3AInputStream(parameters);
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase((String)capability)) {
            case "fs.capability.iocontext.supported": 
            case "in:readahead": 
            case "in:unbuffer": 
            case "in:readvectored": {
                return true;
            }
        }
        return super.hasCapability(capability);
    }

    @Override
    public InputStreamType streamType() {
        return InputStreamType.Classic;
    }

    @Override
    public StreamFactoryRequirements factoryRequirements() {
        return new StreamFactoryRequirements(0, 0, StreamIntegration.populateVectoredIOContext(this.getConfig()), new StreamFactoryRequirements.Requirements[0]);
    }
}

