/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.impl;

import org.apache.hadoop.fs.audit.CommonAuditContext;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public final class AuditContextUpdater {
    private final String jobId;
    private final String taskAttemptId;

    public AuditContextUpdater(JobContext jobContext) {
        TaskAttemptID tid;
        JobID contextJobID = jobContext.getJobID();
        String string = this.jobId = contextJobID != null ? contextJobID.toString() : null;
        this.taskAttemptId = jobContext instanceof TaskAttemptContext ? ((tid = ((TaskAttemptContext)jobContext).getTaskAttemptID()) != null ? tid.toString() : null) : null;
    }

    public AuditContextUpdater(String jobId) {
        this.jobId = jobId;
        this.taskAttemptId = null;
    }

    public void updateCurrentAuditContext() {
        CommonAuditContext auditCtx = CommonAuditContext.currentAuditContext();
        if (this.jobId != null) {
            auditCtx.put("ji", this.jobId);
        } else {
            CommonAuditContext.currentAuditContext().remove("ji");
        }
        if (this.taskAttemptId != null) {
            auditCtx.put("ta", this.taskAttemptId);
        } else {
            CommonAuditContext.currentAuditContext().remove("ta");
        }
    }

    public void resetCurrentAuditContext() {
        CommonAuditContext.currentAuditContext().remove("ji");
        CommonAuditContext.currentAuditContext().remove("ta");
    }
}

