/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.generate;

import io.github.ollama4j.models.generate.OllamaGenerateResponseModel;
import io.github.ollama4j.models.generate.OllamaStreamHandler;
import java.util.ArrayList;
import java.util.List;

public class OllamaGenerateStreamObserver {
    private final OllamaStreamHandler thinkingStreamHandler;
    private final OllamaStreamHandler responseStreamHandler;
    private final List<OllamaGenerateResponseModel> responseParts = new ArrayList<OllamaGenerateResponseModel>();
    private String message = "";

    public OllamaGenerateStreamObserver(OllamaStreamHandler thinkingStreamHandler, OllamaStreamHandler responseStreamHandler) {
        this.responseStreamHandler = responseStreamHandler;
        this.thinkingStreamHandler = thinkingStreamHandler;
    }

    public void notify(OllamaGenerateResponseModel currentResponsePart) {
        this.responseParts.add(currentResponsePart);
        this.handleCurrentResponsePart(currentResponsePart);
    }

    protected void handleCurrentResponsePart(OllamaGenerateResponseModel currentResponsePart) {
        boolean hasThinking;
        String response = currentResponsePart.getResponse();
        String thinking = currentResponsePart.getThinking();
        boolean hasResponse = response != null && !response.isEmpty();
        boolean bl = hasThinking = thinking != null && !thinking.isEmpty();
        if (!hasResponse && hasThinking && this.thinkingStreamHandler != null) {
            this.thinkingStreamHandler.accept(thinking);
        } else if (hasResponse && this.responseStreamHandler != null) {
            this.responseStreamHandler.accept(response);
        }
    }
}

