/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CharStream;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.misc.Interval;

@Internal
public class CodeSplitUtil {
    private static final AtomicLong COUNTER = new AtomicLong(0L);

    public static AtomicLong getCounter() {
        return COUNTER;
    }

    public static String newName(String name) {
        return name + "$" + COUNTER.getAndIncrement();
    }

    public static String getContextString(ParserRuleContext ctx) {
        if (ctx == null) {
            return "";
        }
        CharStream cs = ctx.start.getInputStream();
        return cs.getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    public static int getContextTextLength(ParserRuleContext ctx) {
        return CodeSplitUtil.getContextString(ctx).length();
    }
}

