/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class SharedBufferNode {
    private final List<Lockable<SharedBufferEdge>> edges;

    public SharedBufferNode() {
        this.edges = new ArrayList<Lockable<SharedBufferEdge>>();
    }

    SharedBufferNode(List<Lockable<SharedBufferEdge>> edges) {
        this.edges = edges;
    }

    public List<Lockable<SharedBufferEdge>> getEdges() {
        return this.edges;
    }

    public void addEdge(SharedBufferEdge edge) {
        this.edges.add(new Lockable<SharedBufferEdge>(edge, 0));
    }

    public String toString() {
        return "SharedBufferNode{edges=" + this.edges + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedBufferNode that = (SharedBufferNode)o;
        return Objects.equals(this.edges, that.edges);
    }

    public int hashCode() {
        return Objects.hash(this.edges);
    }

    @Deprecated
    public static class SharedBufferNodeSerializer
    extends TypeSerializerSingleton<SharedBufferNode> {
        private static final long serialVersionUID = -6687780732295439832L;
        private final ListSerializer<SharedBufferEdge> edgesSerializer;

        public SharedBufferNodeSerializer() {
            this.edgesSerializer = new ListSerializer((TypeSerializer)new SharedBufferEdge.SharedBufferEdgeSerializer());
        }

        private SharedBufferNodeSerializer(ListSerializer<SharedBufferEdge> edgesSerializer) {
            this.edgesSerializer = (ListSerializer)Preconditions.checkNotNull(edgesSerializer);
        }

        public boolean isImmutableType() {
            return false;
        }

        public SharedBufferNode createInstance() {
            return new SharedBufferNode(new ArrayList<Lockable<SharedBufferEdge>>());
        }

        public SharedBufferNode copy(SharedBufferNode from) {
            throw new UnsupportedOperationException("Should not be used");
        }

        public SharedBufferNode copy(SharedBufferNode from, SharedBufferNode reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(SharedBufferNode record, DataOutputView target) throws IOException {
            throw new UnsupportedOperationException("We should no longer use it for serialization");
        }

        public SharedBufferNode deserialize(DataInputView source) throws IOException {
            List edges = this.edgesSerializer.deserialize(source);
            SharedBufferNode node = new SharedBufferNode();
            for (SharedBufferEdge edge : edges) {
                node.addEdge(edge);
            }
            return node;
        }

        public SharedBufferNode deserialize(SharedBufferNode reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.edgesSerializer.copy(source, target);
        }

        public TypeSerializerSnapshot<SharedBufferNode> snapshotConfiguration() {
            return new SharedBufferNodeSerializerSnapshot(this);
        }

        public static final class SharedBufferNodeSerializerSnapshot
        extends CompositeTypeSerializerSnapshot<SharedBufferNode, SharedBufferNodeSerializer> {
            private static final int VERSION = 1;

            public SharedBufferNodeSerializerSnapshot() {
            }

            public SharedBufferNodeSerializerSnapshot(SharedBufferNodeSerializer sharedBufferNodeSerializer) {
                super((TypeSerializer)sharedBufferNodeSerializer);
            }

            protected int getCurrentOuterSnapshotVersion() {
                return 1;
            }

            protected SharedBufferNodeSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
                return new SharedBufferNodeSerializer((ListSerializer)nestedSerializers[0]);
            }

            protected TypeSerializer<?>[] getNestedSerializers(SharedBufferNodeSerializer outerSerializer) {
                return new TypeSerializer[]{outerSerializer.edgesSerializer};
            }
        }
    }
}

