/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.result.ChangelogResult;
import org.apache.flink.table.client.gateway.result.CollectResultBase;
import org.apache.flink.table.data.RowData;

public class ChangelogCollectResult
extends CollectResultBase
implements ChangelogResult {
    private final List<RowData> changeRecordBuffer = new ArrayList<RowData>();
    @VisibleForTesting
    protected static final int CHANGE_RECORD_BUFFER_SIZE = 5000;

    public ChangelogCollectResult(StatementResult tableResult) {
        super(tableResult);
        this.retrievalThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<List<RowData>> retrieveChanges() {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.isRetrieving() && this.executionException.get() == null) {
                if (this.changeRecordBuffer.isEmpty()) {
                    return TypedResult.empty();
                }
                ArrayList<RowData> change = new ArrayList<RowData>(this.changeRecordBuffer);
                this.changeRecordBuffer.clear();
                this.resultLock.notify();
                return TypedResult.payload(change);
            }
            if (!this.isRetrieving() && !this.changeRecordBuffer.isEmpty()) {
                ArrayList<RowData> change = new ArrayList<RowData>(this.changeRecordBuffer);
                this.changeRecordBuffer.clear();
                return TypedResult.payload(change);
            }
            return this.handleMissingResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRecord(RowData row) {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.changeRecordBuffer.size() >= 5000) {
                try {
                    this.resultLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.changeRecordBuffer.add(row);
        }
    }
}

