/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.ReplicationException;

public interface LedgerUnderreplicationManager
extends AutoCloseable {
    default public void markLedgerUnderreplicated(long ledgerId, String missingReplica) throws ReplicationException {
        FutureUtils.result(this.markLedgerUnderreplicatedAsync(ledgerId, Lists.newArrayList((Object[])new String[]{missingReplica})), ReplicationException.EXCEPTION_HANDLER);
    }

    public boolean isLedgerBeingReplicated(long var1) throws ReplicationException;

    public CompletableFuture<Void> markLedgerUnderreplicatedAsync(long var1, Collection<String> var3);

    public void markLedgerReplicated(long var1) throws ReplicationException.UnavailableException;

    public UnderreplicatedLedger getLedgerUnreplicationInfo(long var1) throws ReplicationException.UnavailableException;

    public Iterator<UnderreplicatedLedger> listLedgersToRereplicate(Predicate<List<String>> var1);

    public long getLedgerToRereplicate() throws ReplicationException.UnavailableException;

    public long pollLedgerToRereplicate() throws ReplicationException.UnavailableException;

    public void acquireUnderreplicatedLedger(long var1) throws ReplicationException;

    public void releaseUnderreplicatedLedger(long var1) throws ReplicationException.UnavailableException;

    @Override
    public void close() throws ReplicationException.UnavailableException;

    public void disableLedgerReplication() throws ReplicationException.UnavailableException;

    public void enableLedgerReplication() throws ReplicationException.UnavailableException;

    public boolean isLedgerReplicationEnabled() throws ReplicationException.UnavailableException;

    public void notifyLedgerReplicationEnabled(BookkeeperInternalCallbacks.GenericCallback<Void> var1) throws ReplicationException.UnavailableException;

    public boolean initializeLostBookieRecoveryDelay(int var1) throws ReplicationException.UnavailableException;

    public void setLostBookieRecoveryDelay(int var1) throws ReplicationException.UnavailableException;

    public int getLostBookieRecoveryDelay() throws ReplicationException.UnavailableException;

    public void setCheckAllLedgersCTime(long var1) throws ReplicationException.UnavailableException;

    public long getCheckAllLedgersCTime() throws ReplicationException.UnavailableException;

    public void setPlacementPolicyCheckCTime(long var1) throws ReplicationException.UnavailableException;

    public long getPlacementPolicyCheckCTime() throws ReplicationException.UnavailableException;

    public void setReplicasCheckCTime(long var1) throws ReplicationException.UnavailableException;

    public long getReplicasCheckCTime() throws ReplicationException.UnavailableException;

    @Deprecated
    default public void notifyUnderReplicationLedgerChanged(BookkeeperInternalCallbacks.GenericCallback<Void> cb) throws ReplicationException.UnavailableException {
    }

    public void notifyLostBookieRecoveryDelayChanged(BookkeeperInternalCallbacks.GenericCallback<Void> var1) throws ReplicationException.UnavailableException;

    public String getReplicationWorkerIdRereplicatingLedger(long var1) throws ReplicationException.UnavailableException;
}

