/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import io.grpc.Status;
import io.grpc.StreamTracer;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public interface TestStreamTracer {
    public void await() throws InterruptedException;

    public boolean await(long var1, TimeUnit var3) throws InterruptedException;

    public Status getStatus();

    public long getInboundWireSize();

    public long getInboundUncompressedSize();

    public long getOutboundWireSize();

    public long getOutboundUncompressedSize();

    public void setFailDuplicateCallbacks(boolean var1);

    @Nullable
    public String nextOutboundEvent();

    public String nextInboundEvent();

    public static class TestBaseStreamTracer
    extends StreamTracer
    implements TestStreamTracer {
        protected final AtomicLong outboundWireSize = new AtomicLong();
        protected final AtomicLong inboundWireSize = new AtomicLong();
        protected final AtomicLong outboundUncompressedSize = new AtomicLong();
        protected final AtomicLong inboundUncompressedSize = new AtomicLong();
        protected final LinkedBlockingQueue<String> outboundEvents = new LinkedBlockingQueue();
        protected final LinkedBlockingQueue<String> inboundEvents = new LinkedBlockingQueue();
        protected final AtomicReference<Status> streamClosedStatus = new AtomicReference();
        protected final AtomicReference<Throwable> streamClosedStack = new AtomicReference();
        protected final CountDownLatch streamClosed = new CountDownLatch(1);
        protected final AtomicBoolean failDuplicateCallbacks = new AtomicBoolean(true);

        @Override
        public void await() throws InterruptedException {
            this.streamClosed.await();
        }

        @Override
        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.streamClosed.await(timeout, timeUnit);
        }

        @Override
        public Status getStatus() {
            return this.streamClosedStatus.get();
        }

        @Override
        public long getInboundWireSize() {
            return this.inboundWireSize.get();
        }

        @Override
        public long getInboundUncompressedSize() {
            return this.inboundUncompressedSize.get();
        }

        @Override
        public long getOutboundWireSize() {
            return this.outboundWireSize.get();
        }

        @Override
        public long getOutboundUncompressedSize() {
            return this.outboundUncompressedSize.get();
        }

        public void outboundWireSize(long bytes) {
            this.outboundWireSize.addAndGet(bytes);
        }

        public void inboundWireSize(long bytes) {
            this.inboundWireSize.addAndGet(bytes);
        }

        public void outboundUncompressedSize(long bytes) {
            this.outboundUncompressedSize.addAndGet(bytes);
        }

        public void inboundUncompressedSize(long bytes) {
            this.inboundUncompressedSize.addAndGet(bytes);
        }

        public void streamClosed(Status status) {
            this.streamClosedStack.compareAndSet(null, new Throwable("first call"));
            if (!this.streamClosedStatus.compareAndSet(null, status)) {
                if (this.failDuplicateCallbacks.get()) {
                    throw new AssertionError("streamClosed called more than once", this.streamClosedStack.get());
                }
            } else {
                this.streamClosed.countDown();
            }
        }

        public void inboundMessage(int seqNo) {
            this.inboundEvents.add("inboundMessage(" + seqNo + ")");
        }

        public void outboundMessage(int seqNo) {
            this.outboundEvents.add("outboundMessage(" + seqNo + ")");
        }

        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            this.outboundEvents.add(String.format(Locale.US, "outboundMessageSent(%d, %d, %d)", seqNo, optionalWireSize, optionalUncompressedSize));
        }

        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            this.inboundEvents.add(String.format(Locale.US, "inboundMessageRead(%d, %d, %d)", seqNo, optionalWireSize, optionalUncompressedSize));
        }

        @Override
        public void setFailDuplicateCallbacks(boolean fail) {
            this.failDuplicateCallbacks.set(fail);
        }

        @Override
        public String nextOutboundEvent() {
            return this.outboundEvents.poll();
        }

        @Override
        public String nextInboundEvent() {
            return this.inboundEvents.poll();
        }
    }
}

