/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInterleavedReaders
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestInterleavedReaders.class);

    private int drainStreams(LogReader reader0, int num0, LogReader reader1, int num1) throws Exception {
        LogRecordWithDLSN record;
        Thread.sleep(15L);
        int numTrans = 0;
        int i = 0;
        while (i < num0) {
            record = reader0.readNext(false);
            if (null == record) continue;
            Assert.assertTrue((record.getTransactionId() % 2L == 0L ? 1 : 0) != 0);
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++numTrans;
            ++i;
            LOG.info("Read record {}", (Object)record);
        }
        i = 0;
        while (i < num1) {
            record = reader1.readNext(false);
            if (null == record) continue;
            Assert.assertTrue((record.getTransactionId() % 2L == 1L ? 1 : 0) != 0);
            DLMTestUtil.verifyLogRecord((LogRecord)record);
            ++numTrans;
            ++i;
            LOG.info("Read record {}", (Object)record);
        }
        return numTrans;
    }

    @Test(timeout=60000L)
    public void testInterleavedReaders() throws Exception {
        String name = "distrlog-interleaved";
        BKDistributedLogManager dlmwrite0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmreader0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmwrite1 = this.createNewDLM(conf, name + "-1");
        BKDistributedLogManager dlmreader1 = this.createNewDLM(conf, name + "-1");
        LogReader reader0 = null;
        LogReader reader1 = null;
        long txid = 1L;
        int numTrans = 0;
        BKAsyncLogWriter writer0 = dlmwrite0.startAsyncLogSegmentNonPartitioned();
        BKAsyncLogWriter writer1 = dlmwrite1.startAsyncLogSegmentNonPartitioned();
        for (long j = 1L; j <= 4L; ++j) {
            for (int k = 1; k <= 10; ++k) {
                Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(txid++)));
                Utils.ioResult((CompletableFuture)writer0.write(DLMTestUtil.getLogRecordInstance(txid++)));
            }
            Utils.ioResult((CompletableFuture)writer1.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            Utils.ioResult((CompletableFuture)writer0.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            if (null == reader0) {
                reader0 = dlmreader0.getInputStream(1L);
            }
            if (null == reader1) {
                reader1 = dlmreader1.getInputStream(1L);
            }
            Assert.assertEquals((long)(txid - 1L), (long)(numTrans += this.drainStreams(reader0, 10, reader1, 10)));
        }
        reader0.close();
        reader1.close();
        dlmreader0.close();
        dlmwrite0.close();
        dlmreader1.close();
        dlmwrite1.close();
    }

    @Test(timeout=60000L)
    public void testInterleavedReadersWithRollingEdge() throws Exception {
        String name = "distrlog-interleaved-rolling-edge";
        BKDistributedLogManager dlmwrite0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmreader0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmwrite1 = this.createNewDLM(conf, name + "-1");
        BKDistributedLogManager dlmreader1 = this.createNewDLM(conf, name + "-1");
        LogReader reader0 = null;
        LogReader reader1 = null;
        long txid = 1L;
        int numTrans = 0;
        BKAsyncLogWriter writer0 = dlmwrite0.startAsyncLogSegmentNonPartitioned();
        BKAsyncLogWriter writer1 = dlmwrite1.startAsyncLogSegmentNonPartitioned();
        for (long j = 1L; j <= 4L; ++j) {
            if (j > 1L) {
                writer0.setForceRolling(true);
                writer1.setForceRolling(true);
            }
            for (int k = 1; k <= 2; ++k) {
                Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(txid++)));
                Utils.ioResult((CompletableFuture)writer0.write(DLMTestUtil.getLogRecordInstance(txid++)));
                writer0.setForceRolling(false);
                writer1.setForceRolling(false);
            }
            Utils.ioResult((CompletableFuture)writer1.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            Utils.ioResult((CompletableFuture)writer0.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            LOG.info("Completed {} write", (Object)j);
            if (null == reader0) {
                reader0 = dlmreader0.getInputStream(1L);
            }
            if (null == reader1) {
                reader1 = dlmreader1.getInputStream(1L);
            }
            Assert.assertEquals((long)(txid - 1L), (long)(numTrans += this.drainStreams(reader0, 2, reader1, 2)));
        }
        reader0.close();
        reader1.close();
        dlmreader0.close();
        dlmwrite0.close();
        dlmreader1.close();
        dlmwrite1.close();
    }

    @Test(timeout=60000L)
    public void testInterleavedReadersWithRolling() throws Exception {
        String name = "distrlog-interleaved-rolling";
        BKDistributedLogManager dlmwrite0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmreader0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmwrite1 = this.createNewDLM(conf, name + "-1");
        BKDistributedLogManager dlmreader1 = this.createNewDLM(conf, name + "-1");
        LogReader reader0 = null;
        LogReader reader1 = null;
        long txid = 1L;
        int numTrans = 0;
        BKAsyncLogWriter writer0 = dlmwrite0.startAsyncLogSegmentNonPartitioned();
        BKAsyncLogWriter writer1 = dlmwrite1.startAsyncLogSegmentNonPartitioned();
        for (long j = 1L; j <= 2L; ++j) {
            for (int k = 1; k <= 6; ++k) {
                if (k == 3) {
                    writer0.setForceRolling(true);
                    writer1.setForceRolling(true);
                }
                Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(txid++)));
                Utils.ioResult((CompletableFuture)writer0.write(DLMTestUtil.getLogRecordInstance(txid++)));
                writer0.setForceRolling(false);
                writer1.setForceRolling(false);
            }
            Utils.ioResult((CompletableFuture)writer1.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            Utils.ioResult((CompletableFuture)writer0.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            if (null == reader0) {
                reader0 = dlmreader0.getInputStream(1L);
            }
            if (null == reader1) {
                reader1 = dlmreader1.getInputStream(1L);
            }
            Assert.assertEquals((long)(txid - 1L), (long)(numTrans += this.drainStreams(reader0, 6, reader1, 6)));
        }
        reader0.close();
        reader1.close();
        dlmreader0.close();
        dlmwrite0.close();
        dlmreader1.close();
        dlmwrite1.close();
    }

    @Test(timeout=60000L)
    public void testInterleavedReadersWithCleanup() throws Exception {
        String name = "distrlog-interleaved-cleanup";
        BKDistributedLogManager dlmwrite0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmwrite1 = this.createNewDLM(conf, name + "-1");
        long txid = 1L;
        Long retentionPeriodOverride = null;
        BKAsyncLogWriter writer0 = dlmwrite0.startAsyncLogSegmentNonPartitioned();
        BKAsyncLogWriter writer1 = dlmwrite1.startAsyncLogSegmentNonPartitioned();
        for (long j = 1L; j <= 4L; ++j) {
            for (int k = 1; k <= 10; ++k) {
                if (k == 5) {
                    writer0.setForceRolling(true);
                    writer0.overRideMinTimeStampToKeep(retentionPeriodOverride);
                    writer1.setForceRolling(true);
                    writer1.overRideMinTimeStampToKeep(retentionPeriodOverride);
                }
                DLSN dlsn1 = (DLSN)Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(txid++)));
                LOG.info("writer1 write record {}", (Object)dlsn1);
                DLSN dlsn0 = (DLSN)Utils.ioResult((CompletableFuture)writer0.write(DLMTestUtil.getLogRecordInstance(txid++)));
                LOG.info("writer0 write record {}", (Object)dlsn0);
                if (k == 5) {
                    writer0.setForceRolling(false);
                    writer1.setForceRolling(false);
                    retentionPeriodOverride = System.currentTimeMillis();
                }
                Thread.sleep(5L);
            }
            Utils.ioResult((CompletableFuture)writer1.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            Utils.ioResult((CompletableFuture)writer0.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
        }
        writer0.close();
        writer1.close();
        BKDistributedLogManager dlmreader0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmreader1 = this.createNewDLM(conf, name + "-1");
        LogReader reader0 = dlmreader0.getInputStream(1L);
        LogReader reader1 = dlmreader1.getInputStream(1L);
        int numTrans = this.drainStreams(reader0, 15, reader1, 15);
        Assert.assertEquals((long)30L, (long)numTrans);
        reader0.close();
        reader1.close();
        dlmreader0.close();
        dlmwrite0.close();
        dlmreader1.close();
        dlmwrite1.close();
    }

    @Test(timeout=60000L)
    public void testInterleavedReadersWithRecovery() throws Exception {
        String name = "distrlog-interleaved-recovery";
        BKDistributedLogManager dlmwrite0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmreader0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmwrite1 = this.createNewDLM(conf, name + "-1");
        BKDistributedLogManager dlmreader1 = this.createNewDLM(conf, name + "-1");
        LogReader reader0 = null;
        LogReader reader1 = null;
        long txid = 1L;
        int numTrans = 0;
        BKAsyncLogWriter writer0 = dlmwrite0.startAsyncLogSegmentNonPartitioned();
        BKAsyncLogWriter writer1 = dlmwrite1.startAsyncLogSegmentNonPartitioned();
        for (long j = 1L; j <= 2L; ++j) {
            for (int k = 1; k <= 6; ++k) {
                if (k == 3) {
                    writer0.setForceRecovery(true);
                    writer1.setForceRecovery(true);
                }
                DLSN dlsn1 = (DLSN)Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(txid++)));
                LOG.info("writer1 write record {} - txid = {}", (Object)dlsn1, (Object)(txid - 1L));
                DLSN dlsn0 = (DLSN)Utils.ioResult((CompletableFuture)writer0.write(DLMTestUtil.getLogRecordInstance(txid++)));
                LOG.info("writer0 write record {} - txid = {}", (Object)dlsn0, (Object)(txid - 1L));
                writer0.setForceRecovery(false);
                writer1.setForceRecovery(false);
            }
            Utils.ioResult((CompletableFuture)writer1.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            Utils.ioResult((CompletableFuture)writer0.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            if (null == reader0) {
                reader0 = dlmreader0.getInputStream(1L);
            }
            if (null == reader1) {
                reader1 = dlmreader1.getInputStream(1L);
            }
            Assert.assertEquals((long)(txid - 1L), (long)(numTrans += this.drainStreams(reader0, 6, reader1, 6)));
        }
        reader0.close();
        reader1.close();
        Assert.assertEquals((long)(txid - 1L), (long)(dlmreader0.getLogRecordCount() + dlmreader1.getLogRecordCount()));
        dlmreader0.close();
        dlmwrite0.close();
        dlmreader1.close();
        dlmwrite1.close();
    }

    @Test(timeout=60000L)
    public void testInterleavedReadersWithRollingEdgeUnPartitioned() throws Exception {
        String name = "distrlog-interleaved-rolling-edge-unpartitioned";
        BKDistributedLogManager dlmwrite0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmreader0 = this.createNewDLM(conf, name + "-0");
        BKDistributedLogManager dlmwrite1 = this.createNewDLM(conf, name + "-1");
        BKDistributedLogManager dlmreader1 = this.createNewDLM(conf, name + "-1");
        LogReader reader0 = null;
        LogReader reader1 = null;
        long txid = 1L;
        int numTrans = 0;
        BKAsyncLogWriter writer0 = dlmwrite0.startAsyncLogSegmentNonPartitioned();
        BKAsyncLogWriter writer1 = dlmwrite1.startAsyncLogSegmentNonPartitioned();
        for (long j = 1L; j <= 4L; ++j) {
            if (j > 1L) {
                writer0.setForceRolling(true);
                writer1.setForceRolling(true);
            }
            for (int k = 1; k <= 2; ++k) {
                Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(txid++)));
                Utils.ioResult((CompletableFuture)writer0.write(DLMTestUtil.getLogRecordInstance(txid++)));
                writer0.setForceRolling(false);
                writer1.setForceRolling(false);
            }
            Utils.ioResult((CompletableFuture)writer1.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            Utils.ioResult((CompletableFuture)writer0.writeControlRecord(DLMTestUtil.getLogRecordInstance(txid - 1L)));
            if (null == reader0) {
                reader0 = dlmreader0.getInputStream(1L);
            }
            if (null == reader1) {
                reader1 = dlmreader1.getInputStream(1L);
            }
            Assert.assertEquals((long)(txid - 1L), (long)(numTrans += this.drainStreams(reader0, 2, reader1, 2)));
        }
        reader0.close();
        reader1.close();
        dlmreader0.close();
        dlmreader1.close();
    }

    static {
        conf.setOutputBufferSize(0);
        conf.setImmediateFlushEnabled(true);
    }
}

