/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZooKeeperServerShutdownTest
extends ZKTestCase {
    @Test
    void testLearnerZooKeeperServerShutdown(@TempDir File tmpDir) throws Exception {
        File tmpFile = File.createTempFile("test", ".dir", tmpDir);
        tmpFile.delete();
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpFile, tmpFile);
        ShutdownTrackLearnerZooKeeperServer zooKeeperServer = new ShutdownTrackLearnerZooKeeperServer(logFactory, new QuorumPeer());
        zooKeeperServer.startup();
        zooKeeperServer.shutdown(false);
        Assertions.assertTrue((boolean)zooKeeperServer.getFirstProcessor().shutdown);
        Assertions.assertFalse((boolean)zooKeeperServer.getSyncRequestProcessor().isAlive());
    }

    public static class ShutdownTrackLearnerZooKeeperServer
    extends LearnerZooKeeperServer {
        public ShutdownTrackLearnerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self) throws IOException {
            super(logFactory, 2000, 2000, 2000, -1, new ZKDatabase(logFactory), self);
        }

        protected void setupRequestProcessors() {
            this.firstProcessor = new ShutdownTrackRequestProcessor();
            this.syncProcessor = new SyncRequestProcessor((ZooKeeperServer)this, null);
            this.syncProcessor.start();
        }

        ShutdownTrackRequestProcessor getFirstProcessor() {
            return (ShutdownTrackRequestProcessor)this.firstProcessor;
        }

        SyncRequestProcessor getSyncRequestProcessor() {
            return this.syncProcessor;
        }

        public Learner getLearner() {
            return null;
        }
    }

    static class ShutdownTrackRequestProcessor
    implements RequestProcessor {
        boolean shutdown = false;

        ShutdownTrackRequestProcessor() {
        }

        public void processRequest(Request request) throws RequestProcessor.RequestProcessorException {
        }

        public void shutdown() {
            this.shutdown = true;
        }
    }
}

