# coding: utf-8

"""
    Airflow API

    Airflow API. All endpoints located under ``/api/v2`` can be used safely, are stable and backward compatible. Endpoints located under ``/ui`` are dedicated to the UI and are subject to breaking change depending on the need of the frontend. Users should not rely on those but use the public ones instead.

    The version of the OpenAPI document: 2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from airflow_client.client.models.dag_run_asset_reference import DagRunAssetReference
from typing import Optional, Set
from typing_extensions import Self

class AssetEventResponse(BaseModel):
    """
    Asset event serializer for responses.
    """ # noqa: E501
    asset_id: StrictInt
    created_dagruns: List[DagRunAssetReference]
    extra: Optional[Dict[str, Any]] = None
    group: Optional[StrictStr] = None
    id: StrictInt
    name: Optional[StrictStr] = None
    source_dag_id: Optional[StrictStr] = None
    source_map_index: StrictInt
    source_run_id: Optional[StrictStr] = None
    source_task_id: Optional[StrictStr] = None
    timestamp: datetime
    uri: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["asset_id", "created_dagruns", "extra", "group", "id", "name", "source_dag_id", "source_map_index", "source_run_id", "source_task_id", "timestamp", "uri"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetEventResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in created_dagruns (list)
        _items = []
        if self.created_dagruns:
            for _item_created_dagruns in self.created_dagruns:
                if _item_created_dagruns:
                    _items.append(_item_created_dagruns.to_dict())
            _dict['created_dagruns'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetEventResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asset_id": obj.get("asset_id"),
            "created_dagruns": [DagRunAssetReference.from_dict(_item) for _item in obj["created_dagruns"]] if obj.get("created_dagruns") is not None else None,
            "extra": obj.get("extra"),
            "group": obj.get("group"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "source_dag_id": obj.get("source_dag_id"),
            "source_map_index": obj.get("source_map_index"),
            "source_run_id": obj.get("source_run_id"),
            "source_task_id": obj.get("source_task_id"),
            "timestamp": obj.get("timestamp"),
            "uri": obj.get("uri")
        })
        return _obj


