/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.CopyableDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.HasExpressionType;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@AsPredicate
@XmlRootElement(name="onWhen")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnWhenDefinition
extends OptionalIdentifiedDefinition<OnWhenDefinition>
implements HasExpressionType,
CopyableDefinition<OnWhenDefinition> {
    @XmlElementRef
    private ExpressionDefinition expression;

    public OnWhenDefinition() {
    }

    protected OnWhenDefinition(OnWhenDefinition source) {
        super(source);
        this.expression = source.expression != null ? source.expression.copyDefinition() : null;
    }

    public OnWhenDefinition(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(predicate));
        }
    }

    public OnWhenDefinition(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public OnWhenDefinition copyDefinition() {
        return new OnWhenDefinition(this);
    }

    public String toString() {
        return "OnWhen[" + this.description() + "]";
    }

    protected String description() {
        StringBuilder sb = new StringBuilder(256);
        if (this.getExpression() != null) {
            String language = this.getExpression().getLanguage();
            if (language != null) {
                sb.append(language).append("{");
            }
            sb.append(this.getExpression().getLabel());
            if (language != null) {
                sb.append("}");
            }
        }
        return sb.toString();
    }

    public String getShortName() {
        return "onWhen";
    }

    public String getLabel() {
        return "onWhen[" + this.description() + "]";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public ExpressionDefinition getExpressionType() {
        return this.getExpression();
    }

    @Override
    public void setExpressionType(ExpressionDefinition expressionType) {
        this.setExpression(expressionType);
    }

    public void preCreateProcessor() {
        ExpressionFactory model;
        ExpressionClause clause;
        ExpressionDefinition exp = this.getExpression();
        if (this.getExpression() != null && this.getExpression().getExpressionValue() != null) {
            exp = this.getExpression().getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)((Object)exp)).getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
            ExpressionDefinition expressionDefinition = (ExpressionDefinition)model;
            this.setExpression(expressionDefinition);
        }
        if (this.getExpression() != null && this.getExpression().getExpression() == null) {
            if (this.getExpression().getPredicate() != null) {
                this.getExpression().setExpression(this.getExpression().getPredicate().toString());
            } else if (this.getExpression().getExpressionValue() != null) {
                this.getExpression().setExpression(this.getExpression().getExpressionValue().toString());
            }
        }
    }
}

