/*  ZA2 testone program for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#include <linux/soundcard.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>

unsigned int r;
short *blockptr,*ptr;
int s;

int h,a,i=0;

void usage(char *n)
{
  printf("Usage:\n  %s [-s sampling frequency] [-t time] [-f frequency] [-h] [-S]\n",n);
  printf(" Description of the parameters:\n"
	 "  -s sampling frequency : sampling frequency should be an integer between 32000\n"
	 "                          and 60000 Hz, which are the allowed rates for the ZA2\n"
	 "                          (this parameter is not checked by the programme but by\n"
	 "                          the driver, so in principle, you can also use other\n"
	 "                          sample rates). Default: 44100 Hz\n"
	 "  -t time :               time is the length of the testone in seconds. It\n"
	 "                          should be an arbitrary integer. Default: 10 s\n"
	 "  -f frequency :          frequency specifies the tone played on the right\n"
	 "                          channel (on the left channel, you will here just\n"
	 "                          clicks). It should be an integer between 0 and the\n"
	 "                          half sampling frequency (this is checked by the\n"
	 "                          programme). Default: 500 Hz\n"
	 "  -S :                    Swaps the channel, so you'll hear the clicking on the\n"
	 "                          right and the tone on the left. Default: not swapped\n"
	 "  -h :                    displays this help text and exits immediately\n");
  exit(0);
}

int main(int argc,char *argv[])
{
  int ch,sf=44100,freq=500,t=10,bufsize,step,swap=0;
  double ti;
  printf("Test tone V2.02\nModified by Peter Wahl for the Linux driver of the ZA2\n"
	 "Use %s -h for help.\n",argv[0]);
  printf("You should be hearing:\n"
         "  A steady clicking on the LEFT channel (triangle/sawtooth tone)\n"
         "  A pure tone on the RIGHT channel (sine wave at 0db)\n");
  while((ch=getopt(argc,argv,"s:t:f:Sh"))!=EOF)
    {
      switch(ch)
	{
	case 's' : sf=atoi(optarg);
	  break;
	case 't' : t=atoi(optarg); 
	  break;
	case 'f' : freq=atoi(optarg);
	  break;
	case 'S' : swap=1;
	  break;
	case 'h' : usage(argv[0]);
	}
    }
  h=open("/dev/dsp",O_WRONLY);
  a=1; ioctl(h,SNDCTL_DSP_STEREO,&a);
  a=sf; ioctl(h,SNDCTL_DSP_SPEED,&a);
  if(sf!=a) 
    {
      printf("Switched to sampling frequency %d Hz instead of %d Hz ...\n",a,sf);
      sf=a;
    }
  if(freq>(sf/2)) 
    {
      printf("Switched tone frequency to %d Hz instead of %d Hz ...\n",sf/2,freq);
      freq=sf/2;
    }
  bufsize=sf*2/freq;
  while((double)(bufsize>>1)/(double)sf<0.5)
    bufsize<<=1;
  bufsize&=0xfffffffe;
  step=2*65536/bufsize;
  a=AFMT_S16_LE; ioctl(h,SNDCTL_DSP_SETFMT,&a);
  ptr=blockptr=(short *)malloc(bufsize<<1);
  s = 32766;
  ti=2.0*M_PI*(double)freq/(double)sf;
  for(r=0,s=32766;r<(bufsize>>1);r++,s-=step)
    if(swap)
      {
	*ptr++=(int)(32767*sin(ti*(double)r));
	*ptr++=s;
      }
    else
      {
        *ptr++=s;
        *ptr++= (int)(32767*sin(ti*(double)r));
      }
  ti=(double)t;
  while(ti>0.0)
    {
      i++;
      write(h,blockptr,bufsize<<1);
      ti-=(double)(bufsize>>1)/sf;
      if(!(i%freq)) { printf("."); fflush(stdout); }
    }
  printf("\n Bye\n");
  close(h);
  return(0); 
}
