/*  ZA2 Readubits for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#include <stdio.h>
#include <fcntl.h>
#include <linux/soundcard.h>

#include "../driver/za2specials.h"

int get_char(za2ubits_t *bits,int n)
{
  int r=0,b,i;
  for(b=0x20,i=0;i<7;b>>=1,i++)
    if(bits->bits[8+n*6+i]&2) r|=b;
  return r;
}

int getnibble(za2ubits_t *bits,int n)
{
  int r=0,b,i;
  for(b=8,i=0;i<4;b>>=1,i++)
    if(bits->bits[n*4+i]&2) r|=b;
  return r;
}

int getbyte(za2ubits_t *bits,int n)
{
  int r=0,b,i;
  for(b=0x80,i=0;i<8;b>>=1,i++)
    if(bits->bits[n*8+i]&2) r|=b;
  return r;
}

int main(int argc,char *argv[])
{
  int mix,res,b,s1,i;
  za2ubits_t bits;
  mix=open("/dev/mixer",O_RDONLY);
  if(!mix)
    {
      printf("%s: Can't open mixer device !\n",argv[0]);
      return -1;
    }
  ioctl(mix,SOUND_MIXER_READ_RECSRC,&res);
  printf("Input: ");
  switch(res)
    {
    case SOUND_MASK_DIGITAL1 : printf("Toslink\n");
      break;
    case SOUND_MASK_DIGITAL2 : printf("Coaxial\n");
      break;
    case SOUND_MASK_DIGITAL3 : printf("AES/EBU\n");
      break;
    default:
      printf("Error\nAborting ...\n");
      close(mix);
      return 1;
    }
  b=ioctl(mix,SOUND_MIXER_ZA2GETUBITS,&bits);
  close(mix);
  if(b) 
    {
      printf("Error reading UBITS !\nAborting ...\n");
      return 1;
    }
  s1=getbyte(&bits,0);
  printf("Got Ubit-block %d.\n",s1&0x0f);
  switch(s1&0x0f)
    {
    case 1 :
      printf("Emphasis: ");
      if(s1&0x10) printf("On\n");
      else printf("Off\n");
      printf("SCMS: ");
      if(s1&0x20) printf("Off\n");
      else printf("On\n");
      printf("Input: ");
      if(s1&0x40) printf("Data\n");
      else printf("Audio\n");
      printf("Track : %02x\n",getbyte(&bits,1));
      if(getbyte(&bits,2))
	printf("Track time : ");
      else printf("Remaining track time : -");
      printf("%02x:%02x:%02x\n",getbyte(&bits,3),getbyte(&bits,4),getbyte(&bits,5));
      printf("A-time: %02x:%02x:%02x\n",getbyte(&bits,6),getbyte(&bits,7),getbyte(&bits,8));
      break;
    case 2 :
      printf("Catalog Number: ");
      for(i=2;i<15;i++)
	printf("%1x",getnibble(&bits,i));
      printf("\n");
    case 3 :
      printf("Country: ");
      for(i=0;i<2;i++)
	printf("%c",get_char(&bits,i));
      printf("\n");
      printf("Owner: ");
      for(i=2;i<5;i++)
	printf("%c",get_char(&bits,i));
      printf("\n");
      printf("Year: %02x\n",getbyte(&bits,5));
      printf("Serial #: ");
      for(i=12;i<17;i++)
	printf("%1x",getnibble(&bits,i));
      printf("\n");
    }      
}


