/*  ZA2 Readcbits for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#include <stdio.h>
#include <fcntl.h>
#include <linux/soundcard.h>

#include "../driver/za2specials.h"
#include "../driver/cbits.h"

int main(int argc,char *argv[])
{
  int mix,res,b;
  mix=open("/dev/mixer",O_RDONLY);
  if(!mix)
    {
      printf("%s: Can't open mixer device !\n",argv[0]);
      return -1;
    }
  ioctl(mix,SOUND_MIXER_READ_RECSRC,&res);
  printf("Input: ");
  switch(res)
    {
    case SOUND_MASK_DIGITAL1 : printf("Toslink\n");
      break;
    case SOUND_MASK_DIGITAL2 : printf("Coaxial\n");
      break;
    case SOUND_MASK_DIGITAL3 : printf("AES/EBU\n");
      break;
    default:
      printf("Error\nAborting ...\n");
      close(mix);
      return 1;
    }
  ioctl(mix,SOUND_MIXER_ZA2GETCBITS,&res);
  close(mix);
  if(!res) 
    {
      printf("Error reading CBITS !\nAborting ...\n");
      return 1;
    }
  printf("CBITS:\n");
  if(res&AESO_FIELD) printf("AES/EBU Stream, ");
  else printf("S/PDIF-Stream, ");
  if(res&DATA_FIELD) printf("Non-audio, ");
  else printf("Audio, ");
  if(res&SCMS_FIELD) printf("SCMS enabled\n");
  else printf("SCMS disabled\n");
  printf("Preemphasis: ");
  if((res&EMPH_FIELD)&(2<<3)) 
    printf("Reserved - 2 channel audio\n");
  else if((res&EMPH_FIELD)&(4<<3))
    printf("Reserved - 4 channel audio\n");
  else switch(res&EMPH_FIELD)
    {
    case 0 : printf("None - 2 channel audio\n");
      break;
    case (1<<3) : printf("50/15 s - 2 channel audio\n");
    }
  if(!(res&MODE_FIELD))
    {
      printf("Category: ");
      b=(res&CAT_FIELD)>>8;
      switch(b&3)
	{
	case 0 : printf("General, ");
	  if(b&4) printf("Broadcast\n");
	  else printf("Experimental\n");
	  break;
	case 1 : printf("read-only, ");
	  if(b&4) printf("musical instrument or microphone\n");
	  else 
	    {
	      printf("Laser optical");
	      switch(b&0xf8)
		{
		case 0 : printf(": CD\n");
		  break;
		case 8 : printf(": CD - IEC908 incompatible\n");
		  break;
		case 0x48 : printf(": Minidisc\n"); 
		}
	    }
	  break;
	case 2 : 
	  if(b&4) printf("A/D-converter\n");
	  else printf("D/D-converter\n");
	  break;
	case 3 : printf("read-write, ");
	  if((b&0xfc)==0x40) printf("DCC\n");
	  else if((b&0xfc)==0) printf("DAT\n");
	  else if((b&0xfc)==8) printf("Digital audio sound VCR\n");
	  else printf("Magnetic tape or disc\n");
	}
      if(((b&7)==1) || ((b&7)==4) || ((b&0xf)==0xe))
	b=res&ORIG_FIELD;
      else b=!(res&ORIG_FIELD);
      printf("Generation: ");
      if(b) printf("no indication\n");
      else printf("original/commercially pre-recorded data\n");
      printf("Source: ");
      if(!(res&SRC_FIELD)) printf("unspecified\n");
      else printf("%d\n",(res&SRC_FIELD)>>16);
      printf("Channel: ");
      if(!(res&CHA_FIELD)) printf("unspecified\n");
      else printf("%d\n",(res&CHA_FIELD)>>20);
      printf("Sampling rate: ");
      switch((res&SRATE_FIELD)>>24)
	{
	case 0 : printf("44.1kHz\n");
	  break;
	case 2 : printf("48kHz\n");
	  break;
	case 3 : printf("32kHz or sample rate converter\n");
	  break;
	default: printf("Reserved\n");
	}
      printf("Clock accuracy: \n");
      switch((res&CLK_FIELD)>>28)
	{
	case 0 : printf("+/- 0.1 \% (normal)\n");
	  break;
	case 1 : printf("+/- 0.005 \% (high accuracy)\n");
	  break;
	case 2 : printf("Variable pitch\n");
	  break;
	case 3 : printf("Reserved\n");
	}
    }
  else printf("Unknown mode!\n");
}

