/*  ZA2 playback program for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#include <linux/soundcard.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

#define BUFSIZE 30000

struct wav_header
{
  unsigned int magic,tot_len,unkn1,unkn2,head_size,unkn3,srate,srate2,attrib;
} wave_head;

void usage(char *n)
{
  printf("This is a player for raw sound files for Linux.\n");
  printf("Usage:\n  %s [-f sampling frequency] [-s] [-r] [-h] file1 ...\n",n);
  printf(" Description of the parameters:\n"
	 "  -f sampling frequency : switch to the desired sampling frequency and\n"
	 "                          play the sound files with it. This is usefull\n"
	 "                          because there's no additional information in\n"
	 "                          raw sound files about sampling frequency or\n"
	 "                          other parameters (so you could also listen\n"
	 "                          to emacs ...). Default: 44100\n"
	 "  -r :                    play the titles repeatedly (this means that you\n"
	 "                          have to stop the program by killing it (by\n"
	 "                          pressing <CTRL>-C or killing it explicitly).\n"
	 "                          Default: don't repeat\n"
	 "  -R :                    force raw mode. Default: Wav\n"
	 "  -s :                    shuffle the titles before playing, so that\n"
	 "                          they are played in a random order.\n"
	 "                          Default: don't shuffle\n"
	 "  -h :                    displays this help text and exits immediately.\n"
	 " file1 ... :              one or more filenames of raw files to be played ...\n");
  exit(0);
}

int loadheader(int fh)
{
  long rest[2];
  read(fh,&wave_head,sizeof(wave_head));
  if((wave_head.magic!=0x46464952)||(wave_head.unkn1!=0x45564157)||
     (wave_head.unkn2!=0x20746d66)||(wave_head.unkn3!=0x20001))
    return -1;
  if(wave_head.attrib&7!=4)
    return -1;
  if(wave_head.attrib&0x100000!=0x100000)
    return -1;
  if((wave_head.srate<20000) || (wave_head.srate>60000))
    return -1;
  if(wave_head.head_size!=0x10) lseek(fh,wave_head.head_size-0x10,SEEK_CUR);
  read(fh,&rest,2*sizeof(int));
  if(rest[0]==0x61746164)
    return wave_head.srate;
  else
    return -1;
}

int main(int argc, char *argv[])
{
  int f,g,a,b,i,n,randflag=0,repeat=0,titles,sf=44100,w=1;
  char buf[BUFSIZE];
  printf("play v1.0\n"
	 "(c) 1999 Peter Wahl\n");
  if(argc>1)
    {
      while((a=getopt(argc,argv,"srRf:h"))!=EOF) 
	  switch(a)
	    {
	    case 's': randflag=1;
	      break;
	    case 'r': repeat=1;
	      break;
	    case 'R': w=0;
	    case 'f': sf=atoi(optarg);
	      break;
	    case 'h' : usage(argv[0]);
	    }
      if(repeat) printf("Please stop the program by pressing <CTRL>-C or by killing it ...\n");
      if((f=open("/dev/dsp",O_WRONLY))==-1) { printf("%s: Can't open /dev/dsp !\n",argv[0]); return(1); }
      a=AFMT_S16_LE; if(ioctl(f,SNDCTL_DSP_SETFMT,&a)) { printf("%s: S16_LE not supported !\n",argv[0]); return(1); }
      a=sf; ioctl(f,SNDCTL_DSP_SPEED,&a); if(a!=sf) printf("%s: Using sampling frequency %d instead of %d !\n",argv[0],a,sf);
      titles=argc-optind;
      for(n=0;(n<titles)||repeat;n++,i=0)
	{
	  if(randflag) b=(int)((double)random()*titles/(RAND_MAX+1.0))+optind;
	  else b=(n%titles)+optind;
	  printf("%s: Playing title %d (%s) ",argv[0],b,argv[b]); fflush(stdout);
	  if((g=open(argv[b],O_RDONLY))==-1) 
	    { printf("%s: Can't open file %s !\n",argv[0],argv[b]); return(1); }
	  sf=loadheader(g);
	  if(w) 
	    {
	      if(sf<0) printf("%s: Error playing wave file %s !\n",argv[0],argv[1]);
	      else ioctl(f,SNDCTL_DSP_SPEED,&a);
	    }
	  else
	    {
	      if(sf<0) 
		{
		  printf("%s: Playing %s as a raw file !\n",argv[0],argv[1]);
		  lseek(g,0,SEEK_SET);
		}
	      else 
		{
		  printf("%s: Playing %s as a wav file !\n",argv[0],argv[1]);
		  ioctl(f,SNDCTL_DSP_SPEED,&a);
		}
	    }
	  a=BUFSIZE;
	  while(a==BUFSIZE)
	    {
	      i++;
	      if((a=read(g,buf,BUFSIZE))!=-1)
		{
		  if(write(f,buf,a)==-1)
		    {
		      printf("\n%s: Error writing to soundcard !\n",argv[0]);
		      return 1;
		    }
		}
	      else 
		{
		  printf("\n%s: Error while reading %s !\n",argv[0],argv[b]);
		  break;
		}
	      if(!(i%10))
		{
		  printf("."); fflush(stdout);
		}
	    }
	  printf("\n");
	  close(g);
	}
      close(f); 
    }
  else
    {
      printf("%s: Not enough arguments !\nUse %s -h for help.\n",argv[0],argv[0]);
      return(1);
    }
}
