/*  ZA2 MP2 playback program for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#include <linux/soundcard.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>

#define BUFSIZE 30000

void usage(char *n)
{
  printf("This is a MP2-player for the Zefiro ZA2 and Linux. It just puts the\n"
	 "ZA2 into MP2-mode and then plays your MP2 files. It does no decompression\n"
	 "itself but relies on the DSP on the ZA2. So it is useless to use it with\n"
	 "primitive sound boards.\n");
  printf("Usage:\n  %s [-s] [-r] [-h] file1 ...\n",n);
  printf(" Description of the parameters:\n"
	 "  -r : play the titles repeatedly (this means that you have to stop\n"
	 "       the program by killing it (by pressing <CTRL>-C or killing it\n"
	 "       explicitly). Default: don't repeat\n"
	 "  -s : shuffle the titles before playing, so that they are played in\n"
	 "       a random order. Default: don't shuffle\n"
	 "  -h : displays this help text and exits immediately.\n"
	 " file1 ... : one or more filenames of MP2 files to be played ...\n");
  exit(0);
}

int mp2info(unsigned char *buf)
{
  if(*buf!=0xff) return(-1);
  buf++;
  if((*buf&0xf0)!=0xf0) return(-1);
  switch(*buf&6)
    {
    case 2 : printf("MPEG Layer 1 not supported !\n");
      return -1;
    case 4 : printf("MPEG Layer 2");
      break;
    case 6 : printf("MPEG Layer 3 not supported !\n");
      return -1;
    }
  if(*buf&1) printf(", no CRC");
  else printf(", with CRC");
  buf++;
  switch(*buf&0xf0)
    {
    case 0 : printf(", 32 kBit/s");
      break;
    case 0x10 : printf(", 48 kBit/s");
      break;
    case 0x20 : printf(", 56 kBit/s");
      break;  
    case 0x30 : printf(", 64 kBit/s");
      break;
    case 0x40 : printf(", 80 kBit/s");
      break;
    case 0x50 : printf(", 96 kBit/s");
      break;
    case 0x60 : printf(", 112 kBit/s");
      break;
    case 0x70 : printf(", 128 kBit/s");
      break;
    case 0x80 : printf(", 160 kBit/s");
      break;
    case 0x90 : printf(", 192 kBit/s");
      break;
    case 0xa0 : printf(", 224 kBit/s");
      break;
    case 0xb0 : printf(", 320 kBit/s");
      break;
    case 0xc0 : printf(", 384 kBit/s");
      break;
    default: printf(", ??? kBit/s");
    }
  switch(*buf&0x0c)
    {
    case 0 : printf(", 44.1 kHz");
      break;
    case 4 : printf(", 48 kHz");
      break;
    case 8 : printf(", 32 kHz");
      break;
    default: printf(", ??? kHz");
    }
  buf++;
  switch(*buf&0xc0)
    {
    case 0 : printf(", stereo\n");
      break;
    case 0x40 : printf(", joint stereo\n");
      break;
    case 0x80 : printf(", dual channel\n");
      break;
    case 0xc0 : printf(", mono\n");
    }
  return(0);
}

int main(int argc, char *argv[])
{
  int f,g,a,b,n=0,i,randflag=0,repeat=0,titles,checkmp2=0;
  char buf[BUFSIZE];
  printf("playmp2 v1.0\n"
	 "(c) 1999 Peter Wahl\n");
  if(argc>1)
    {
      while((a=getopt(argc,argv,"srh"))!=EOF)
	switch(a)
	  {
	  case 's': randflag=1;
	    break;
	  case 'r': repeat=1; 
	    break;
	  case 'h' : usage(argv[0]);
	  }
      if(repeat) printf("Please stop the program by pressing <CTRL>-C or by killing it ...\n");
      if((f=open("/dev/dsp",O_WRONLY))==-1) { printf("%s: Can't open /dev/dsp !\n",argv[0]); return(1); }
      a=AFMT_MPEG; if(ioctl(f,SNDCTL_DSP_SETFMT,&a)) { printf("%s: MPEG2 not supported !\n",argv[0]); return(1); }
      titles=argc-optind;
      for(n=0;(n<titles)||repeat;n++,i=0)
	{
	  if(randflag) b=(int)((double)random()*titles/(RAND_MAX+1.0))+optind;
	  else b=(n%titles)+optind;
	  printf("%s: Playing title %d (%s) ",argv[0],b,argv[b]); fflush(stdout);
	  if((g=open(argv[b],O_RDONLY))==-1) 
	    { printf("%s: Can't open file %s !\n",argv[0],argv[b]); return(1); }
	  else checkmp2=1;
	  a=BUFSIZE;
	  while(a==BUFSIZE)
	    {
	      i++;
	      if((a=read(g,buf,BUFSIZE))!=-1)
		{
		  if(checkmp2)
		    {
		      if(mp2info(buf))
			{
			  printf("\n%s is not a MP2-file !\n",argv[b]);
			  break;
			}
		      checkmp2=0;
		    }
		  if(write(f,buf,a)==-1)
		    {
		      printf("\n%s: Error writing to soundcard !\n",argv[0]);
		      return 1;
		    }
		}
	      else 
		{
		  printf("\n%s: Error while reading %s !\n",argv[0],argv[b]);
		  break;
		}
	      if(!(i%10))
		{
		  printf("."); fflush(stdout);
		}
	    }
	  printf("\n");
	  close(g);
	}
      close(f); 
    }
  else
    {
      printf("%s: Not enough arguments !\nUse %s -h for help.\n",argv[0],argv[0]);
      return(1);
    }
}

