/*  ZA2 Echodsp for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#include <linux/soundcard.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <curses.h>
#include <stdio.h>

#define BUFSIZE 20000
#define ECHOS 5

struct sample
{
  short left,right;
};

void usage(char *n)
{
  printf("This is a echo generator for simultanous play/record for Linux.\n");
  printf("Usage:\n  %s [-t time] [-h] file\n",n);
  printf(" Description of the parameters:\n"
	 "  -t time : echoing time in seconds. It should be an integer, zero\n"
	 "            means infinity. Default: 10s\n"
	 "  -i input: read from input file 'input' instead of /dev/dsp \n"
	 "            Default: read from /dev/dsp \n"
	 "  -s freq : use sampling-frequency freq (in Hz) to play inputfile \n"
	 "            Default: 44100, only usefull with -i inputfile\n"
	 "  -n      : normal output without any effects \n"
	 "  -h      : displays this help text and exits immediately.\n");
  exit(0);
}

int main(int argc,char *argv[])
{
  int f,in=0,i=0,t=10,ch,k=0,n=0,j,s=44100;
  double rec=0.0;
  struct sample samples[ECHOS][BUFSIZE>>2];
  printf("echo v1.0\n"
	 "(c) 1999 Peter Wahl\n"
         "Use %s -h for help.\n",argv[0]);
  while((ch=getopt(argc,argv,"ht:ni:s:"))!=EOF)
    switch(ch)
      {
      case 's' : s=atoi(optarg);
	break;
      case 't' : t=atoi(optarg);
	break;
      case 'n' : n=1;
	break;
      case 'h' : usage(argv[0]);
	break;
      case 'i' : in=open(optarg,O_RDONLY);
	break;
      }
  f=open("/dev/dsp",O_RDWR);
  if(!in) in=f;
  ioctl(f,SNDCTL_DSP_SPEED,&s);
  printf("Echoing "); fflush(stdout); 
  while(((int)rec<t) || (!t))
    {
      if(!read(in,samples[i%ECHOS],BUFSIZE)) rec=(double)t;
      if(!n)
	{
	  for(k=0;k<(BUFSIZE>>2);k++)
	    {
	      samples[i%ECHOS][k].right=samples[i%ECHOS][k].right>>1;
	      samples[i%ECHOS][k].left=samples[i%ECHOS][k].left>>1;
	      if(i>=(ECHOS-1))
		for(j=2;j<ECHOS;j+=2)
		  {
		    samples[i%ECHOS][k].right+=(samples[(i-j)%ECHOS][k].right>>(j));
		    samples[i%ECHOS][k].left+=(samples[(i-j)%ECHOS][k].left>>(j));
		  }
	    }
	}
      if(i>=(ECHOS-1)) 
	write(f,samples[(i+1)%ECHOS],BUFSIZE);
      i++;
      if(!(i%10))
	{
	  printf("."); fflush(stdout);
	}
      rec+=BUFSIZE/(4.0*44100.0);
    }
  printf("\n");
  close(f); 
  if(in!=f) close(in);
}



