/*  ZA2 Driver for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#ifndef _ZA2HARD_H
#define _ZA2HARD_H
#include <linux/sched.h>
#include <asm/spinlock.h>
/* -------------------------- */
/*  registers of za2 card     */
/* -------------------------- */

#define ZA2_VOLUME       129

#define ZA2_DAC_STATE    136
#define ZA2_SAMPLE_RATE  137
#define ZA2_USER_BIT     138
#define ZA2_START_ID     139

#define ZA2_IRQ_RATE     142

#define ZA2_SYNC_OUTPUT  146   /* output: 0:no output, 1: normal output, 2: R and L swapped, 3: difference R-L */

#define ZA2_SOFT_RESET   157   /* reset if set to 1 */
     
#define ZA2_CBITS_0      224   /* header of cbits stream */
#define ZA2_CBITS_1      225   /* spdif: source: dat, cd, etc. */
#define ZA2_CBITS_2      226   /* spdif: source/channel number */
#define ZA2_CBITS_3      227   /* aes/ebu: sampling rate label */
/*   ...   */
#define ZA2_CBITS_23     247   /* my guess ! */

#define ZA2_DO_IT        255   /* ??? */

/* ------------------------------------------------- */
/*                 error codes                       */
/* ------------------------------------------------- */
#define ZA2_UNKNOW_ERROR              -1

/* upbit errors */
#define ZA2_BAD_BIT_FILE              -11
#define ZA2_CANT_CONFIG_ZA1_WITH_ZA2  -12
#define ZA2_CANT_CONFIG_ZA2_WITH_ZA1  -13
#define ZA2_ALREADY_INITIALISED       -14
#define ZA2_DID_NOT_CONFIG_CORRECTLY  -15
#define ZA2_NO_MEMORY                 -16
#define ZA2_NO_HARDWARE_CONFIG        -17

/* upsim errors */
#define ZA2_NOT_INITIALISED           -20
#define ZA2_DOWNLOAD_FAILED           -21
#define ZA2_UPSIM_UNKNOW_ERROR        -22
#define ZA2_SIM_OUT_OF_SPACE          -23

/* settings */
#define ZA2_HAS_NO_DSP_OS             -30
#define ZA2_EXT_SYNC_NOT_VALID        -31
#define ZA2_NEED_TO_RELOAD_FILTER     -32
#define ZA2_UNKNOW_MODE               -33
#define ZA2_UNKNOW_PROTOCOL           -34

/* error of zaPutEnv and zaSetEnv() */
#define ZA2_CANNOT_OPEN_INI_FILE      -40
#define ZA2_NO_ENV_VAR                -41
#define ZA2_NO_IO_PORT                -42
#define ZA2_IO_PORT_OUT_OF_BOUND      -43
#define ZA2_NO_DMA_IN                 -44
#define ZA2_DMA_IN_OUT_OF_BOUND       -45
#define ZA2_NO_DMA_OUT                -46
#define ZA2_DMA_OUT_OUT_OF_BOUND      -47
#define ZA2_NO_IRQ                    -48
#define ZA2_IRQ_OUT_OF_BOUND          -49
#define ZA2_NO_DMA_AVAILABLE          -50
#define ZA2_NO_IRQ_AVAILABLE          -51

/* generic errors */
#define ZA2_UNKNOW_PARAM              -100
#define ZA2_VALUE_OUT_OF_BOUND        -101
#define ZA2_DEVICE_ALREADY_OPEN       -102
#define ZA2_DEVICE_NOT_OPEN           -103
#define ZA2_DEVICE_NOT_IN_PLAY        -104
#define ZA2_DEVICE_NOT_IN_REC         -105
#define ZA2_DEVICE_NOT_IN_RECPLAY     -106
#define ZA2_DEVICE_NOT_RECORDING      -107
#define ZA2_DEVICE_NOT_PLAYING        -108
#define ZA2_DEVICE_IS_PLAYING         -109
#define ZA2_DEVICE_IS_RECORDING       -110
#define ZA2_NO_INPUT_SIGNAL           -111
#define ZA2_NO_SYNC_RECEIVED          -112
#define ZA2_ACCUMULATED_RX_ERROR      -113
#define ZA2_OUT_OF_SPACE              -114
#define ZA2_NO_IRQ_RECEIVED           -115
#define ZA2_FEATURE_NOT_SUPPORTED     -116

#ifndef _za2hard_c
extern unsigned long flags;
extern struct wait_queue *wq;
extern spinlock_t za2_lock;
#endif

#define GET_CPU_EXCLUSIVITY spin_lock_irqsave(&za2_lock,flags)

#define RELEASE_CPU_EXCLUSIVITY spin_unlock_irqrestore(&za2_lock,flags)

#define MAX_LOOP 10000

#define ZA2_INTR_TIMEOUT     2000
#define ZA2_BLOCK_PROCESS interruptible_sleep_on_timeout(&wq,ZA2_INTR_TIMEOUT)
#define ZA2_WAKEUP_PROCESS wake_up_interruptible(&wq)

#define delay(val) sleep_on_timeout(&wq,val/10)

extern unsigned short __inline__ za2status(struct za2_status *dev);
extern void __inline__ za2command(struct za2_status *dev,short val);
extern void __inline__ disable_za2(struct za2_status *dev);
extern void __inline__ mute_za2(struct za2_status *dev);
void __inline__  za2setmode(struct za2_status *dev);
extern short wait_za2(struct za2_status *dev);
extern void ZaSetEnv(struct za2_status *dev);
extern unsigned int zaGetSamplingRate(struct za2_status *dev);
extern int loadfilter(struct za2_status *dev,int nr);
extern short zaSetSamplingRate(struct za2_status *dev,int newsrate);
extern int za2PrintErr(short err);
extern short setza(struct za2_status *dev);
#ifndef _za2hard_c
extern void ZaOpenDSP(struct za2_status *dev);
extern void ZaSendDSPCMD(struct za2_status *dev,unsigned short cmd, unsigned int data);
extern short ZaCloseDSP(struct za2_status *dev);
extern void ZaNuMode(struct za2_status *dev,short numode);
#endif
#endif

