/*  ZA2 Driver for Linux
    Copyright (C) 1998,1999 Peter Wahl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Send bug reports to:
    Peter Wahl
    wahl@uni-bonn.de
*/

#ifndef _ZA2_H
#define _ZA2_H

#define MODULE 1

#ifdef DEBUG_MESSAGES
#define DEBUG(x) x
#else
#define DEBUG(x)  
#endif

#ifndef ZA2FIRMWAREDIR
#define ZA2FIRMWAREDIR "/etc/sound"
#endif

#define DSPOS          1
#define RESAMPLE_48244 2
#define RESAMPLE_32244 3
#define MPEG2          8
#define USER          16
#define INVALID   0xffff

#define ZA2_CLOSE        0x00
#define ZA2_OPEN_PLAY    0x01
#define ZA2_OPEN_REC     0x02
#define ZA2_OPEN_RECPLAY 0x10

#define ZA2_BLOCK_SIZE 0x1000U  /* 4 kbytes block size */
//#define ZA2_BLOCK_SIZE 0x2000U  /* 8 kbytes block size */
//#define ZA2_BLOCK_SIZE 0x4000U  /* 16 kbytes block size */

#define MP2BLOCKSIZE 666          /* Block-Size for MPEG2: must not be changed ! */

struct za2_dma
{
  int dma;
  volatile short *dmaptr;
  volatile unsigned int currentDmaPtr;
  volatile unsigned int currentDataPtr;
  volatile short firstBlock;      /* true for the first block to record/play */
};

struct za2_status
{  
  int minor,mixer;
  int za2_base;
  /*  unsigned long buffer;
      int count;*/
  int mode;              /*MODE: 0:Configuration, 1:Playback, 2:ZA1, 3:Record(Pass-Thru DSP)*/
  int za2_initialized;
  volatile unsigned short currentState;
  int irq;
  int singledma;
  struct za2_dma *indma,*outdma;
  volatile unsigned short command,za2_mode;
  volatile unsigned int blocksize;

  volatile unsigned short aeso;         /*0:SPDIF, 1:AES/EBU*/
  volatile unsigned short scms;         /*1:SCMS on*/
  volatile unsigned short emph;         /*1:Pre-Emphasis on*/
  volatile unsigned short digin;        /*0:Toslink, 1:Coaxial, 2,3: AES/EBU*/
  volatile unsigned short filter;       
  volatile unsigned int srate;
  volatile unsigned short volume;

  volatile short autoStart;             /* if true, will start by itself */
  volatile short swap;                  /* 1:swap channels, 0:normal*/
  volatile short playing;               /* true while playing (DMA running) */
  volatile short recording;             /* true while recording (DMA running) */
  volatile short enableOut;             /* true if we enable the output while recording */
  unsigned int errors;
  volatile short interrupt;
};

extern struct za2_status za2_st[1];

#define MAX_BUFFER 0x10000

#endif
