#ifndef __ZA2_H
#define __ZA2_H

/*
 *  Copyright (c) by Martin Pahl <pahl@tnt.uni-hannover.de>
 *  Definitions for Zefiro ZA2 
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "pcm1.h"
#include "timer.h"

#define ZA2_MAX_CMD_BUFFER 20
#define ZA2_MAX_DSP_NAME 80
#define ZA2_MAX_DSP_PRG_SIZE 20000

struct snd_stru_za2_dspos {
  unsigned char *program;
  short psize;
  char *name;
};

struct snd_stru_za2 {
	unsigned short port;		/* port of ZA2-card */
	unsigned short irq;		/* IRQ number of ZA2-card */
	snd_irq_t *irqptr;		/* IRQ number (index) */
	unsigned short dma_in16;	/* 16-bit DMA input*/
	snd_dma_t *dma_in16ptr;		/* 16-bit DMA (index) */
	unsigned short dma_out16;	/* 16-bit DMA outpu*/
	snd_dma_t *dma_out16ptr;		/* 16-bit DMA (index) */
	unsigned char trigger_value;

	unsigned short digin; 		/* Digital Input 0=TOS, 1=COAX, 2=AES/EBU */
	unsigned short za2mode;		/* s. za2pinfo.txt */
	int smcs;			/* SMCS */
	int emph;			/* Emphasized */
	int aes;			/* AES-Protocol */

	int filter;
	int isok;
	int resetflag;
	unsigned short za2volume;	/* absolute volume (0-16384) */
	unsigned short volume;		/* volume in percent */
	unsigned long srate;
	unsigned short command;
	unsigned long data[ZA2_MAX_CMD_BUFFER];
	unsigned short cmd[ZA2_MAX_CMD_BUFFER];
	short cmdcnt;
	struct snd_stru_za2_dspos *dspos;
	int debug_flag;

	snd_card_t *card;
	snd_pcm_t *pcm;
	
	snd_spin_define(reg);
};

typedef struct snd_stru_za2 za2_t;

/* I/O ports */

#define ZA2P(codec,x) ( (codec)->port+za2_ZA2##x)

#define za2_ZA2SAMPLES		0x0
#define za2_ZA2STATUS		0x2
#define za2_ZA2HOSTINPUT	0x4
#define za2_ZA2XILINX		0x6

/* Status-Register input bits */
#define za2_BIT_DATPCRDY	0x001
#define za2_BIT_PCDATRDY	0x002
#define za2_BIT_VALID		0x004
#define za2_BIT_FSYNC		0x008
#define za2_BIT_FREQ0		0x010
#define za2_BIT_FREQ1		0x020
#define za2_BIT_C		0x040
#define za2_BIT_U		0x080
#define za2_BIT_CBL		0x100
#define za2_BIT_REQ		0x200
#define za2_BIT_PCHOSTRDY	0x400
#define za2_BIT_FREQ2		0x800

/* Status-Register output bits */
#define za2_BIT_INPSEL0		0x0001
#define za2_BIT_INPSEL1		0x0002
#define za2_BIT_IRQSEL0		0x0004
#define za2_BIT_IRQSEL1		0x0008
#define za2_BIT_IDMASEL0	0x0010
#define za2_BIT_IDMASEL1	0x0020
#define za2_BIT_ODMASEL0	0x0040
#define za2_BIT_ODMASEL1	0x0080
#define za2_BIT_MODE0		0x0100
#define za2_BIT_MODE1		0x0200
#define za2_BIT_WCSEL		0x0400
#define za2_BIT_PIO		0x0800
#define za2_BIT_RESET		0x1000
#define za2_BIT_CS		0x2000
#define za2_BIT_BOOT		0x4000

#define za2_BITS_INIT		0xff03
#define za2_BITS_INPUT		0x0003
#define za2_NBITS_INPUT		0xfffc
#define za2_NBITS_IRQ		0xfff3
#define za2_NBITS_IDMA		0xffcf
#define za2_NBITS_ODMA		0xff3f

#define za2_INPUT_TOS		0x0000
#define za2_INPUT_COAX		0x0001
#define za2_INPUT_AESEBU	0x0020

#define za2_MODE_FREE_PLAY   0x0100  /* output only */
#define za2_MODE_SYNC_PLAY   0x0200  /* input/output in sync */
#define za2_MODE_PASS_THRU   0x0300  /* input only thru DSP (with monitor out) */

/* TX protocol */
#define za2_PROTOCOL_SPDIF  0  /* SPDIF protocol */
#define za2_PROTOCOL_AES    1  /* AES/EBU protocol */
 
#define za2_ZA_ID		0x7a61


/* ------------------------------------------------- */
/*                 error code                        */
/* ------------------------------------------------- */

#define za2_ERR_SUCCES      0

#define za2_ERR_BASE  0

#define za2_ERR_UNKNOW_ERROR              (za2_ERR_BASE - 1)

/* upbit errors */
#define za2_ERR_BAD_BIT_FILE              (za2_ERR_BASE - 11)
#define za2_ERR_CANT_CONFIG_ZA1_WITH_ZA2  (za2_ERR_BASE - 12)
#define za2_ERR_CANT_CONFIG_ZA2_WITH_ZA1  (za2_ERR_BASE - 13)
#define za2_ERR_ALREADY_INITIALIZED       (za2_ERR_BASE - 14)
#define za2_ERR_DID_NOT_CONFIG_CORRECTLY  (za2_ERR_BASE - 15)
#define za2_ERR_NO_MEMORY                 (za2_ERR_BASE - 16)
#define za2_ERR_NO_HARDWARE_CONFIG        (za2_ERR_BASE - 17)

/* upsim errors */
#define za2_ERR_NOT_INITIALISED           (za2_ERR_BASE - 20)
#define za2_ERR_DOWNLOAD_FAILED           (za2_ERR_BASE - 21)
#define za2_ERR_UPSIM_UNKNOW_ERROR        (za2_ERR_BASE - 22)
#define za2_ERR_SIM_OUT_OF_SPACE          (za2_ERR_BASE - 23)

/* setting */
#define za2_ERR_AS_NO_DSP_OS              (za2_ERR_BASE - 30)
#define za2_ERR_EXT_SYNC_NOT_VALID        (za2_ERR_BASE - 31)
#define za2_ERR_NEED_TO_RELOAD_FILTER     (za2_ERR_BASE - 32)
#define za2_ERR_UNKNOW_MODE               (za2_ERR_BASE - 33)
#define za2_ERR_UNKNOW_PROTOCOL           (za2_ERR_BASE - 34)

/* error of zaPutEnv and zaSetEnv() */
#define za2_ERR_CANNOT_OPEN_INI_FILE      (za2_ERR_BASE - 40)
#define za2_ERR_NO_ENV_VAR                (za2_ERR_BASE - 41)
#define za2_ERR_NO_IO_PORT                (za2_ERR_BASE - 42)
#define za2_ERR_IO_PORT_OUT_OF_BOUND      (za2_ERR_BASE - 43)
#define za2_ERR_NO_DMA_IN                 (za2_ERR_BASE - 44)
#define za2_ERR_DMA_IN_OUT_OF_BOUND       (za2_ERR_BASE - 45)
#define za2_ERR_NO_DMA_OUT                (za2_ERR_BASE - 46)
#define za2_ERR_DMA_OUT_OUT_OF_BOUND      (za2_ERR_BASE - 47)
#define za2_ERR_NO_IRQ                    (za2_ERR_BASE - 48)
#define za2_ERR_IRQ_OUT_OF_BOUND          (za2_ERR_BASE - 49)
#define za2_ERR_NO_DMA_AVAILABLE          (za2_ERR_BASE - 50)
#define za2_ERR_NO_IRQ_AVAILABLE          (za2_ERR_BASE - 51)

/* generic errors */
#define za2_ERR_UNKNOW_PARAM              (za2_ERR_BASE - 100)
#define za2_ERR_VALUE_OUT_OF_BOUND        (za2_ERR_BASE - 101)
#define za2_ERR_DEVICE_ALREADY_OPEN       (za2_ERR_BASE - 102)
#define za2_ERR_DEVICE_NOT_OPEN           (za2_ERR_BASE - 103)
#define za2_ERR_DEVICE_NOT_IN_PLAY        (za2_ERR_BASE - 104)
#define za2_ERR_DEVICE_NOT_IN_REC         (za2_ERR_BASE - 105)
#define za2_ERR_DEVICE_NOT_IN_RECPLAY     (za2_ERR_BASE - 106)
#define za2_ERR_DEVICE_NOT_RECORDING      (za2_ERR_BASE - 107)
#define za2_ERR_DEVICE_NOT_PLAYING        (za2_ERR_BASE - 108)
#define za2_ERR_DEVICE_IS_PLAYING         (za2_ERR_BASE - 109)
#define za2_ERR_DEVICE_IS_RECORDING       (za2_ERR_BASE - 110)
#define za2_ERR_NO_INPUT_SIGNAL           (za2_ERR_BASE - 111)
#define za2_ERR_NO_SYNC_RECEIVED          (za2_ERR_BASE - 112)
#define za2_ERR_ACCUMULATED_RX_ERROR      (za2_ERR_BASE - 113)
#define za2_ERR_OUT_OF_SPACE              (za2_ERR_BASE - 114)
#define za2_ERR_NO_IRQ_RECEIVED           (za2_ERR_BASE - 115)
#define za2_ERR_FEATURE_NOT_SUPPORTED     (za2_ERR_BASE - 116)


/* -------------------------- */
/*  registers of za2 card     */
/* -------------------------- */

#define za2_REG_VOLUME       129

#define za2_REG_DAC_STATE    136
#define za2_REG_SAMPLE_RATE  137
#define za2_REG_USER_BIT     138
#define za2_REG_START_ID     139

#define za2_REG_IRQ_RATE     142

#define za2_REG_SYNC_OUTPUT  146   /* what is the purpose of this register ? */

#define za2_REG_SOFT_RESET   157   /* reset if set to 1 */

#define za2_REG_CBITS_0      224   /* header of cbits stream */
#define za2_REG_CBITS_1      225   /* spdif: source: dat, cd, etc. */
#define za2_REG_CBITS_2      226   /* spdif: source/channel number */
#define za2_REG_CBITS_3      227   /* aes/ebu: sampling rate label */
/*  ...   */
#define za2_REG_CBITS_23     247   /* my gess ! */

#define za2_REG_DO_IT        255   /* ??? */
 

#ifdef USELESS
extern void snd_za2_interrupt(snd_pcm_t *pcm);
extern snd_pcm_t *snd_za2_new_device(snd_card_t *card,
				     unsigned short port,
				     unsigned short irqnum,
				     unsigned short dma16num);
extern int snd_za2_init(snd_pcm_t *pcm, int enable);
#endif
				     
				     

#endif				/* __ZA2_H */


