#ifndef _IWPROTOS_H_
#define _IWPROTOS_H_
#include "iwtypes.h"
//#######################################################################
//
// FILE   : iwprotos.h
//
// REMARKS: This file contains the prototypes for all DDK library
//          functions. It should always be included when
//          developing applications with ANSI compliant compilers.
//
// UPDATE : 6/4/95  Update for BCC32
//          7/11/95 Modification to IwaveMemCfg
//
//#######################################################################
//
//        Prototypes for Local Memory Management
//
//#######################################################################
void IwaveInit(void);

FLAG IwaveMemFree(ADDRESS, ADDRESS);

ADDRESS IwaveMemAlloc(DWORD);

DWORD IwaveMaxAlloc(void);

DWORD IwaveMemAvail(void);

FLAG IwaveMemInit(void);

void IwaveWriteLong(ADDRESS, ADDRESS);

ADDRESS IwaveGetAddr(void);

ADDRESS IwaveReadLong(ADDRESS);

BYTE IwaveMemPeek(ADDRESS);

WORD IwaveMemPeekW(ADDRESS);

void IwaveMemPoke(ADDRESS, BYTE);

void IwaveMemPokeW(ADDRESS, WORD);

void IwavePokeBlock(BYTE far*,DWORD,ADDRESS);

void IwavePokeBlockW(WORD far*,DWORD,ADDRESS);

void IwavePeekBlock(BYTE far*,DWORD,ADDRESS);

void IwavePeekBlockW(WORD far*,DWORD,ADDRESS);

WORD IwaveMemSize(void);

void IwaveMemMerge(void);

void IwaveMemCfg(DWORD *);

//#######################################################################
//
//        Prototypes for DMA operations
//
//#######################################################################
void IwaveDmaPgm(DMA *);

FLAG IwaveDmaXfer(DMA *, WORD);

void IwaveDmaIleaved(DMA *, WORD, BYTE, WORD);

FLAG IwaveDmaCtrl(DMA *,WORD);

FLAG IwaveDmaPage(DMA *, WORD);

void IwaveDmaNext(DMA *);

void IwaveDmaWait(void);

void IwavePrintDma(DMA *);

WORD IwaveGetDmaCnt(DMA *);
#ifdef FLAT_MODEL
void *IwaveDmaMalloc(WORD);
#else
void far *IwaveDmaMalloc(WORD);
#endif

void IwaveDmaWait(void);

#ifdef __WATCOMC__
void *IwaveAllocDOS(WORD,WORD *,WORD *);

void IwaveFreeDOS(WORD);

void *WatcomDmaBuffer(WORD, WORD *);
#endif

void IwaveStopDma(BYTE);

//#######################################################################
//
//        Prototypes for Hardware I/O, Register Access and general
//        Utility functions.
//
//#######################################################################
#if defined(__HIGHC__) || defined(__WATCOMC__)
#else
void _poke(PORT,BYTE);

void _pokew(PORT,WORD);

BYTE _peek(PORT);

WORD _peekw(PORT);
#endif

WORD IwaveRegPeek(DWORD);

void IwaveRegPoke(DWORD,WORD);

WORD GetSamplePosition(DMA *);

WORD IwaveGetDmaPos(DMA *);

void IwaveEnableOutput(void);

void IwaveDisableOutput(void);

void IwaveEnableLineIn(void);

void IwaveDisableLineIn(void);

void IwaveEnableMicIn(void);

void IwaveDisableMicIn(void);

void IwaveLineMute(BYTE,BYTE);

void IwaveMonoMute(BYTE,BYTE);

void IwaveLineLevel(BYTE,BYTE);

void IwaveMonoLevel(BYTE);

void IwaveInputSource(BYTE,BYTE);

void IwaveInputGain(BYTE,BYTE);

void IwaveDacAtten(BYTE,BYTE);

ADDRESS IwaveAddrTrans(ADDRESS);

ADDRESS IwaveRealAddr(ADDRESS,BYTE);

void IwaveDelay(WORD);

void WriteEnable(void);

void WriteOPCode(void);

void ReadOPCode(void);

void PokePSECI(BYTE);

void IwavePokeEEPROM(BYTE *);

void IwavePeekEEPROM(BYTE *);

FLAG ReadWaveHeader(char *,WAV *);

#ifdef __PHARL__
extern void EnterCritical(void);
extern void LeaveCritical(void);
extern void SaveSegRegs(void);
#endif

//#######################################################################
//
//        Prototypes for Synthesizer and Codec functions
//
//#######################################################################
void IwaveStartVoice(BYTE);

void IwaveStopVoice(BYTE);

void IwaveStopVolume(BYTE);

WORD IwaveReadVolume(BYTE);

void IwaveSetVolume(BYTE,WORD);

void IwaveRampVolume(BYTE,WORD,WORD,BYTE,BYTE);

BYTE IwaveReadyVoice(BYTE,ADDRESS,ADDRESS,ADDRESS,BYTE);

void IwaveSetVoicePlace(BYTE,ADDRESS);

void IwaveSetVoiceEnd(BYTE,ADDRESS);

void IwaveVoicePan(BYTE,WORD,WORD);

void IwaveVoicePitch(BYTE,DWORD);

void IwaveVoiceFreq(BYTE,DWORD);

ADDRESS IwaveReadVoice(BYTE);

void IwaveSetLoopMode(BYTE,BYTE,BYTE);

void IwaveSynthGlobal(BYTE, BOOL);

void IwaveSynthMode(BYTE);

BYTE IwaveCodecStatus(BYTE);

void IwaveTimerStart(void);

void IwaveTimerStop(void);

void IwaveSetTimer(WORD);

void IwaveCodecIrq(BYTE);

void IwaveCodecCalib(void);

void IwaveCodecTrigger(BYTE);

void IwaveCodecMode(BYTE);

void IwaveCodecCnt(BYTE,WORD);

void IwaveCodecAccess(BYTE);

void IwavePlayAccess(BYTE);

void IwaveRecordAccess(BYTE);

void IwaveDataFormat(BYTE,BYTE);

void IwaveSetFrequency(BYTE,WORD);

FLAG IwavePlayData(WORD,BYTE,BYTE);

FLAG IwaveRecordData(WORD,BYTE,BYTE);

//#######################################################################
//
//        Prototypes for Hardware Interrupt functions and handlers
//
//#######################################################################
#ifndef __PHARL__
void IwaveSetVect(int, PVI);
PVI IwaveGetVect(int);
#endif
//
#ifdef __HIGHC__
void SetrpVect(int, _real_int_handler_t , PVI );
void GetrpVect(int, _real_int_handler_t *, PVI *);
#endif

void IwaveResetIvt(void);

void IwaveSetIvt(void);

void IwaveUmaskIrqs(void);

void IwaveMaskIrqs(void);

void IwaveHandleDma(void);

void IwaveHandleCodec(void);

void IwaveHandleVoice(void);

void IwaveHandler(void);

void IwaveDefFunc(void);

PFV  IwaveSetCallback(PFV,BYTE);

#ifdef __SC__
int IwaveSynthHandler(struct INT_DATA *);
int IwaveMidiHandler(struct INT_DATA *);
#else
#ifndef __PHARL__
INTERRUPT IwaveSynthHandler(void);
INTERRUPT IwaveMidiHandler(void);
#else
void IwaveSynthHandler(void);
void IwaveMidiHandler(void);
#endif
#endif
//
//#######################################################################
//
//    Prototypes for Initialization and Configuration functions
//
//#######################################################################
//
BOOL IwaveOpen(BYTE,BYTE);

BOOL IwaveClose(void);

void IwaveSetInterface(DMA  *,DMA  *,IRQ  *, IRQ *);

void IwaveRegisterIRQ(IRQ  *,IRQ  *);

void IwaveRegisterDMA(DMA  *,DMA  *);

BOOL IwaveReset(BYTE);

void IwaveGusReset(void);

void IwavePnpKey(void);

BYTE IwavePnpIsol(PORT *);

void IwavePnpGetCfg(void);

void IwavePnpSerial(PORT, BYTE, BYTE *, DWORD *);

void IwavePnpEeprom(BYTE);

void IwavePnpActivate(BYTE,BYTE);

void IwavePnpDevice(BYTE);

void IwavePnpSetCfg(void);

WORD IwavePnpIOcheck(PORT,BYTE);

void IwavePnpWake(BYTE);

void IwavePnpPeek(PORT, WORD, BYTE  *);

void IwavePnpPower(BYTE);

BYTE IwavePnpPing(DWORD);

BYTE IwavePnpGetCSN(DWORD,BYTE);

BYTE far *IwavePnpBIOS(void);

WORD IwavePnpBIOS40(BYTE far *,BYTE far *);

BYTE IwaveCheckSum(BYTE *);
#endif
