/***************************************************************************
*	NAME:  VOCREAD.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

/***************************************************************
 * This function will read the accumulator for a particular 
 * voice.
 ***************************************************************/

unsigned long	
UltraReadVoice(int voice)
{
unsigned int	count_low, count_high;
unsigned long	acc;
unsigned char	mode;

	ENTER_CRITICAL;

	outp(_gf1_data.voice_select,voice);	/* Select the proper voice */
	
/* Get the high portion of the accumulator */
	outp(_gf1_data.reg_select,GET_ACC_HIGH);		
	count_high = inpw(_gf1_data.data_low);
	
/* Get the low portion of the accumulator */
	outp(_gf1_data.reg_select,GET_ACC_LOW);
	count_low = inpw(_gf1_data.data_low);
	
	/* convert from UltraSound's format to a physical address */

	outp(_gf1_data.reg_select,GET_CONTROL);
	mode = inp(_gf1_data.data_hi);

	LEAVE_CRITICAL;
	
	acc = make_physical_address(count_low,count_high,mode);
	acc &= 0xfffffL;		/* Only 20 bits please ... */

	return(acc);
}

