/***************************************************************************
*	NAME:  ROCK.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <stdio.h>
#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

/***************************************************************
 * This function is used just to keep track of the version of the 
 * software a customer/developer has. It is not currently used
 * by the code at all....
 ***************************************************************/

void
UltraVersion(int *major,int *minor)
{
*major = 2;
*minor = 11;
}

/***************************************************************
 * This function is used as a 1.6*3 microsecond (or longer) delay.
 * This is needed when trying to change any of the 'self-modifying
 * bits in the voice registers.
 ***************************************************************/

void
gf1_delay(void)
{
int i;

for (i=0;i<7;i++)
	(void)inp(_gf1_data.dram_data);	/* pick a port .... */
}
/***************************************************************
 * This function will convert the value read from the GF1 registers
 * back to a 'real' address.
 ***************************************************************/

#define	MAKE_MS_WORD( x )	((unsigned long)((unsigned long)(x)) << 16)

unsigned long	
make_physical_address(unsigned int low,unsigned int high,unsigned char mode)
{
unsigned int	lower_16, upper_16;
unsigned long	ret_address, bit_19_20;

	upper_16 = high >> 9;
	lower_16 = ((high & 0x01ff) << 7) | ((low >> 9) & 0x007f);

	ret_address = MAKE_MS_WORD(upper_16) + lower_16;

	if (mode & VC_DATA_TYPE)
		{
		bit_19_20 = ret_address & 0xC0000;
		ret_address <<= 1;
		ret_address &= 0x3ffff;
		ret_address |= bit_19_20;
		}
	
	return( ret_address );
}

/***************************************************************
 * This function will translate the address if the dma channel
 * is a 16 bit channel. This translation is not necessary for
 * an 8 bit dma channel.
 ***************************************************************/

unsigned long	
convert_to_16bit(unsigned long address)
// unsigned long address;		/* 20 bit ultrasound dram address */
{
unsigned long	hold_address;

	hold_address = address;

	/* Convert to 16 translated address. */
	address = address >> 1;

	/* Zero out bit 17. */
	address &= 0x0001ffffL;

	/* Reset bits 18 and 19. */
	address |= (hold_address & 0x000c0000L);

	return(address);
}


