/***************************************************************************
*	NAME:  PLAYEXAM.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 09/25/93
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	05/01/93		Original
***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h> 
#include <dos.h>

#ifdef MSOFTC || WATCOMC
#include <malloc.h>
#define close _dos_close
#else
#include <alloc.h>
#endif

#define BUFFSIZE 4U*1024U
char *databuf0;
char *databuf1;

#include "forte.h"
#include "gf1proto.h"
#include "extern.h"
#include "ultraerr.h"

void 
WaveHandler(voice)
int voice;
{
}

void
usage()
{
printf("\nUsage: playexam -fnnnnn -vnnn filename\n");
exit(-2);
}

void
main(argc,argv)
int argc;
char *argv[];
{
char filename[80];
void *data_ptr;
int fd;
unsigned long frequency = 22050L;
int volume=400;
ULTRA_CFG config;
int i;
int voice;
unsigned long dram_loc;

strcpy(filename,"");

for (i=1;i<argc;i++)
	{
	if (argv[i][0] == '-')
		{
		switch(toupper(argv[i][1]))
			{
			case 'F':
				break;
			case 'V':
				break;
			case '?':
				usage();
				break;
			default:
				printf("\nBad Option (%s)\n",argv[i]);
				usage();
				break;
			}
		}
	else
		{
		strcpy(filename,argv[i]);
		}
	}

if (strcmp(filename,"") == 0)
	{
	printf("\nYou must specify a filename\n");
	usage();
	}

#ifdef MSOFTC || WATCOMC
	_dos_open(filename,O_RDONLY|O_BINARY,&fd);
#else
	fd = _open(filename,O_RDONLY|O_BINARY);
#endif
	if (fd == -1)
		{
		printf("\nCan't open file (%s)\n",filename);
		exit(-3);
		}

databuf0 = malloc(10U*BUFFSIZE);
databuf1 = malloc(10U*BUFFSIZE);

if (databuf0 == NULL || databuf1 == NULL)
	{
	printf("Error Allocating Buffer RAM\n");
	close(fd);
	exit(-5);
	}

/* Get the ULTRASND environment string parameters */
UltraGetCfg(&config);

if (UltraProbe(config.base_port) == NO_ULTRA)
	{
	printf("No card found\n");
	free(databuf0);
	free(databuf1);
	close(fd);
	exit(-1);
	}

if (UltraOpen(&config,14) == NO_ULTRA)
	{
	printf("No card found\n");
	free(databuf0);
	free(databuf1);
	close(fd);
	exit(-1);
	}

UltraEnableOutput();

UltraWaveHandler(WaveHandler);

if (UltraAllocVoice(-1,&voice) != ULTRA_OK)
	{
	printf("Error Allocating a free voice\n");
	free(databuf0);
	free(databuf1);
	close(fd);
	UltraClose();
	exit(-4);
	}

UltraSetBalance(voice,7);

UltraSetFrequency(voice,frequency);

UltraRampLinearVolume(voice,0,volume,100L,0);

if (UltraMemAlloc((long)BUFFSIZE*2L,&dram_loc) != ULTRA_OK)
	{
	printf("Error Allocating DRAM Buffer\n");
	UltraFreeVoice(voice);
	free(databuf0);
	free(databuf1);
	close(fd);
	UltraClose();
	exit(-5);
	}

/* Fill buffers here */

/* Loop till done with data */
while (!kbhit())
	{
	}

if (kbhit())
	getch();


UltraFreeVoice(voice);

free(databuf0);
free(databuf1);

close(fd);

/* Shut sound down & re-init hardware ... */
UltraClose();
}

