/***************************************************************************
*	NAME:  FREQ16R.C
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 01/01/94
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	01/01/94		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1os.h"
#include "codecos.h"

#include "proto16.h"
#include "defs16.h"
#include "extern16.h"
#include "codec.h"

extern CODEC_FREQ codec_freq[];
extern IMAGE16 _image_codec;
extern ULTRA16_DATA _codec_data;
extern ULTRA_DATA _gf1_data;

void
wait_mce_cdfr(unsigned char data)
{

_image_codec.cdfr = data;

ENTER_CRITICAL;

outp(_codec_data.addr,CODEC_MCE|REC_FORMAT);
outp(_codec_data.data,_image_codec.cdfr);
(void)inp(_codec_data.data);		/* ERRATA SHEETS ... */
(void)inp(_codec_data.data);		/* ERRATA SHEETS ... */

/* wait till sync is done ... */
while (inp(_codec_data.addr) & 0x80)
	;

/* turn off the MCE bit */
outp(_codec_data.addr,REC_FORMAT);

/* Need this. outp doesn't always take ... .*/
while (inp(_codec_data.addr) != REC_FORMAT)
	outp(_codec_data.addr,REC_FORMAT);

AutoCalibrate();

LEAVE_CRITICAL;
}

unsigned int 
Ultra16RecFormat(stereo,sixteen_bit,compress)
int stereo;
int sixteen_bit;
int compress;
{
unsigned char format;
unsigned int old;

old = _image_codec.cdfr;
format = _image_codec.cdfr & 0x0f;	/* isolate the format bits ... */

if (sixteen_bit)
	{
	if (compress == COMPRESS_ADPCM)
		format |= 0xA0;	/* 16 bit ADPCM */
	else
		format |= 0x40;		/* 16 bit, twos comp, little endian */
	}
else
	{
	if (compress == COMPRESS_ALAW)
		format |= 0x60;		/* 8 bit, companded Alaw */
	else if (compress == COMPRESS_ULAW)
			format |= 0x20;		/* 8 bit, companded mulaw */
	}

if (stereo)
	format |= TYPE_STEREO;

if (old != format)
	{
	if (_image_codec.mi & CODEC_MODE2)	/* only if mode 2 */
		{
		wait_mce_cdfr(format);

		if (_image_codec.ic & SINGLE_DMA)
			old = Ultra16PlayFormat(stereo,sixteen_bit,compress);
		}
	else	/* set plays registers if in mode 1 */
		{
		old = Ultra16PlayFormat(stereo,sixteen_bit,compress);
		}
	}

return(old);
}

