;;; pyim-pymap.el --- Pinyin map used by pyim  -*- lexical-binding: t; -*-

;; * Header
;; Copyright (C) 2015-2020 Free Software Foundation, Inc.

;; Author: Feng Shu <tumashu@163.com>
;; Maintainer: Feng Shu <tumashu@163.com>
;; URL: https://github.com/tumashu/pyim
;; Keywords: convenience, Chinese, pinyin, input-method

;; This file is part of GNU Emacs.

;; GNU Emacs is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; * 说明文档                                                              :doc:

;; 这个文件源自：[[http://git.savannah.gnu.org/cgit/emacs.git/tree/leim/MISC-DIC/pinyin.map][pinyin.map]]
;; 这个文件是 pyim 内部使用的 "拼音-汉字" 对照表，
;; 这个对照表用来实现拼音查询功能，即，查询某个汉字对应的拼音代码。

;; 注意： 这个文件 *不用于* 输入法自定义词库！！！


;;; Code:
;; * 代码                                                                 :code:
(defvar pyim-pymap
  '(("a" "阿啊呵腌嗄吖锕")
    ("ai" "爱埃艾碍癌哀挨矮隘蔼唉皑哎霭捱暧嫒嗳瑷嗌锿砹")
    ("an" "安案按岸暗鞍氨俺胺铵谙庵黯鹌桉埯犴揞")
    ("ang" "昂盎肮")
    ("ao" "奥澳傲熬凹鳌敖遨鏖袄坳翱嗷拗懊岙螯骜獒鏊媪廒聱")
    ("ba" "把八巴拔吧坝爸霸罢芭跋扒叭靶疤笆耙鲅粑岜灞钯捌菝魃茇")
    ("bai" "百白败摆伯拜柏佰掰呗捭稗")
    ("ban" "办版半班般板颁伴搬斑扮拌扳瓣坂阪绊钣瘢舨癍")
    ("bang" "帮邦榜棒膀镑绑傍磅蚌谤梆浜蒡")
    ("bao" "报保包宝暴胞薄爆饱抱堡鲍曝葆豹刨褒雹孢苞煲褓趵鸨龅")
    ("bei" "北被备倍背杯贝辈悲碑卑悖惫蓓陂钡狈呗焙碚褙埤鞴孛鹎萆邶鐾")
    ("ben" "本奔苯笨夯贲锛畚坌")
    ("beng" "泵崩蚌蹦迸绷甭嘣甏")
    ("bi" "比必币笔毕避闭壁弊彼逼碧鼻臂蔽璧庇痹毙弼匕鄙陛裨贲敝蓖吡篦俾铋毖筚荸薜婢哔跸埤濞秕荜愎妣芘箅庳髀畀滗狴萆嬖襞舭")
    ("bian" "变便边编遍辩鞭辨贬匾扁卞汴辫砭苄蝙鳊弁窆笾煸褊碥忭缏")
    ("biao" "表标彪镖裱飚膘飙镳婊骠飑杓髟鳔瘭")
    ("bie" "别鳖憋瘪蹩")
    ("bin" "宾滨斌彬濒殡缤鬓槟摈膑玢镔豳髌傧")
    ("bing" "并病兵冰饼炳秉丙摒柄禀邴")
    ("bo" "波博播勃拨薄伯玻搏柏泊舶剥渤卜驳脖膊簸菠礴箔掰铂亳钵帛擘饽跛钹趵檗啵鹁孛踣")
    ("bu" "不部步布补捕埔卜埠簿哺怖钚卟瓿逋晡醭钸")
    ("ca" "擦嚓礤")
    ("cai" "才采财材菜彩裁蔡猜踩睬")
    ("can" "参残餐灿惨蚕掺璨惭粲孱骖黪")
    ("cang" "藏仓苍沧舱伧")
    ("cao" "草操曹槽糙嘈漕螬艚")
    ("ce" "策测册侧厕恻")
    ("cen" "参岑涔")
    ("ceng" "层曾蹭噌")
    ("cha" "查察差茶插叉刹茬楂岔诧碴嚓喳姹杈汊衩搽槎镲檫馇锸猹")
    ("chai" "差拆柴钗豺侪虿瘥")
    ("chan" "产阐缠掺禅颤铲蝉搀潺蟾馋忏婵孱觇廛谄谗澶骣羼镡躔蒇冁")
    ("chang" "场长厂常偿昌唱畅倡尝肠敞倘猖娼徜昶怅嫦菖鲳阊伥苌氅惝鬯")
    ("chao" "超朝潮炒钞抄巢吵绰嘲晁焯耖怊")
    ("che" "车彻撤扯澈掣坼砗")
    ("chen" "称陈沉晨琛臣尘辰衬趁忱郴宸谌碜嗔抻榇伧谶龀")
    ("cheng" "成程城承称盛乘诚呈惩撑澄秤橙骋逞瞠丞铛埕塍噌蛏柽铖酲裎枨")
    ("chi" "持吃池迟赤驰尺斥齿翅匙痴耻炽侈弛叱啻坻嗤墀哧茌豉敕笞饬踟蚩媸魑篪褫彳鸱螭瘛眵傺")
    ("chong" "重充冲崇虫宠忡憧舂茺铳艟")
    ("chou" "筹抽绸酬愁丑臭仇畴稠瞅踌惆俦瘳雠帱")
    ("chu" "出处础初除储畜触楚厨雏矗橱锄褚滁躇怵绌搐刍蜍黜杵蹰亍樗憷楮")
    ("chuai" "揣踹啜嘬搋膪")
    ("chuan" "传川船穿串喘椽舛钏遄氚巛舡")
    ("chuang" "创床窗闯幢疮怆")
    ("chui" "吹垂锤炊陲槌捶棰")
    ("chun" "春纯醇淳唇椿蠢鹑莼蝽")
    ("chuo" "辍绰戳啜龊踔")
    ("ci" "次此差词辞刺瓷磁兹慈茨赐祠雌疵鹚糍呲茈")
    ("cong" "从丛匆聪葱囱琮淙枞骢苁璁")
    ("cou" "凑辏腠楱")
    ("cu" "促粗簇醋卒蹴猝蹙酢蔟殂徂")
    ("cuan" "窜攒篡蹿撺爨汆镩")
    ("cui" "催崔脆翠萃粹摧璀瘁悴淬啐隹毳榱")
    ("cun" "村存寸忖皴")
    ("cuo" "措错磋挫搓撮蹉锉厝嵯痤矬瘥脞鹾")
    ("da" "大达打答搭沓瘩嗒哒耷鞑疸靼褡笪怛妲")
    ("dai" "代带待贷戴袋歹呆逮岱傣怠殆黛甙埭绐玳呔迨骀")
    ("dan" "但单担丹胆旦弹蛋淡诞氮郸耽殚惮儋眈疸澹掸啖箪聃萏瘅赕")
    ("dang" "当党档荡挡宕砀铛裆凼菪谠")
    ("dao" "到道导岛倒刀盗稻蹈悼捣叨祷氘纛帱忉")
    ("de" "的得德锝")
    ("deng" "等登邓灯凳瞪蹬噔磴嶝镫簦戥")
    ("di" "地第提低底抵弟迪递帝敌堤蒂缔滴涤翟娣笛棣荻谛狄邸嘀砥坻诋嫡镝碲骶氐柢绨籴羝睇觌")
    ("dia" "嗲")
    ("dian" "电点店典奠甸碘淀殿垫颠滇癫巅惦掂癜玷佃踮靛钿簟坫丶阽")
    ("diao" "调掉雕吊钓刁貂凋碉鲷叼铫铞")
    ("die" "跌叠蝶迭碟爹谍牒耋佚喋踮堞瓞鲽垤揲蹀")
    ("ding" "定订顶丁鼎盯钉锭叮仃铤町酊啶碇腚疔玎耵")
    ("diu" "丢铥")
    ("dong" "动东董冬洞懂冻栋侗咚峒氡恫胴硐垌鸫岽胨")
    ("dou" "都斗豆抖兜陡逗窦蚪痘蔸篼")
    ("du" "度都独督读毒渡杜堵赌睹肚镀渎笃嘟犊妒牍蠹椟黩芏髑")
    ("duan" "断段短端锻缎煅椴簖")
    ("dui" "对队兑堆碓镦怼憝")
    ("dun" "吨顿盾敦蹲墩囤沌钝炖盹遁趸砘镦礅")
    ("duo" "多夺朵躲铎咄堕舵驮垛惰哆踱跺掇剁柁缍沲裰哚")
    ("e" "额俄恶鹅遏鄂厄饿峨扼娥鳄哦蛾噩愕讹锷垩婀鹗萼谔莪腭锇颚呃阏屙苊轭")
    ("ei" "诶")
    ("en" "恩摁蒽")
    ("er" "而二尔儿耳迩饵洱贰铒珥佴鸸鲕")
    ("fa" "发法罚乏伐阀筏砝垡珐")
    ("fan" "反范犯繁饭泛翻凡返番贩烦帆樊藩矾梵蕃钒幡畈蘩蹯燔")
    ("fang" "方放房防访纺芳仿坊妨肪邡舫彷枋鲂钫")
    ("fei" "费非飞肥废菲肺啡沸匪斐蜚妃诽扉翡霏吠绯腓痱芾淝悱狒榧鲱篚镄")
    ("fen" "分份纷奋粉氛芬愤粪坟汾焚酚吩忿棼玢鼢瀵偾鲼")
    ("feng" "风丰封峰奉凤锋冯逢缝蜂枫疯讽烽俸沣酆砜葑唪")
    ("fo" "佛")
    ("fou" "否缶")
    ("fu" "府服副负富复福夫妇幅付扶父符附腐赴佛浮覆辅傅伏抚赋辐腹弗肤阜袱缚甫氟斧孚敷俯拂俘咐腑孵芙涪釜脯茯馥绂讣呋罘麸蝠匐芾蜉跗凫滏蝮驸绋蚨砩桴赙菔趺苻拊鲋怫稃郛莩幞祓艴黻黼鳆")
    ("ga" "轧咖嘎尬噶旮伽尕钆尜")
    ("gai" "改该盖概溉钙丐赅垓陔戤")
    ("gan" "干感赶敢甘肝杆赣柑尴竿秆橄矸淦苷擀酐绀泔坩旰疳澉")
    ("gang" "港钢刚岗纲冈杠缸扛肛罡戆筻")
    ("gao" "高告搞稿膏糕镐皋羔锆杲郜睾诰藁篙缟槁槔")
    ("ge" "个各革格歌哥隔割阁戈葛鸽搁屹胳舸疙铬骼咯圪镉颌仡硌嗝鬲膈纥袼搿塥哿虼")
    ("gei" "给")
    ("gen" "根跟亘艮哏茛")
    ("geng" "更耕颈庚耿梗埂羹哽赓绠鲠")
    ("gong" "工公共供功贡攻宫巩龚恭拱躬弓汞蚣珙觥肱")
    ("gou" "构购够沟狗钩勾苟垢枸篝佝媾诟岣彀缑笱鞲觏遘")
    ("gu" "股古顾故固鼓骨估谷姑孤雇辜菇沽咕锢钴鹄箍汩梏痼崮轱鸪牯蛊诂毂鹘菰罟嘏臌觚瞽蛄酤牿鲴")
    ("gua" "挂瓜刮寡卦呱褂剐胍诖鸹栝")
    ("guai" "怪拐乖掴")
    ("guan" "关管观馆官贯冠惯灌罐莞纶棺倌鹳鳏盥掼涫")
    ("guang" "广光逛犷胱咣桄")
    ("gui" "规贵归轨桂柜圭鬼硅瑰跪龟闺诡癸炔鳜桧皈鲑刽晷傀妫炅庋簋刿宄匦")
    ("gun" "滚棍辊衮磙鲧绲")
    ("guo" "国过果郭锅裹帼椁蝈虢聒埚掴猓崞蜾呙馘")
    ("ha" "哈蛤铪")
    ("hai" "海还害孩亥咳骸嘿骇氦嗨胲醢")
    ("han" "汉韩含旱寒汗涵函喊憾罕焊翰邯撼瀚憨捍酣悍阚鼾邗颔蚶晗菡顸焓撖")
    ("hang" "行航杭巷夯珩沆绗颃")
    ("hao" "好号毫豪耗浩郝皓昊镐蒿壕灏嚎濠蚝貉颢嗥薅嚆")
    ("he" "和合河何核贺喝赫荷盒鹤吓呵禾菏壑褐涸阂阖劾诃颌嗬貉曷翮纥蚵盍")
    ("hei" "黑嘿嗨")
    ("hen" "很狠恨痕")
    ("heng" "衡横恒亨哼珩桁蘅")
    ("hong" "红宏洪轰虹鸿弘哄烘泓訇蕻闳讧荭黉薨")
    ("hou" "后候厚侯猴喉吼逅篌糇骺後鲎瘊堠")
    ("hu" "护户湖互乎呼胡忽虎沪糊壶葫狐蝴弧瑚浒鹄琥扈唬滹惚祜囫斛鹘笏醐猢怙唿戽槲觳煳鹕冱瓠岵鹱烀轷")
    ("hua" "化华划话花画滑哗骅桦猾铧砉")
    ("huai" "怀坏淮徊槐踝")
    ("huan" "还环换欢患缓唤焕幻痪桓寰涣宦洹浣豢奂郇圜獾鲩鬟萑逭漶锾缳擐")
    ("huang" "黄荒煌皇凰慌晃潢谎惶簧璜恍幌湟蝗磺隍徨遑肓篁鳇蟥癀")
    ("hui" "会回挥汇惠辉恢徽绘毁慧灰贿卉悔徊秽荟晖彗讳诲珲诙蕙晦麾烩茴喙桧蛔洄浍虺恚蟪咴隳缋哕")
    ("hun" "婚混魂浑昏珲荤馄诨溷阍")
    ("huo" "和活或货获火伙惑霍祸豁嚯藿锪蠖钬耠镬夥劐攉")
    ("ji" "济机技基记计际及集级几给积极己纪即继击既激绩急奇吉季疾迹鸡剂辑籍寄挤圾冀亟寂暨脊跻肌稽忌饥祭缉棘矶汲畸姬藉瘠骥羁妓讥稷蓟悸嫉岌叽伎鲫诘楫荠戟箕霁嵇觊麂畿玑笈犄芨唧屐髻戢佶偈笄跽蒺乩咭赍嵴虮掎齑殛鲚剞洎丌墼蕺芰哜")
    ("jia" "家加价假佳架甲嘉贾驾嫁夹佼稼钾茄挟侥迦伽颊皎浃枷戛荚痂镓笳珈岬胛嘏袈湫郏徼葭袷瘕铗跏蛱恝挢敫")
    ("jian" "建间件见坚检健监减简艰践兼鉴键渐柬剑尖肩舰荐箭剪俭碱茧奸歼拣捡煎贱溅槛涧笺谏饯锏缄睑謇蹇腱菅翦戬毽笕犍硷鞯牮枧湔鲣囝裥踺搛缣鹣蒹谫僭戋趼楗")
    ("jiang" "将强江奖讲降疆蒋姜浆匠酱僵桨绛缰犟豇礓洚茳糨耩")
    ("jiao" "教交较校角觉叫脚缴胶轿郊焦骄浇椒礁佼蕉娇矫搅绞酵剿嚼饺窖跤蛟侥狡姣皎茭峤铰醮鲛湫徼鹪僬噍艽挢敫")
    ("jie" "结解界接节届介阶街借杰洁截姐揭捷劫戒皆竭诫秸睫藉拮芥诘碣嗟颉蚧孑婕疖桀讦疥偈羯喈鲒骱")
    ("jin" "进金今近仅紧尽津斤禁锦劲晋谨筋巾浸襟靳瑾烬缙矜觐堇馑荩噤廑妗槿赆衿卺")
    ("jing" "经京精境竞景警竟井惊径静敬净镜睛晶颈荆兢靖泾憬鲸茎腈菁胫阱旌粳靓痉儆迳婧肼刭弪獍")
    ("jiong" "窘炯迥炅扃")
    ("jiu" "就究九酒久救旧纠舅灸疚揪咎韭玖臼柩赳鸠鹫厩啾阄桕僦鬏")
    ("ju" "局据具举居剧巨聚距句拒俱菊拘炬桔惧矩鞠驹锯踞咀瞿枸掬沮莒橘飓疽钜趄踽遽琚龃椐苣裾榘狙倨榉苴讵雎锔窭鞫犋屦醵")
    ("juan" "卷捐眷娟倦绢隽镌涓鹃鄄蠲狷锩桊")
    ("jue" "决绝觉脚掘崛诀獗抉爵嚼倔厥蕨攫珏矍蹶谲镢嗟噱桷噘撅橛孓觖劂爝")
    ("jun" "军均俊君峻菌竣钧骏浚隽郡筠皲麇捃")
    ("ka" "卡喀咖咔佧胩")
    ("kai" "开凯慨楷恺揩锴铠忾垲剀锎蒈")
    ("kan" "看刊勘堪坎砍侃槛瞰阚龛戡莰")
    ("kang" "康抗扛慷炕亢糠伉钪闶")
    ("kao" "考靠烤拷铐栲尻犒")
    ("ke" "可科克客刻课颗渴壳柯棵呵坷恪苛咳磕珂稞瞌溘轲窠嗑疴蝌岢颏髁蚵缂氪骒钶锞")
    ("ken" "肯垦恳啃龈裉")
    ("keng" "坑铿吭")
    ("kong" "空控孔恐倥崆箜")
    ("kou" "口扣寇叩抠蔻芤眍筘")
    ("ku" "苦库哭酷裤枯窟骷堀绔刳喾")
    ("kua" "跨夸垮挎胯侉")
    ("kuai" "会快块筷脍蒯侩浍郐狯哙")
    ("kuan" "款宽髋")
    ("kuang" "况矿框狂旷眶匡筐邝圹哐贶夼诳诓纩")
    ("kui" "亏奎愧魁馈溃匮葵窥盔逵睽馗聩喟夔篑岿喹揆隗傀暌跬蒉愦悝蝰")
    ("kun" "困昆坤捆琨锟鲲醌髡悃阃")
    ("kuo" "扩括阔廓栝蛞")
    ("la" "拉垃腊啦辣蜡喇剌旯砬邋瘌")
    ("lai" "来莱赖睐徕籁涞赉濑癞崃铼")
    ("lan" "兰览蓝篮栏岚烂滥缆揽澜拦懒榄斓婪阑褴罱谰镧漤")
    ("lang" "浪朗郎廊狼琅榔螂阆锒莨啷蒗稂")
    ("lao" "老劳牢捞涝烙姥佬崂唠酪潦痨醪铑铹栳耢")
    ("le" "了乐勒肋叻鳓仂泐")
    ("lei" "类累雷泪蕾垒磊擂镭肋羸耒儡嫘缧酹嘞诔檑")
    ("leng" "冷愣棱楞塄")
    ("li" "理力利立里李历例离励礼丽黎璃厉厘粒莉梨隶栗荔沥犁漓哩狸藜罹篱鲤砺吏澧俐骊溧砾莅锂笠蠡蛎痢雳俪傈醴栎郦俚枥藓喱逦娌鹂戾唳坜疠蜊黧猁鬲粝蓠呖跞疬缡鲡鳢嫠詈悝苈篥轹")
    ("lia" "俩")
    ("lian" "联连练廉炼脸莲恋链帘怜涟敛琏镰濂楝鲢殓潋裢裣臁奁蠊蔹")
    ("liang" "量两粮良辆亮梁凉俩谅粱晾靓踉莨椋魉墚")
    ("liao" "了料疗辽廖聊寥僚燎缭撂撩嘹潦镣寮蓼獠钌尥鹩")
    ("lie" "列烈劣裂猎冽咧趔洌鬣埒捩躐")
    ("lin" "林临邻赁琳磷淋麟霖鳞凛遴蔺吝粼嶙躏廪檩啉辚膦瞵懔")
    ("ling" "领令另零灵龄陵岭凌玲铃菱棱伶拎羚苓聆翎泠瓴囹绫呤棂蛉酃鲮柃")
    ("liu" "流刘六留陆柳瘤硫溜碌浏榴琉馏遛鎏骝绺镏旒熘鹨锍")
    ("long" "龙隆垄笼拢聋陇胧珑窿茏咙砻垅泷栊癃")
    ("lou" "楼漏陋娄搂篓喽镂偻瘘髅耧蝼嵝蒌")
    ("lu" "路陆录露鲁卢炉鹿禄赂芦庐碌麓颅泸卤潞鹭辘虏璐漉噜戮鲈掳橹轳逯渌蓼撸鸬栌氇胪镥簏舻辂垆")
    ("lv" "率律旅绿虑履吕铝屡氯缕滤侣驴榈闾褛捋膂稆")
    ("luan" "乱卵滦峦鸾栾銮挛孪脔娈")
    ("lue" "略掠锊")
    ("lun" "论轮伦仑纶沦抡囵")
    ("luo" "落罗络洛逻螺锣骆萝裸漯烙摞骡箩珞捋荦硌雒椤镙瘰泺脶猡倮蠃")
    ("m" "呒")
    ("ma" "马吗麻码妈玛嘛骂抹蚂唛蟆犸杩嬷")
    ("mai" "买卖麦迈脉埋霾荬劢")
    ("man" "满慢曼漫蔓瞒蛮鳗馒幔谩螨熳缦镘颟墁鞔")
    ("mang" "忙盲茫芒氓莽蟒邙硭漭")
    ("mao" "贸毛矛冒貌茂茅帽猫髦锚懋袤牦卯铆耄峁瑁蟊茆蝥旄泖昴瞀")
    ("me" "么麽")
    ("mei" "美没每煤梅媒枚妹眉魅霉昧媚玫酶镁湄寐莓袂楣糜嵋镅浼猸鹛")
    ("men" "们门闷扪焖懑钔")
    ("meng" "蒙盟梦猛孟萌朦锰檬勐懵蜢虻蠓艨甍艋瞢礞")
    ("mi" "米密秘迷弥蜜谜觅靡泌眯麋猕谧咪糜宓汨醚嘧弭脒幂祢縻蘼芈糸敉")
    ("mian" "面棉免绵缅勉眠冕娩腼渑湎沔黾眄")
    ("miao" "苗秒妙描庙瞄缪渺淼藐缈邈鹋杪眇喵")
    ("mie" "灭蔑篾乜咩蠛")
    ("min" "民敏闽闵皿泯岷悯珉抿黾缗玟愍苠鳘")
    ("ming" "明名命鸣铭冥茗溟酩瞑螟暝")
    ("miu" "缪谬")
    ("mo" "模末莫摩墨默磨摸漠膜魔沫陌抹寞蘑摹蓦馍茉嘿谟秣貉嫫镆殁耱麽瘼貊貘")
    ("mou" "某谋缪眸哞鍪蛑侔")
    ("mu" "目木亩幕母牧穆姆墓慕牟牡募睦沐暮拇钼苜仫毪坶")
    ("n" "嗯唔")
    ("na" "那纳拿呢哪娜钠呐捺衲镎肭")
    ("nai" "乃奶耐奈鼐萘氖柰佴艿")
    ("nan" "南难男楠喃囡赧腩囝蝻")
    ("nang" "囊馕囔曩攮")
    ("nao" "脑闹恼挠瑙淖孬垴铙呶硇猱蛲")
    ("ne" "呢讷")
    ("nei" "内馁")
    ("nen" "嫩恁")
    ("neng" "能")
    ("ng" "嗯唔")
    ("ni" "你尼呢泥拟逆倪妮腻匿霓溺旎昵坭铌鲵伲怩睨祢猊慝")
    ("nian" "年念粘碾廿捻撵拈蔫鲶埝鲇辇黏")
    ("niang" "娘酿")
    ("niao" "鸟尿袅脲茑嬲")
    ("nie" "聂捏涅镍孽蘖啮蹑嗫臬镊颞乜陧")
    ("nin" "您恁")
    ("ning" "宁凝苎拧泞柠咛狞佞聍甯")
    ("niu" "牛纽扭钮拗妞忸狃")
    ("nong" "农浓弄脓侬哝")
    ("nou" "耨")
    ("nu" "努怒奴弩驽孥胬")
    ("nv" "女钕衄恧")
    ("nuan" "暖")
    ("nue" "虐疟")
    ("nuo" "诺挪糯懦傩喏搦锘")
    ("o" "哦噢喔")
    ("ou" "欧偶殴呕藕讴鸥瓯沤耦怄")
    ("pa" "怕帕爬扒趴琶啪葩耙杷钯筢")
    ("pai" "牌排派拍徘湃俳哌蒎")
    ("pan" "判盘潘攀盼拚畔叛蹒磐爿蟠泮袢襻")
    ("pang" "旁庞乓膀胖磅螃彷滂逄耪")
    ("pao" "跑炮泡抛刨袍咆疱庖狍匏脬")
    ("pei" "配培赔佩陪沛裴胚霈旆帔呸醅辔锫")
    ("pen" "喷盆湓")
    ("peng" "鹏朋彭膨蓬碰棚捧烹篷澎抨硼怦砰嘭蟛堋")
    ("pi" "批否皮辟啤匹披疲僻毗坯脾譬劈媲屁琵邳裨痞癖陂丕枇噼霹吡纰砒铍淠郫埤睥芘蚍圮鼙罴蜱疋貔仳庀擗甓陴")
    ("pian" "便片篇偏骗翩扁骈胼蹁谝犏缏")
    ("piao" "票漂飘嫖瓢剽缥殍瞟骠嘌莩螵")
    ("pie" "瞥撇苤氕丿")
    ("pin" "品贫聘频拼拚颦姘嫔榀牝")
    ("ping" "平评凭瓶屏萍苹乒坪枰娉俜鲆")
    ("po" "破坡迫颇泊婆泼魄粕鄱珀陂叵笸泺皤钋钷攴")
    ("pou" "剖掊裒")
    ("pu" "普铺浦朴葡谱埔扑仆蒲瀑溥莆圃璞濮菩脯蹼匍噗氆镨镤")
    ("qi" "企其起期气七器汽奇齐启旗棋妻弃歧欺骑契迄亟漆戚岂岐琦栖琪泣乞砌祁崎绮祺蹊祈凄淇杞脐麒圻憩芪俟畦荠耆葺沏萋骐鳍綦讫蕲屺颀亓碛柒汔綮萁嘁蛴槭欹芑桤蜞")
    ("qia" "恰洽伽掐髂袷葜")
    ("qian" "前千钱签潜迁欠纤牵浅遣谦乾铅歉黔谴嵌倩钳虔堑钎骞阡掮钤扦芊犍荨仟芡悭缱佥愆鬈褰肷岍搴箝慊椠")
    ("qiang" "强抢墙枪腔锵呛羌蔷襁羟跄樯戕嫱戗炝镪锖蜣")
    ("qiao" "桥乔侨巧悄敲俏瞧翘窍峭锹撬荞跷樵憔鞘橇峤诮谯愀鞒硗劁缲")
    ("qie" "切且窃茄砌锲怯伽惬妾趄挈郄箧慊")
    ("qin" "亲勤侵秦钦琴禽芹沁寝擒覃噙嗪揿溱芩衾廑锓吣檎螓")
    ("qing" "情青清请轻庆倾顷卿晴氢擎氰罄磬蜻箐鲭綮苘黥圊檠謦")
    ("qiong" "穷琼穹邛茕筇跫蛩銎")
    ("qiu" "求球秋丘邱酋裘囚遒鳅虬蚯泅楸湫犰逑巯俅蝤赇鼽糗")
    ("qu" "区去取曲趋渠趣驱屈躯衢娶祛瞿戌岖龋觑朐蛐癯蛆苣阒诎劬蕖蘧氍黢蠼璩麴鸲磲")
    ("quan" "全权券泉圈拳劝犬铨痊诠荃醛蜷颧绻筌鬈悛辁畎")
    ("que" "确却缺雀鹊阙瘸榷炔阕悫")
    ("qun" "群裙逡麇")
    ("ran" "然染燃冉苒髯蚺")
    ("rang" "让壤攘嚷瓤穰禳")
    ("rao" "绕扰饶娆桡荛")
    ("re" "热惹喏")
    ("ren" "人任认仁忍韧刃纫饪妊荏稔壬仞轫衽葚")
    ("reng" "仍扔")
    ("ri" "日")
    ("rong" "容荣融绒溶蓉熔戎榕茸冗嵘肜狨蝾")
    ("rou" "肉柔揉糅鞣蹂")
    ("ru" "入如乳儒辱汝茹褥孺濡蠕嚅缛溽铷洳薷襦颥蓐")
    ("ruan" "软阮朊")
    ("rui" "瑞锐睿芮蕊蕤蚋枘")
    ("run" "润闰")
    ("ruo" "若弱偌箬")
    ("sa" "萨洒撒飒卅仨挲脎")
    ("sai" "赛塞腮噻鳃")
    ("san" "三散伞叁糁馓霰毵")
    ("sang" "桑丧嗓搡颡磉")
    ("sao" "扫骚嫂梢缫搔瘙臊埽缲鳋")
    ("se" "色塞瑟涩啬穑铯")
    ("sen" "森")
    ("seng" "僧")
    ("sha" "沙厦杀纱砂啥莎刹傻煞鲨霎嗄痧裟挲铩唼歃")
    ("shai" "筛晒酾")
    ("shan" "山善陕闪衫擅汕扇杉掺珊删膳缮赡鄯栅煽姗跚鳝嬗潸讪舢苫疝掸膻钐剡蟮芟埏髟骟")
    ("shang" "上商尚伤赏裳墒晌垧觞殇熵绱")
    ("shao" "少绍烧稍邵哨韶捎勺梢鞘芍苕劭艄筲杓蛸潲")
    ("she" "设社摄涉射舍蛇舌奢慑赦赊佘麝歙畲厍猞滠")
    ("shei" "谁")
    ("shen" "深参身神什审申甚沈伸慎渗肾绅莘呻婶娠砷蜃哂椹葚糁渖诜谂矧胂")
    ("sheng" "生声升胜盛圣剩牲绳笙甥嵊晟渑眚省")
    ("shi" "是市时实事十使世施式势视识师史示石食始士失适试室诗饰释驶氏逝湿蚀狮誓拾尸匙仕柿矢峙侍噬嗜拭嘘屎恃轼虱舐莳铈谥炻豕鲥螫酾筮埘弑蓍鲺贳")
    ("shou" "收手受首售授守寿瘦兽狩绶艏")
    ("shu" "术书数属树输束述署熟殊蔬舒疏鼠淑叔暑枢墅俞曙抒竖蜀薯梳戍恕孰沭赎庶漱塾倏澍纾姝菽黍腧秫毹殳疋摅丨")
    ("shua" "刷耍唰")
    ("shuai" "率衰帅摔甩蟀")
    ("shuan" "栓拴涮闩")
    ("shuang" "双爽霜孀泷")
    ("shui" "水税谁睡")
    ("shun" "顺瞬舜吮")
    ("shuo" "说硕烁朔铄妁槊蒴搠")
    ("si" "司四思斯私死似丝饲寺肆撕泗伺嗣祀厮驷嘶锶俟巳蛳咝耜笥鸶缌澌姒汜厶兕")
    ("song" "送松宋讼颂耸诵嵩淞怂悚崧凇忪竦菘")
    ("sou" "艘搜擞嗽嗖叟馊薮飕嗾溲锼螋瞍")
    ("su" "速素苏诉塑肃俗宿粟溯酥夙愫簌稣僳谡涑蔌嗉觫")
    ("suan" "算酸蒜狻")
    ("sui" "随岁虽碎隧遂髓穗绥隋邃睢祟濉燧谇眭荽")
    ("sun" "损孙笋荪榫隼狲飧")
    ("suo" "所索缩锁梭琐嗦唆唢娑蓑羧挲桫嗍睃")
    ("ta" "他它她塔踏塌榻沓漯獭嗒挞蹋趿遢铊鳎溻闼")
    ("tai" "台太态泰抬胎汰钛苔薹肽跆邰鲐呔酞骀炱")
    ("tan" "谈探坦摊弹炭坛滩贪叹谭潭碳毯瘫檀痰袒坍覃忐昙郯澹钽锬镡")
    ("tang" "堂唐糖汤塘躺趟倘棠烫淌膛搪镗傥螳溏帑羰饧樘醣螗耥铴瑭")
    ("tao" "套讨陶涛逃桃萄淘掏滔韬焘洮啕绦饕鼗")
    ("te" "特忑忒铽慝")
    ("tei" "忒")
    ("teng" "腾疼藤滕誊")
    ("ti" "体提题替梯踢惕剔蹄啼屉剃涕锑倜悌逖嚏荑醍绨鹈缇裼")
    ("tian" "天田添填甜恬腆舔钿阗忝殄畋掭")
    ("tiao" "条调挑跳迢眺苕窕笤佻粜髫祧龆蜩鲦")
    ("tie" "铁贴帖餮萜")
    ("ting" "听庭停厅廷挺亭艇婷汀铤烃霆町蜓葶梃莛")
    ("tong" "同通统童痛铜桶桐筒彤侗佟潼捅酮砼瞳恸峒仝恫嗵垌茼")
    ("tou" "投头透偷钭骰")
    ("tu" "土突图途徒涂吐屠兔秃凸荼钍菟堍酴")
    ("tuan" "团湍疃抟彖")
    ("tui" "推退腿褪颓蜕忒煺")
    ("tun" "吞屯囤褪豚臀饨暾氽")
    ("tuo" "托脱拓拖妥驼陀沱鸵驮唾椭坨佗砣跎庹柁橐乇铊酡鼍箨柝")
    ("wa" "瓦挖娃洼袜蛙凹哇佤娲腽")
    ("wai" "外歪崴")
    ("wan" "万完晚湾玩碗顽挽弯丸莞皖宛婉腕蜿惋烷琬畹豌剜纨绾脘菀芄")
    ("wang" "王望往网忘亡旺汪枉妄惘罔辋魍尢")
    ("wei" "为位委未维卫围违威伟危味微唯谓伪慰尾魏韦胃畏帷喂巍萎蔚纬潍尉渭惟薇苇炜圩娓诿玮崴桅偎逶猥囗葳隗痿猬涠嵬韪煨艉帏闱洧沩隈鲔軎")
    ("wen" "文问闻稳温纹吻蚊雯紊瘟汶刎璺阌")
    ("weng" "翁嗡瓮蓊蕹")
    ("wo" "我握窝沃卧挝涡斡渥幄蜗喔倭莴龌肟硪")
    ("wu" "务物无五武午吴舞伍污乌误恶屋晤悟吾雾芜梧勿巫侮坞毋诬呜钨邬捂鹜兀婺妩於戊鹉浯蜈唔骛仵焐芴鋈庑鼯牾怃圬忤痦迕杌寤阢")
    ("xi" "系西席息希习吸喜细析戏洗悉锡溪惜稀袭夕晰昔牺烯熙媳膝隙犀蹊硒兮熄曦禧茜嬉玺奚汐徙羲铣淅嘻歙熹矽蟋郗唏皙隰樨浠蜥檄翕阋舾屣葸螅粞觋欷僖醯鼷穸饩舄禊菥蓰")
    ("xia" "下夏峡厦辖霞虾狭吓侠暇遐瞎匣瑕唬呷黠硖罅狎瘕柙")
    ("xian" "现先县线限显险献鲜宪纤陷闲贤仙衔掀咸嫌羡弦腺痫娴舷馅酰铣冼涎暹籼锨苋蚬跹岘藓燹鹇氙莶霰跣猃祆筅")
    ("xiang" "向项相想乡象响香降像享箱祥湘详橡巷翔襄厢镶飨饷缃骧芗庠鲞葙蟓")
    ("xiao" "小效销消校晓笑肖削孝萧潇硝宵啸嚣霄淆哮筱逍箫骁枭哓绡蛸崤枵魈")
    ("xie" "些协写谢械鞋胁斜携懈卸谐泄蟹邪歇泻屑挟燮榭蝎撷偕亵楔颉缬邂瀣勰榍薤绁渫廨獬躞")
    ("xin" "新心信辛欣薪馨鑫芯锌忻昕衅歆囟镡")
    ("xing" "行性形型兴星刑幸姓醒邢杏腥猩悻荥陉惺饧擤硎荇")
    ("xiong" "雄兄熊胸凶匈汹芎")
    ("xiu" "修秀休宿袖绣臭朽锈羞嗅岫溴庥馐咻髹鸺貅")
    ("xu" "需许续须序徐蓄畜虚吁绪叙旭恤墟栩絮圩婿戌胥嘘浒煦酗诩盱蓿溆洫顼勖糈砉醑")
    ("xuan" "选宣券旋悬轩喧玄绚渲璇炫萱癣漩眩暄煊铉楦泫谖痃碹揎镟儇")
    ("xue" "学血雪削薛穴靴谑噱鳕踅泶")
    ("xun" "讯训迅寻询循旬巡汛勋逊熏徇浚殉驯鲟荤薰荀浔洵峋埙巽郇醺恂窨蕈曛獯")
    ("ya" "亚压雅牙押鸭呀轧涯崖芽哑讶鸦娅衙丫蚜垭伢氩桠琊揠睚痖疋迓岈砑")
    ("yan" "研严验演言眼烟沿延盐炎燕岩宴艳颜彦掩淹阎衍雁咽厌焰堰砚唁焉晏檐蜒奄俨腌妍谚兖筵焱偃闫嫣鄢湮赝胭琰滟阉魇酽郾恹崦芫阏剡鼹菸餍谳厣罨阽鼽")
    ("yang" "样养央阳洋扬杨羊氧仰秧痒漾疡泱殃恙鸯徉佯怏炀烊鞅蛘")
    ("yao" "要药邀摇耀腰遥姚窑瑶咬尧钥谣肴夭侥吆妖幺杳舀窈曜鹞爻繇徭轺铫鳐崾珧")
    ("ye" "业也夜叶野液冶页爷耶咽椰烨掖拽曳晔谒腋噎揶靥邺铘")
    ("yi" "一以已意议义益亿易医艺依移衣异伊仪宜遗疑毅谊亦艾疫役忆抑乙译翼蛇溢椅沂逸蚁夷邑怡绎彝裔姨熠贻矣屹颐倚诣胰奕翌弈轶驿壹猗臆弋铱旖漪迤佚翊诒怿痍懿饴峄揖眙镒仡黟肄咿翳挹缢呓刈咦嶷羿钇殪荑薏蜴镱噫癔苡悒嗌瘗欹佾埸圯舣酏劓燱")
    ("yin" "因引银印音饮阴隐姻殷淫尹荫吟瘾寅茵圻垠鄞湮蚓氤胤龈窨喑铟洇狺夤吲霪茚堙")
    ("ying" "应营影英迎映硬盈赢颖婴鹰荧莹樱瑛蝇萦莺颍膺缨瀛楹罂荥萤鹦滢蓥郢茔嘤璎嬴瘿媵撄潆")
    ("yo" "哟唷")
    ("yong" "用永拥勇涌泳庸俑踊佣咏雍甬镛臃邕蛹恿慵壅痈鳙墉饔喁")
    ("you" "有由又优游油友右邮尤忧幼犹诱悠幽佑釉柚铀鱿囿酉攸黝莠猷蝣疣呦蚴莸莜铕宥繇卣牖鼬蝤尢蚰侑")
    ("yu" "于与育余预域予遇语誉玉鱼雨渔裕愈娱欲吁舆宇羽逾豫郁寓狱喻御浴愉禹俞榆愚渝淤虞屿峪粥驭瑜禺毓钰隅芋熨瘀迂煜昱於臾盂聿竽萸妪腴圄谕觎揄龉谀俣馀庾妤瘐鬻欤鹬阈嵛雩鹆菀圉蜮伛纡窬窳饫蓣狳舁蝓燠")
    ("yuan" "元员院原源远愿园援圆缘袁怨渊苑冤媛猿垣沅塬垸鸳辕鸢瑗圜爰芫鼋橼螈眢箢掾")
    ("yue" "月约越乐跃阅岳粤悦曰钥栎钺樾瀹龠刖")
    ("yun" "运云允孕蕴韵酝耘晕匀芸陨纭熨郧筠恽韫郓氲殒愠昀狁")
    ("za" "杂扎砸咋匝咂拶")
    ("zai" "在再灾载栽仔宰哉崽甾")
    ("zan" "赞暂咱攒昝簪糌瓒錾趱拶")
    ("zang" "藏脏葬赃臧锗奘驵")
    ("zao" "造早遭枣噪灶燥糟凿躁藻皂澡蚤缲唣")
    ("ze" "责则泽择咋啧仄箦赜笮舴昃迮帻")
    ("zei" "贼")
    ("zen" "怎谮")
    ("zeng" "增赠憎锃甑罾缯")
    ("zha" "扎炸诈轧闸渣咋乍榨楂札栅眨咤柞喳铡蚱吒砟揸痄哳齄")
    ("zhai" "债宅寨摘窄斋翟砦瘵")
    ("zhan" "展战占站崭粘湛沾瞻詹斩盏辗绽毡栈蘸旃谵搌")
    ("zhang" "长张章障涨掌帐胀彰丈仗漳樟账杖璋嶂仉瘴蟑獐幛鄣嫜")
    ("zhao" "着照招找召朝赵兆昭肇罩钊沼诏啁棹笊")
    ("zhe" "这者着浙折哲蔗遮辙辄柘锗褶蜇蛰鹧谪赭摺磔")
    ("zhen" "镇真针圳振震珍阵诊侦臻贞枕桢赈祯甄斟缜箴疹砧榛鸩轸稹溱蓁胗椹朕畛浈")
    ("zheng" "政正证争整征郑症挣蒸睁铮筝拯帧峥怔诤狰徵钲鲭")
    ("zhi" "制之治质职只志至指织支值知直致执置止植纸智殖秩旨址滞枝芝脂帜汁肢挚稚酯掷峙炙栉侄芷窒咫吱趾痔蜘郅桎雉祉陟痣蛭帙枳踯徵胝栀贽祗豸鸷摭轵卮轾彘觯絷跖埴黹忮骘膣踬")
    ("zhong" "中重种众终钟忠仲衷肿踵冢盅忪锺舯螽")
    ("zhou" "州周洲舟骤轴昼宙粥皱肘咒帚胄绉纣妯啁诌繇碡籀酎荮")
    ("zhu" "主住注助逐著筑驻朱珠祝猪诸柱竹铸株瞩嘱贮煮烛苎褚蛛拄铢洙竺蛀渚伫杼侏诛茱箸炷躅翥潴邾槠舳橥瘃麈疰")
    ("zhua" "抓爪")
    ("zhuai" "拽嘬")
    ("zhuan" "专转传赚砖撰篆馔啭颛")
    ("zhuang" "装状庄壮撞妆幢桩奘僮戆")
    ("zhui" "追坠缀椎锥赘惴隹骓缒")
    ("zhun" "准谆肫窀")
    ("zhuo" "着桌卓捉琢灼浊酌拙茁涿镯啄濯焯倬擢斫诼浞禚")
    ("zi" "资自子字咨滋仔姿紫兹孜淄籽梓鲻渍姊吱秭恣孳訾滓锱辎趑龇赀眦缁呲笫谘嵫髭茈粢觜耔")
    ("zong" "总综宗纵踪棕粽鬃偬枞腙")
    ("zou" "走邹奏揍诹驺陬鄹鲰")
    ("zu" "组族足祖租阻卒俎诅镞菹")
    ("zuan" "钻赚纂攥缵躜")
    ("zui" "最罪嘴醉咀蕞觜")
    ("zun" "尊遵鳟樽撙")
    ("zuo" "作做座左坐昨佐琢凿撮祚柞唑嘬酢怍笮阼胙"))
  "拼音汉字对照表，第一个元素为拼音，第二个元素为拼音对应的汉字组成的字符串。")

(defvar pyim-pymap-commonly-used-cchar
  (cl-remove-if-not
   (lambda (char)
     (string-match-p "\\cc" char))
   (split-string "
的一国在人了有中是年和大业不为发会工经上地市要个产这出行作生家以
成到日民来我部对进多全建他公开们场展时理新方主企资实学报制政济用
同于法高长现本月定化加动合品重关机分力自外者区能设后就等体下万元
社过前面农也得与说之员而务利电文事可种总改三各好金第司其从平代当
天水提商十管内小技位目起海所立已通入量子问度北保心还科委都术使明
着次将增基名向门应里美由规今题记点计去强两些表系办教正条最达特革
收二期并程厂如道际及西口京华任调性导组东路活广意比投决交统党南安
此领结营项情解议义山先车然价放世间因共院步物界集把持无但城相书村
求治取原处府研质信四运县军件育局干队团又造形级标联专少费效据手施
权江近深更认果格几看没职服台式益想数单样只被亿老受优常销志战流很
接乡头给至难观指创证织论别五协变风批见究支那查张精林每转划准做需
传争税构具百或才积势举必型易视快李参回引镇首推思完消值该走装众责
备州供包副极整确知贸己环话反身选亚么带采王策真女谈严斯况色打德告
仅它气料神率识劳境源青护列兴许户马港则节款拉直案股光较河花根布线
土克再群医清速律她族历非感占续师何影功负验望财类货约艺售连纪按讯
史示象养获石食抓富模始住赛客越闻央席坚份士热限米银息校均房周游千
失八检足配存九命尔即防钱评复考依断范础油照段落访未额双让切须儿便
空往你层低奖注黄英承远版维算破铁乐边初满病响药助致善突爱容香称购
届余素请白宣健牌促培竞巴稳继紧字困刘旅声超随例担友号显却监材且春
居适除红半买充陈火搞图阳六察试太什执片古七球修尽控讲排粮武预亲挥
卖审措荣洲卫希店良属险曾围域令站苏龙念罗吨器汇康减习演普田班待星
飞写矿轻扩言章汽靠毛终仍景置底福止离泽波兰核降训逐票菜座献钢眼损
宁像苦印融独湖早予夫编换欧努著顾征升态套介送某斗状画留航派室临兵
补宝略黑综云差纳密贫剧犯阿击遇岁阶烈督吃丰馆招害官树听庭另沙私针
胜贷网愿托缺园假酒音巨既判输讨测读洋括筑欢刚庆久陆找楼激晚绝压故
互签汉草木亩短绍迎吸警藏疗贵纷授登探索湾宏录申诉秀序顺死卡歌午孩
桥喜川邓扬津温船库订练候退违否彩棉帮拿罪币角召灾妇杨奋绩虽煤免笔
够永圳停奥鲜朝吴岛觉移尼急博贯拥束左细舞幅语俄奇般简拍脑债固威券
追筹刻映繁伟甚饭右彻烟沿街血冲洪植誉刊玉厅救潮迅伍怎付倍顿述播励
斤乎纸振旧障鼓艰呼吉男绿尚夏亏季松哈祖典韩遍夜轮板抗摄杂皮贡借幕
罚伤岸扶乱曲脱践危澳童散味叶累谢孙邮雄兼微呢谁惠偿署择染答块徐鱼
赞课盛延瑞怀堂驻零辆齐胡途封似润守毕坦母雨败朱污趋械纺租灵拓残含
握跨衣储瓦蒙鉴析竟骨档秘禁赵宾异伊智钟键辉跃冷倒庄毒仪哪涉泛宗鹏
归岗雷礼尤休泰疾肥珠叫牛宜抵挂寻父攻佳塞架符裁虑肉启丽露鲁秋昌估
射册若宽厚盾硬末轨饮勤茶诗郑冠涨篇泥唱纯坡熟浙晓抢丝锦载笑勇杰患
乌坐雪戏背塔翻沈遗聚渠哥享迹森辽衡掌牧附操赶览野盟殊仁错萨夺梅误
词董潜卷矛腐亮冒盖旗井凡震峰坏倾距壮惊盘梁摆径忠冰峡丹避珍乘刑扎
透迫箱莫跑穿祝乏厦渐软询折浪朋敢诚弱疑邀沉端床络疆缩脚甘贴勒荒唐
静缓侵句尊塑肃怕耕痛援劣伙挑洗暴冬龄乔餐肯廉跟阵伐悉忘闭奔恢宋泉
杯渡吗奉婚赴恩盐掉洁亡洛聘蔬混摩抽鸡剂胆麦谋雅废贺羊阔唯捐返隆穷
辛猪帐饰郭颁灯绕诸伴顶祥谓恶番敏旦劲缴麻屋跳码鞋扣迈忙趣盈棋勃敬
辑摊旺纠炼梦偏渔牙侨黎赔裕宫谷概稿柱弹殖秩凭拨幸洞伪沟姓遭涌陶迁
诺拔畅忧胞丁蓄贝舍腾杀煌圆伦横薄畜毫豪弟呈佛邦您墨徽惯循蓝烧触陕
拖伯盲宪净卢炭籍秦粉妻爆欣释玩俊欠蛋猛迪苗暂貌遵锡楚桂昆杜皇醒燃
凤截铺液撤胶慢杭虚辞曼毅咨俗糖忽芳姐耗妈谊浦频阻允宅窗默胀弃倡灭
甲症埃滨赏莱拒淡坛陵绘虎竹赢锋篮迷纽轿贩递娘圈挖炉替幼乃郊颇戴滑
徒崇涛焦凝墙吧炎刀玻寿履圣昨酸朗媒桑铜仲亦诞揭纵漫愈辟赠旱奶泳枪
骗虫池镜浓拆艾扫娱钻碍寒迟邻曹盗穆豆赚晨浩彭耳瓜扭脸燕摇寄仿炮晋
泪欲饱壁锁刷柬诊磨捕寨滚膨孔添帝辖炸旨吁址驶抱嘉拜扰袋佩阴辈锅赖
剩押怪浮枚栏毁柳恐敦孟旁仓岩伸岭耐懂捷璃溪暖纤汗疫巧旋侧冶陪鸣瓶
纲挤旬舆喝陷缘稻饲滩隔慰朴隐灌拟偷闲赫恰慧蒋闹邹牵柴刺滞彰俱勘填
琛尝贾搬淮奏荷滋覆役秒踏巩摸荡辅惜柜肖颗搏氏姑弄姜君舒兑宇割哲摘
钦逃漠忆敌宿啊凌耀闯阅贪赤汪悲抑瓷冯厉粗菲琴堡斌掘稀衰驾雕牢氛驱
妥悄郎巡臣羽灰癌颖姆漏袭贤鸟暗茂孤惩榜袁桌卓傅剑堆兆狠轰拳妹绒裂
潘兄洽叹涵贿侯岚熊绪阁尾碑尖腿涂栽坝犹铸肩闪诱辩芬睡奠伏妙乙绸廷
夕恒梯赁霞攀枝译描湘磁吕硕爸肝峻葡衷搭唤薪挺逝狗蔡宴蓬撞铝牲舰胁
崛桃斜丧烂屏砖墓详逾函跌抚插戈凉啤脉滥赋柏堤腰泊寺尘蒂削仙踪冻汤
睛艳荐劫框廊惑页拼堪携丈乳挪谱舶埔遥菌塘氧晶洒株颜虹岳胸忍甜匹瞩
懈爷丛莲叙鸿逢抬嘴弘炒喷吊窝衔吹霸仔垦胎慎脏歧疏悠慕漂杆萍舟吐玲
凯戒盼偶盆慨弊箭茅衫罐串辐腹钩碰昂酬晰姿彼锻飘嫁竣缝蹈悬紫浅缆喊
昔驰湿剪侦坑姚魏扑挣焕皆狂泡骤堵膜禽锐芝帽擅沪晤婆埋劝碗玛顷鸭娃
豫匆魂哭庞亭屡逼尺撒鹿讼弥坊碎缔霍壤萄铃稍丘肿烦苹庙雇汛孝辰吞汰
怨酿耶咱欺丢琼棚披渴屈弗疲帕昭盒仰萧牺撑抛鼠纱翼兹骑糊契铭淘顽撰
乒淑妆窑柔姻苍谨卿灿栋敲窃菊郁催眉邱揽鼎韦肤娜俏呀拚寸爬悟尿罢圭
葬聪沃肠厕慈恋绵橡圾垃翁粤脂歹憾阐甸巷蜂轴艘垄衬阜惨冀幽厘崭筋寓
迄渗碘碧赌袖奈崔悦捞剥孕逆婴脆缅艇谭笼儒粒诈遣垂磋卸帜枣幢淀帆蛇
宰殿猎叔夹帅沧魅俩牟钓葛罕渤汕溢擦袱嫩桶殷酷呆卧暑骄幻囊掀醉牡饼
扇蒸赣俭椅枢彦樊吾仗彬砂绳巾喀勋愁碱谦壳轧潭浆挽邢啥焊钞烤廖猫狱
腔喻御蕴坎魔刮瘤茫竭莉链淫愤纹咸睐睹裤夸滴雾搜拘龚凶茨傲鞍鹤蚀颈
翠卉汁冈狮隧弯胃沛募琳疼蚕泼磷捧炳绣朵涯掏奎聂孜韵浑翔魄掩斥敞腊
愧粘丑溉斑啦柯谐烯禄浴涝鬼薛瘦挡昏鹅湛逻虾沂辱叉鼻厨鲍鞭辣潇乓肺
尹颂邵澜桐鹰妨闽屠畏翰塌亟寂赂犬聊暨垫泄漆旭蕾坪涤挫佐瞄拦硫棒杏
爽碳畔熙襄祸乾淹臂莎辜阎庸砍捉勾垒衍坤噪毯倪扮铅遏哀愉瑶咬嫌闸恳
齿杠怒兽浇肇鄂溶哄棵盯梨灶屯狭陋啡浸淋濒脊戚勉膏氨墅沸挨蔓抄芒秉
刹饶厢咖魁骚缚遂恨跻螺辨菇帷凰椒汝瞬淄舱馈桩炬誓卜麟岂兔眠泵拐肚
匪芦匈霉蜜荆雁窄秧枯仆嘱壶谅哨肌贬叠稽岐沫肆醇菱彪躺摔膀甫逊凑渊
喂藤砸悔杉霜厄忌桔筒丙臭拾芜禹丸蟹嘛俞翅尸澄骂睦馨郝贮陌钧轩赃笋
歉逸歪巍萃崖窟踢锣萎庐剖籽甩饥苑恼渣痕莞硅晴巢瘫缠隶筛穴昼埠宠肢
饿仑逮兢趟糕妮邪抹俑萌匠扔酱葱礁掺雀髓悼挚蔚枫庚伞侃僵捆蒜溜傻蔗
谜斋蝶沾闷驳耿槽黔吓肾芽栗朽荫榆皖曰徊奴迭僻蓉靖氟滔羡愚尧俺徘罩
磊镑舌曙纶粪匙钉佼扯踊躲猴纬咽酝挠宛瑰歇抒茧穗祭鑫趁痴裙猜耘碌锈
晒潍弦稼狼拢梧芯眷哑宙厌逛谴邯呵蜡寥钥耸媳熏蚁惕颠娟亨吟蒲梭瞻渝
喉遮慌夷韶焰尉珊胖蕉粹裹琦秽侠奸挝绑曝棍婉镶熬傍燥氯骆晃鸽疯琢聋
瑟暇绥禅溃腺垮阀撼煮佣滕淤蹲栖硝睁荟荧抖坟芭臻锭晖倦倘喘邑锤惧荔
毗觅矮恭钙氮缸瞧颤萝佑怡瘾寡烹摧棠缪雏韧喇兜坯坷贞仇缉帘竖糟猖懒
凿洼喧谣驼烫锌椰崩沥汾磅霖棘扛彗矩瞒陇绎诫斐卵铮钾宵簿秤畴斧擂剔
躁冤讳寅焚漳鳖哺耻僧琅粟怖咏蜀淳柑缕烁氢蔽琪泣阮镀殴虞虐炊搁诀掠
坠屿髦酋躯吵遐寞仕稚僚楠矶筝彝叮熔槐潢芹郸匾咋玄裔陡哗怜襟刃脾嵌
拱慷痪跋孚峪钊滇苟晕墩膝羞乍腻詹讶敷肴莹衢柿朔袜枕烘匀歼泻樱吻翟
堰苯隙娇獗汲蛙斩靡沁乞姨翩沼嘎畸矫骏薯绚窜藻矗皂楷腕篷徇耽娼犁榻
茄棕汹峨蹄昧奢涩灼踩粥拣旷簇溯攒沓呕梳搅砌纫渭澡撕漓葆辍肪祁鞠蛮
捏诵娣岱瀑啸裸鸦瑛躬舜忱豹纂恤惟赐俯犀媚嫂嗓蚊茬驭缀皱凳钮蚂姬扒
嫖跪凹揣尬沦尴豁玫殡淌叭唇啃裘卑琐矢拯忡勿盎茵椎脖拂骅葫迢薇龟绞
眶沐傣浊舅叛浚窘栓酶笛泌榄惹铲碟捡恪酯滤匿酵砚贼匮熠鳞麓镁氓苇廓
巫踵竿蘑翘梓贻鳗帼冉泓狐涟崎窍瑜讽逗铎掷璀泗浏陲醋苛攘璧瀚哩暮矣
蚌悖扼漯烛蝴屑墟俘侣庇陀煎秸弓捣譬炜炯拌扁彤锚禾侮秆绮嚣樟咐枉窦
桦寇哉狸耍馒驹隋冕疮咄妄峙娄溥腑钠栩糙滦呐鲻娶祺刨褒橙茹谎抉慑媛
橄戎迩雯璨雍惶扳桢霓账梗炕裴韬杖痹缤沽燎煞删辙爵缭劈烨槌媲凛莆颅
锯膳澎坞瓣婷絮酌涡唁秃禺膊棣芸忻炽榨篆憨戍圩爹蹊饪胺贱睫蝇惫拇赈
泾盏弧剿硒毓皓菏灸湄炙祠荻捍嚼朦屹紊藜驴寝兮隘祈榕臧蝉绢瞎闵鳌娥
藉娅烽楂摒凄凸熄孵叩渎胳匡袍卒怠桓莽倩泸藕陨辗骋峭冥饺亢圃颐擒铵
鳄簧愣璜钰拙瘠靳隽罹岑镭榴恕毋囤汀绽窖筷擎猿诲碾夭筐邃藩诬芙胚哇
垣胧帖殉毙壑绰憋亥涅屁璞缮侍倚稠棺棱葵诣笨橱寰郡垢徕眺胰谆窥霄栉
舸蹦坂瞪珲釉跤挟侄肘嘲刁缎嚷痒敛祛绅孰痫闺椿噶恍伶峦酥萦苎癫涪锲
蜚拎嵩昊娴涣烙璋笃囚祯篱讴舷纭锄巅卦摹眸柄踞焉辄褚褐湃夙堕岔惦疚
谍奕羚帧澈濮捎漾吼锰趴菩簸仃渲札谙咕桨咀郴咳呜蛟拧莘驯庵弼逞蹬姥
撂镍晏疡爪骥楞钳懋寐淇琉杞菠铨翌靶侗瑙馅丐痊娓侈苓聆睿偌釜噬曦燮
哟瑾瞿璇拮憬鹊勺憧嗜啼檐柚呱渍镌妃溺鸥粕沱榭隅毡禧瞅鲸淆阪茁渺瞥
茜瘟礴伺谛锹蔼虔莺迸磕赡泱栈甄镐抠嬉诿甬绊饵谬梢颍揪琶褥佟腥辊溅
琵鄯拴喃笙酰粱卤芮膛斓潼鸵侥讷婿吆羁嗣蜒栅疙拷戳镛芷钛蜿铀夯摞雌
酣荼蝎锥姊瓢祀玺弛犷哦茸鱿绷茎惋亘珑莓掂迥鲤殃瘩叨螃奄腈疟沭钨昕
膺涿糠氰揉狩檀悍缫哮衙瑚潞谤搀洱涓袤痰乖冗芋甭骸幌涮俨敖槛狄牒恺
雹赎庶熨蛛佰蓦鄱煽腌黯疤倔剌斡诽锵筱妍掖铿脐捅弈邸湟眯赦拄啪玮轶
蛾麋炫赊靴箔菁撬裳戌缨蝗撇奚瀛噩怯蓓匕咚瞰佬泞扉皋晾麒姗跚瘀鄙猕
拭鲟祷脯砺驿陛瘁搓舵汞哼胫珀邬磺馏馍铢诧涧吏苔潺邳烷囿斟滁殆酚狡
孺恬沅铬湍啧囱蒿鹃柠漱胥妖洙珂茉蹒圻鬓搂葩佘渥诙袒捂瞠妓铐澧袂馁
汐匣逍谚窒蔑糯汶壹岖盔嘘迂嘀锢讥吭抨屎獭褪咫稷迦檬塬蠢蓟咎皿驮俐
坍惭垛鹭鸾蹴撩诠恙臃遨睬踌浒搪郧竺翡宦冽憩萱拽卞槟躇蘸肋呛濡酮眨
撮矸垸蛀黛涸脓徙撷曳峥渚镖钴骊袅磐掣沌埂嘿琏楣豚诡悸麝煦矾羲唉溧
呻覃兖吱惰羹钝枸姣颓铣梆骇淅孢叱谧泯谟恃薹筵鏖栾鹜哽掬辘茗瓯绛筠
铤袄殚梵挎遴榈蜕癣垠厮幄偕焱攥裨炖旮旯蔺骡娩伫猝窿虏屉缜咒筏骼璐
剃涕猗淼侬阙嗅鸳嘈霏珩沮捺硼荃驷漩嘻眩掰伽脍婪煜鹄壕崂翎痞兀婺鸯
楹咤徜嫉篓烃铂咪掐匝杼蕃箍荤砾嘶皑宕荪哎汴貂邡淦蕙弩堑惬偃徉箴赘
啻凋穹酗憎芥唾闫晔苞昶甙笺吝蕊鳝衅猩薰昱趾淞坳怅翱汩琥岌阑粼羌霆
篡塾酉裱韭唠廿闰攸黝蛤厥荞瑕柘祚疵愕蕨牦飨疹嗷癖芪漕隍徨逵泠嵘嗡
岫岷擞陂颊咔卯婶椭惘歙幺臆叽缰睽勐暄弋痔秭煲琮嘟犊玖怦丕溴罂瓮丞
惮癜晦攫镰镯柞舫铆蹼妩熹铱褂丫笆妒噢噙琬冼荀蟾捶嗒町嫣肮皎旖恣钚
砥吩茯馥钎甥嗦蜗浔谒辫亳彷珏咯淖妊佤玷嘹崴於辕贲扈伎旎孽耙娠戊冢
跷砷焘羔圪耄钼悻荥唑稞邝莅杷醛嗽唆拗碴馋胱琨茏糜懦骞蜘嚓怵抡唢腆
涎灏臼墒暹椽牍钒猾榔懵枇樵锶籼箫漪帚钵赓捻郅儋烬锂剽锑鄢鄞臾喳胄
耋阱笠瓴啬杳萤莠嶂浜傩遒轼睢倜矽仉唬旌酪腼罄嬗畲祟桅悴讹憔龋嵊绶
邕忖箩咆晌愫猷帛麾莒觑吮蟋庥懊阂蒯阡腮潸晟蟀臀罔骁崽绉粽忿肛蠡遛
蜓煊蚜坻滹銮悯鼐撵噼忐湮侏粳矍铄坨铉盂锗阖溟俟忑赝鬃敝宸哆靓揩瘸
鲅篝氦嚎浃缙飚锷癸柩蛎濂榷鲨钡盹鲫诘诩迤桎遁尕梏楫赳飒锃雉怆痼劾
痢喽霹昙畹胭佚狈瘪姹吠铧谏雳咙畦荠娑褶忏惚痉橘漉诏呗晁惆砀馄戟峁
昵拈蠕虱洵鹦蛹铛挛倏澍濉钅噜咛俳磬蜷霎肽砼聿怔砭谌箕蹶孪蔷糅挞饨
惴禀淙哒枷楝闾蜻嗖淬垩矜郗蚤嫦喋镉饯髋潦镂簌偎鹉岙踱诃籁宓膘飙涞
耆荏渑豌琰俎绌埭幡赅锆崮碣珞腋滢蓖伉馗聩幔锨蓥鹑砝酩枰鞘苋粑蹭倌
犟俪嶙砻嵋滂葺苒枭翊婀飓阚喟傈藐蜃怂稣亵诒蜇岜霁瞌沏卅舀鹌俸嵇蟒
汨砰鞣唏陉佯恿竽瘴祉焙诋濠螂叻垅谩朐稔芍瞳惺萸盅啄眈偻爿蟠炔垭噎
蛰擘锏茭悌喔谑峋妪恽韫褓镳饽杈戛鸠萋襁榫霭苄跺杲嗨珉哌娆孀恸缄夔
佗饷苷郜鼾颌訇谲溘咧褛逄颦洮逶嫡蠹碓烩醴栎鎏瓤伢蔫怿甾摈畈镣螨秣
搔盱痍搐蹉佃绂疽骝霾悚缃懿咂奘轱邗蚝瘘醚湎瞑掮羟仨砣郢砧鳟跛踝轲
窠郦踉躏戮篾骐鳍蹂郯跎倭诅鄄褴阆缈嗯妞沤跄箐苕窕楔饴峄腴圄谕揍踹
罡佝颔觊篑鲢綦妾镗啕蚬窈揖眙蟑诛钗绯讣睾媾嗬祜镢囹苜坭蛐髯搡叟蹋
觎捱碉呋罘荚鹫岿寮扪焖狞鳅嗄嗤擀痂嗟颉蚧儆锴龛嗑锟俚枥懑讫橇嗪虬
跆骧陟灞恻涔酐鸪牯钜萘鲶缥曜蚓诤埕墀麸蝠蛊遑厩趄沔耦疱匍揿蚯讪唰
舔呷蓿鹧膑刍耷鞑裆趸孑鲲绫埝嘭舢鸢螯吡蝙疸匐桁铠羸鲈囵唛仫庖劭郓
骜粲峒腓鹳鳜蚶囫茴峤蟆蘖癯纾僳皙隰缬馐谪捭汊碜塍艮睑狍苫篦蜍锉沣
诰晗喙麂謇蹇觐啾踽邈壬燧娲猥歆镒茔昝赭狰孳哧舛噔鹗蚣逅洹腱锒纰蛆
蕤姝邰纣嘣钹衩婵孱蹿鲷萼椁浣镓遽赉趔蕲剜邂仡氤獐幛俾铋嗔茌氡诂豢
桧畿倥捋仞忒疃浯蜈榛偬稗菖鲳厝踮叼痱貉玑婕琚疴掳钤垧氵黠跹怏揄氲
铡濯芾笈崆钕菽隼傥仝囗芗埙簪暧桉镝蚪蜉藁笳菅龃喹橹抿啮蹑逖唔樨巽
揶黟訾钣嵯凼恫掇剁珙沆噱揆耒铌泅疝葳隗滟龉钺殒蒡觇黜澹酊垡奂珈濑
馕馊嚏痿岘氩茱滓焯抻豉敕掸碲靛摁淝鳏盥皈鲑颢犄翦铰椐胯屺邛庹猬蓊
骛浠桠胤鸩痣蛭噌杵啜靼啶煅枋觥毂刽蝈蘅芨戬醮疖忾骷洌呤荦觞谡瀣蝣
糌倬碚蹙痘砘绀虢蕻肓蛔唧桀蝌侩棂樯挈轫巳崧蓑藓鳕瑗帙馔豺痤郇殓髅
轳逯嗫戕嚅蛳琊嘤疣蚱钯钿碇咣毽迳喱逦廪邙囡匏扦亻咝凇纨涠庠溆醺炀
烊肄龈谀锱瘢枞皴贰晷闳斛屐讦婧苣蔻绺渌瑁螟叵颀穑膻羧螳绦誊蜥楦恂
靥咿翳瓒枳啭樽嫒婊搽铒跗凫菡篁髻裾栲癞蓼氖孬喏砒姘衽缛嵬挹缢慵呦
箸蹩槎榇舂嗲胴谔岢圹娌潋蛉酃鲵鲇娉亓碛芊忪谇笤韪勰呓俣圜愠仄炷毖
筚伧棰磴滏篙肱笕堇馑荩榘哐傀崃罱痨儡鹂檩垴仵檄芎阉刈壅馀庾妯躅獒
阊笞饬钏硐椴泔硌鹘鳇豇狙戡莨啉辇臬殇舐黍薮眭佻嗵煨莴蚴妤瘐擢蛏蹰
龊辏绐氘骶莪珐缟聒讧岬胛桷谰戾撸鸬雒嘧囔铍骈掊茕噻铯柁艉龌硖罅魇
酽咦嶷羿轸趵荸薜踟玳啖蔸槁鲛疥砬唳弭曩黏镊泮霈淠柒颧瘙痧辋郄燹泫
郾鹞钇殪痈甑踯翥婢檗柽啐菪嶝腭嗝剐笏蟥戢阄噘撅尻贶辚蜢颞忸胼阕竦
焐揠邺鳙啁稹徵诌隹舨哔卟伥苌鹚箪缍锇蝮诟洄浍诨犍硷噤垲郐椤嫫伲脲
殍噗溱箬厍钽钍恹鬻爰砦蓁胝颛褙鳊邴铖镫腚钭颚鲂悱狒佶偈堀绔醪坜疠
椋犸暝佞哝瞟荨芩逡溽裟挲抟暾崦芫荑薏莸欤栀斫镞嗳鸨跸骠俦谠簟棼驸
掼倨橛犒邋耧蝼虻铙郫汔诮楸阒绻叁臊钐腧闩菘阗忝橐翕阋踅窨鹬鼋樾錾
吒旃弁侪坼蚩嘬糍骢氐呃榧玢绋蚨钆岣菰罟嘏埚绗嚯藿笄袈羯肼暌啷蒗蜊
獠鬣熳黾乜镆怩驽旆髂仟芡谯恁鳃艄莳艏趿遢鲐醍僮氽刎芴喑墉昀箦鄣摺
钲贽缵鏊锛瓿廛瘳亍遄褡垌椟酆砩桴赙坩臌曷跽湫榉黧猁钌镏缦殁赧埤悭
缱衾鲭铩猞眚铈谥耜飕饕餮骰乇绾鹇鲞爻蜴镱铟莜祗濞镔逋谄谶酲茺樗憷
莼撺柢阏砜垓旰妫衮嗥郏鞯徼孓钪侉夼跬铼嫘蟊茆睨怄蹁谝嘌綮嫱筇犰穰
铷筲哂炻豕秫笥涑铊帏闱鋈舾屣狎哓噫璎铕宥阈豸辎趑龇捌秕荜愎窆镲谗
踔苁酢呔聃镦屙鲱鬲膈铪醐獾鲩虺葭牮礓苴讵颏裉诳栌氇镙哞柰袢帔睥苤
嫔笸氆佥箧跫蚋鲥扌狲桫溏铽殄脘洧肟绡咻洫癔洇嵛磔胗肫赀眦吖瑷埯畚
妣飑豳髌砗铳楮蔟毳锝堞疔葑缶菔疳彀胍磙顸薅翮猢怙蒺廑妗髁醌粝魉旒
蝥缗衲呸醅芘蚍圮榀萁苘逑诎劬蕖朊剡蟮椹饣酞帑葶菟魍庑葸氙谖鞅狺夤
嬴瘿饔雩鹆橼赜潴骓缁诹怍杓艹檫媸氚呲殂矬笪迨纛簦玎苊轭匚鼢呒缑诖
炅鲧唿戽鬟恚袷瘕枧洚桕雎蠲剀诓瘌镧铑鳓蓠呖跞裢裣埒捩鲮熘嵝瘰镘脒
腩筢耪辔牝嘁蛴戗蛩巯悫葚熵绱蛸螫毹妁纟嗾鳎绨粜菀沩鼯牾螅顼泶蕈鼹
繇苡悒廴吲喁卣牖笮舴罾棹鸷碡锕嗌媪龅甏箅傧啵鹁晡氅魑篪怛籴礅蒽珥
钫绠觚鸹涫颃篌锪蠖乩咭赍嵴铗湔槿赆僦皲佧箜蒉缧酹嘞疬臁膦泷蒌泺荬
颟旄泖镅蠓冖幂耱襻鼙攵炝愀蘧氍犭禳桡糁馓酾槊狻锬羰鼗鹈畋髫萜堍璺
怃崤囟睚痖菸餍徭瘗唷圉蜮砟谵澶朕摭轵诼笫廒聱庳髀笾龀裎雠蝽腠妲刂
铥黩怼沲蘩趺苻拊阝鲋戆纥哏鲠笱瞽庋簋刿掴猓蚵槲觳萑癀蟪钬虮掎鲣囝
裥踺茳糨鹪狷麇芤刳愦髡悃缡鲡鳢奁墚尥柃胪镥脔杩劢墁玟蝻呶搦湓罴蜱
俜鲆皤镨槭镪黢洳枘芟埏渖筮殳飧溻饧樘醣酡圬粞觋莶霰榍薤髹曛疋迓衤
欹佾埸霪茚鼬伛瘵骣畛卮轾彘觯锺邾槠谘嵫髭蕞犴鞴畀滗煸褊冫孛羼耖褫
彳艟辶茈璁爨榱萏坫鸫篼簖裰哚蹯瀵怫陔筻廾蛄绲崞蜾盍荭黉糇骺後鲎煳
鹕冱瓠逭漶耠镬齑殛鲚跏蛱搛缣鹣僬噍衿缂喾狯纩栝蛞稂塄嫠詈蠊鹩躐鹨
簏膂脶嬷昴瞀浼艨祢縻蘼芈糸宀眄鹋杪咩愍麽瘼鍪硇猱茑脬蟛貔仳犏钋芑
葜愆锓蠼筌鬈蚺荛埽潲诜埘弑嗍蒴鸶缌澌姒蔌睃缇梃彖鼍芄隈鲔硪忤痦欷
僖醯鼷跣枵忄擤勖痃碹谳轺铘圯纡窬窳饫蓣瀹趱驵缯揸笊絷跖舯螽籀舳粢
驺陬阼揞菝魃癍鹎坌狴萆嬖襞碥髟鳔醭螬馇虿瘥惝怊鸱螭瘛帱徂汆脞瘅忉
羝睇瓞鲽岽胨芏佴燔偾稃郛莩幞澉槔袼搿茛鞲觏酤牿鲴宄匦呙馘焓瘊虍岵
鹱咴隳缋溷夥剞洎恝蒹谫僭艽挢敫卺冂扃锔窭锩觖劂氪骒哙悝蝰诔苈篥娈
瞵锍栊癃舻辂稆猡蛑甍艋敉眇蠛侔镎肭艿蛲疒陧衄锘堋庀擗甓螵钷攴桤褰
凵肷锖鞒吣黥俅蝤璩悛辁肜颡谂礻摅汜溲嗉荽闼骀炱螗耥裼铫莛亠箨蕹迕
杌寤穸饩舄禊猃绁渫廨獬硎荇鸺貅糈揎镟獯讠厣罨蛘鳐崾舣媵尢蚰侑狳螈
龠昃痄搌浈埴夂黹酎橥丶缒窀菹锿砹茇勹邶鐾舭忭缏灬瘭踣钸礤骖黪艚锸
猹镡躔蒇冁鬯屮枨眵傺搋巛舡楱镩鹾戥觌阽铞垤揲蹀耵髑憝鸸鲕篚镄鲼唪
祓艴黻黼鳆尜戤塥哿虼遘桄丨胲醢撖嚆薨堠烀轷锾缳擐哕阍劐攉丌墼蕺彐
芰哜戋趼楗耩喈卩鲒骱刭弪獍鬏鞫犋屦醵桊爝捃胩锎蒈莰闶钶锞眍筘阃漤
铹栳耢仂泐檑轹蔹懔垆锊倮蠃鞔硭漭猸鹛钔瞢礞喵苠鳘貊貘毪坶攮猊嬲肀
聍甯狃耨孥胬恧蒎锫陴氕丿裒镤蜞岍搴箝慊椠蜣硗劁缲檎螓圊檠謦銎赇鼽
糗麴鸲磲畎狨蝾薷襦颥蓐脎毵磉鳋唼歃彡骟滠矧胂蓍鲺贳搠厶兕锼螋瞍觫
赕铴瑭慝掭祧龆蜩鲦茼酴煺柝腽軎阌阢诶菥蓰柙祆筅葙蟓魈躞砉醑儇岈砑
珧酏劓堙撄潆舁蝓燠眢箢掾刖狁拶唣迮帻谮哳齄膪嫜忮骘膣踬荮瘃麈疰丬
浞禚觜耔腙鄹鲰躜撙胙省啰瞭乂丏夬匜厾玕玙抔抃㧐芼旸吽牤沚沨纴玡玭
玠玥玦拤劼拃㧟茓茀杻旻昉呣䏝炘㤘祎祇垱挦剋柈𠳐眊峣郤饸饹疭竑闿羑
浕恓牁姮珰珣琤栟彧眬鸮䥽盉俵俶訚烜浥牂骎琇捯埵捽堉棻梿棁晞唵崚秾
鸻馃阇焗惇郿欸琫琯揳塆靰靸椪雱睄嗞嵖嵎铻媭鲀颎焜湜湲湉愔祾翚瑄蒟
楯跶跐嗐锜鹐亶瘆滫滃滪窣璈叆摽榖靺靿僰豨䁖嘡嘚箓魆粿熥嫚奭鋆瞋颙
踒𥻗熜潟褟璟璠璘縠嚄螠䦃镚镠膙獴赟澥窸璪鞡鞬罽鳀鞨鞧藠蹚鹮霨蹽蹾
齁㸆巉镴臜瓘镵齉卬𠙶毌邘圢伋冮氿汈氾讱扞圲圫芃朳朸𨙸邨屼屾辿伣伈
癿甪邠汋䜣讻孖玒玓玘玚刬坉扽坋扺㧑毐芣苉芠𫇭杕杙杄杧尪尨轪𫐄坒旴
旵㕮岠呇冏觃伾㑇伭佖佁飏汧汫𣲘𣲗沄沘汭㳇沇忳忺祃诇邲诐屃岊䢺妧妘
𨚕纮驲𫘜纻𫘝纼玤玞玱邽邿坥坰坬坽弆䢼𦭜茋苧苾枅㭎枍矼矻匼旿昇昄昒
昈咉咇咍岨岞峂㟃囷钖牥垈侁侹佸佺㑊侂佽侘郈舠郃攽肸狉狝饳忞炌炆泙
沺泂泜泃泇峃祋祊𫍣鸤弢弨陑陎乸妭姈叕䌹𫠊㛃玶珇珅珋玹珌玿韨垚垯垙
垍耇垎垟垞挓垵垏荖荁荙茽荄荓𦰡㭕柷柊枹栐柖郚剅䴓迺厖砆砄耏奓䶮昺
𪾢昽盷咡咺昳昣昤昫昡咥昪虷虸哃峘峏峛𪨰峗峧帡钘𫓧秬俫俙俍垕衎弇侴
鸧䏡胠𦙶胈胣朏飐訄饻庤疢炣炟㶲洭洘洓洿㳚泚浉洸洑洢洈洺洨浐㳘洴洣
恔宬扂袆祏祐祕叚陞娀姞姱姤姶姽枲绖骃𫄧骉珪珛珹玼珖𪟝珽珦珫珒珢珕
珝埗垾垺埆垿埌埇茝鄀莝䓖莙栻梠栴梴栒𫠆砵砠砫硁翃郪𨐈辀剕哢晅晊唝
哱冔晐畖蚄蚆𫑡崁峿𪨶崄帨崀甡倻倴脩倕倞倓倧衃虒舥鸰朓虓鱽峱𫗧勍竘
羖羓烠烔烶烻涍浡浭浬涄涢涐浰浟浛浲涘悈悢宧窅窊窎扅扆袪袗袯隺堲疍
𨺙烝砮㛚翀翂剟𫄨绤骍䂮琎珸珵琄琈琀珺堎堐埼埫堌晢掞埪壸㙍萚莿䓫勚
䓬菂菍菼萣䓨菉䓛梼梽桲梾桯梣梌桹敔硔硙硚硊硍勔䴕龁逴啫翈㫰晙畤跂
蛃蚲啴䎃崟崒崌崡铏𫓯𫟹𫟼铚牻笯偰偡偭偲偁㿠鄅偓徛衒舲鸼悆鄃瓻䝙脟
䏲鱾猇猄𠅤庱庼痓䴔竫堃羕焆烺焌淏淟淜淴淯湴涴㥄惛惔悰惙寁𫍯裈祲𫍲
谞弸弶隃婞娵婼媖婳婍婌婫婤婘婠𫘦绹𫟅骕𫘧絜珷琲琡琟琔琭堾堼揕㙘堧
喆堨塅𪣻𡎚惎萳靬葴鄚蓇萩蒐葰葎鄑葖蒄萹棤棽棫椓椑鹀椆棓棬棪椀甦酦
奡皕詟𫐐辌棐龂牚睎晫晪晱𧿹畯斝喤崶嵁嵅崿嵚翙𫖮圌圐赑赒𨱇𫓶犇颋稌
筀筜筥傃傉翛傒傕畬𫖯脿腘䐃腒鲃猰𫛭猯㺄馉凓鄗廋廆鄌遆旐焞欻𣸣溚溁
湝渰㴔渟溠渼溇湣湑溞愐愃敩棨扊祼婻媆媞㛹媓媂媄矞𫘨缊缐骙瑃瑓瑅瑆
䴖瑖瑝瑔瑀𤧛瑳瑂嶅瑑髢堽赪摛塝搒蒱蒨蓏蔀蓢蓂蒻楪榃榅楒楩椸楙歅碃
碏碈䃅硿鄠辒𫐓䣘暕鹍㬊暅跱蜐蜎嵲赗𫓹锳锧稑稙䅟筼筶筦筤僇艅谼貆腨
腯鲉鲊鲌䲟鲏雊猺飔觟𦝼馌裛鄘鹒鄜麀阘𫔶煁煃煴煋煟煓溍溹滆滉溦溵漷
滧滘滍愭慥慆塱𫌀禋禔禘禒鹔𫖳嫄媱勠戣𫘪𫘬缞耤瑧𫞩瑨瑱瑢斠摏墕墈墐
墘摴𡐓𪤗靽鞁蔈蔊榰榑槚𣗋槜疐酺碶䃎碨𥔲𫚖䴗鹖㬎幖嶍圙𨱏锽镃馝鹙箖
劄僔僎槃㙦𫚕鲖鲗鲘鲙𩽾夐飗凘廙鲝鄫熇漹漖潩漼漴㽏漈漋漻慬㮾褕禛隩
嫕嫭嫪㻬麹璆漦叇墣墦墡薁蕰蔃鼒槱鹝磏殣慭霅暵暲暶踦䗖蝘蝲噇噂噀罶
嶲嶓㠇嶟嶒镈镋镕皞皛䴘艎鹟𩾃鲪鲬觭鹠鹡鹢熛潖潵㵐澂澛瑬潽潾潏憭憕
戭褯禤𫍽嫽遹璥璲璒憙薳黇蕗薢橞橑橦觱磡𥕢磜豮𫟦𫠜虤暿曌曈㬚蹅踶䗛
疁㠓幪𪩘嶦𨱑馞穄篯簉衠盦螣縢鲯鲹𫗴亸羱糒燋熻燊燚燏濩濋澪澽澴澭澼
憺嬛翯𫄷璱𤩽璬璮髽擿薿薸櫆檞醨繄磹磻瞫蹐蟏㘎𫔍𨱔𫔎矰穙穜穟簕簃儦
魋斶谿䲠鲾鲿鳁鳂鳈鳉䗪襕襚螱嬬嬥𦈡𫄸瓀釐鬶爇鞳鞮藟藦藨鹲黡礌𥖨蹢
蹜蟫䗴嚚髃镮酂馧簠簝簰鼫鼩皦臑䲢鳑鳒鹯癗𦒍旞翷䎖瀔瀍瀌襜䴙嚭㰀鬷
蠋翾儳儴𩾌鳚鳛麑麖彟嬿鬒蘘欂甗𨟠巇酅髎犨𨭉㸌爔瀱瀼襫孅骦耰𤫉瓖鬘
趯罍鼱鳠鳡鳣爟爚灈韂糵礵鹴皭龢鳤亹籥𫚭玃醾齇觿" ""))
  "常用汉字")

(defun pyim-pymap-sort-cchar (a b)
  "对汉字 A 和 B 按照使用频率排序。"
  (< (or (cl-position a pyim-pymap-commonly-used-cchar :test #'equal) 1000000)
     (or (cl-position b pyim-pymap-commonly-used-cchar :test #'equal) 1000000)))

(defun pyim-pymap-sort-pymap ()
  "对 `pyim-pymap' 的取值进行排序, 用于维护 pyim-pymap."
  (let (pymap)
    (dolist (py pyim-pymap)
      (push (list (car py)
                  (mapconcat #'identity
                             (sort (split-string (cadr py) "")
                                   #'pyim-pymap-sort-cchar)
                             ""))
            pymap))
    (reverse pymap)))

;; * Footer
(provide 'pyim-pymap)

;;; pyim-pymap.el ends here
