/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.debug.MessageConsumer;

public class Serial
implements SerialPortEventListener {
    SerialPort port;
    int rate;
    int parity;
    int databits;
    int stopbits;
    boolean monitor = false;
    InputStream input;
    OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    MessageConsumer consumer;

    public Serial(boolean bl) throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
        this.monitor = bl;
    }

    public Serial() throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(int n) throws SerialException {
        this(Preferences.get("serial.port"), n, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String string, int n) throws SerialException {
        this(string, n, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String string) throws SerialException {
        this(string, Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String string, int n, char c, int n2, float f) throws SerialException {
        this.rate = n;
        this.parity = 0;
        if (c == 'E') {
            this.parity = 2;
        }
        if (c == 'O') {
            this.parity = 1;
        }
        this.databits = n2;
        this.stopbits = 1;
        if (f == 1.5f) {
            this.stopbits = 3;
        }
        if (f == 2.0f) {
            this.stopbits = 2;
        }
        try {
            this.port = null;
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals(string)) continue;
                this.port = (SerialPort)commPortIdentifier.open("serial madness", 2000);
                this.input = this.port.getInputStream();
                this.output = this.port.getOutputStream();
                this.port.setSerialPortParams(this.rate, this.databits, this.stopbits, this.parity);
                this.port.addEventListener((SerialPortEventListener)this);
                this.port.notifyOnDataAvailable(true);
            }
        }
        catch (PortInUseException portInUseException) {
            throw new SerialException("Serial port '" + string + "' already in use.  Try quiting any programs that may be using it.");
        }
        catch (Exception exception) {
            throw new SerialException("Error opening serial port '" + string + "'.", exception);
        }
        if (this.port == null) {
            throw new SerialException("Serial port '" + string + "' not found.  Did you select the right one from the Tools > Serial Port menu?");
        }
    }

    public void setup() {
    }

    public void dispose() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.port = null;
    }

    public void addListener(MessageConsumer messageConsumer) {
        this.consumer = messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.getEventType() != 1) return;
        try {
            while (this.input.available() > 0) {
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                if (this.bufferLast == this.buffer.length) {
                    byte[] byArray2 = new byte[this.bufferLast << 1];
                    System.arraycopy(this.buffer, 0, byArray2, 0, this.bufferLast);
                    this.buffer = byArray2;
                }
                if (this.monitor) {
                    System.out.print((char)this.input.read());
                }
                if (this.consumer != null) {
                    this.consumer.message("" + (char)this.input.read());
                }
                // MONITOREXIT : byArray
            }
            return;
        }
        catch (IOException iOException) {
            Serial.errorMessage("serialEvent", iOException);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte by = (byte)n;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            n2 = n3 - this.bufferIndex + 1;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n2);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte by = (byte)n;
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            n2 = n3 - this.bufferIndex + 1;
            if (n2 > byArray.length) {
                System.err.println("readBytesUntil() byte buffer is too small for the " + n2 + " bytes up to and including char " + n);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            Serial.errorMessage("write", exception);
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }

    public void setDTR(boolean bl) {
        this.port.setDTR(bl);
    }

    public void setRTS(boolean bl) {
        this.port.setRTS(bl);
    }

    public static String[] list() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = CommPortIdentifier.getPortIdentifiers();
            while (objectArray.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)objectArray.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                String string = commPortIdentifier.getName();
                vector.addElement(string);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Serial.errorMessage("ports", unsatisfiedLinkError);
        }
        catch (Exception exception) {
            Serial.errorMessage("ports", exception);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void errorMessage(String string, Throwable throwable) {
        System.err.println("Error inside Serial." + string + "()");
        throwable.printStackTrace();
    }
}

