/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.Window;
import java.security.AccessControlException;
import javax.swing.JDialog;

public class OSXSheetSupport {
    private static Boolean isNativeCodeAvailable;
    private static final int EXPECTED_NATIVE_CODE_VERSION = 0;

    private OSXSheetSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            Class clazz = OSXSheetSupport.class;
            synchronized (clazz) {
                if (isNativeCodeAvailable == null) {
                    boolean success = false;
                    try {
                        int nativeCodeVersion;
                        String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                        if (value == null) {
                            value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                        }
                        if (value != null && value.equals("true")) {
                            success = true;
                        } else {
                            String libraryName = QuaquaManager.getOS() >= 5 && QuaquaManager.getProperty("os.arch").equals("x86_64") ? "quaqua64" : "quaqua";
                            try {
                                System.loadLibrary(libraryName);
                                success = true;
                            }
                            catch (UnsatisfiedLinkError e) {
                                System.err.println("Warning: " + OSXSheetSupport.class + " couldn't load library \"" + libraryName + "\". " + e);
                                success = false;
                            }
                            catch (AccessControlException e) {
                                System.err.println("Warning: " + OSXSheetSupport.class + " access controller denied loading library \"" + libraryName + "\". " + e);
                                success = false;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                System.err.println("Warning: " + OSXSheetSupport.class + " couldn't load library \"" + libraryName + "\". " + e);
                                success = false;
                            }
                        }
                        if (success && (nativeCodeVersion = OSXSheetSupport.nativeGetNativeCodeVersion()) != 0) {
                            System.err.println("Warning: " + OSXSheetSupport.class + " can't use library libquaqua.jnilib. It has version " + nativeCodeVersion + " instead of " + 0);
                            success = false;
                        }
                    }
                    finally {
                        isNativeCodeAvailable = success;
                    }
                }
            }
        }
        return isNativeCodeAvailable == Boolean.TRUE;
    }

    private static native int nativeGetNativeCodeVersion();

    public static boolean showAsSheet(JDialog sheet) {
        Window owner = sheet.getOwner();
        if (OSXSheetSupport.isNativeCodeAvailable() && owner != null) {
            if (!sheet.isDisplayable()) {
                sheet.addNotify();
            }
            try {
                OSXSheetSupport.nativeShowSheet(sheet, owner);
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Warning: " + OSXSheetSupport.class + " could not show a sheet with the native method.");
                return false;
            }
            return true;
        }
        return false;
    }

    private static native void nativeShowSheet(JDialog var0, Window var1);

    public static void hideSheet(JDialog sheet) {
        if (OSXSheetSupport.isNativeCodeAvailable() && sheet.isVisible()) {
            OSXSheetSupport.nativeHideSheet(sheet);
        }
    }

    private static native void nativeHideSheet(JDialog var0);
}

