/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.ArduinoCodeNameEvent;
import com.sandklef.jearduino.Board;
import com.sandklef.jearduino.BoardEvent;
import com.sandklef.jearduino.ExecControl;
import com.sandklef.jearduino.ExecEvent;
import com.sandklef.jearduino.FileEvent;
import com.sandklef.jearduino.InfoPanel;
import com.sandklef.jearduino.JearduinoMenu;
import com.sandklef.jearduino.JearduinoPreferences;
import com.sandklef.jearduino.LCD;
import com.sandklef.jearduino.Logger;
import com.sandklef.jearduino.PinEvent;
import com.sandklef.jearduino.PinTable;
import com.sandklef.searduino.Searduino;
import com.sandklef.searduino.SearduinoObserver;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Jearduino
extends JFrame
implements SearduinoObserver,
ExecEvent,
PinEvent,
BoardEvent,
FileEvent,
ArduinoCodeNameEvent {
    Searduino searduino;
    JearduinoPreferences jpref = new JearduinoPreferences();
    JearduinoMenu jmenu;
    GridBagConstraints c;
    PinTable pins;
    Logger serial;
    Logger logger;
    LCD lcd;
    InfoPanel infoPanel;
    Container pane = this.getContentPane();
    private int codeNamesToStore = 10;
    private int nrpins = 0;
    public String version;
    JPanel topPanel;
    JPanel controlPanel;
    JPanel pinPanel;
    JPanel logPanel;
    ExecControl ec;
    Board board;
    static int appSizeHeight = 700;
    static int appSizeWidth = 800;
    static int infoSizeHeight = 20;
    static int infoSizeWidth = 800;

    public Jearduino() {
        this.pane.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.setSize(appSizeHeight, appSizeWidth);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 3));
        this.pinPanel = new JPanel();
        this.logPanel = new JPanel();
        this.pinPanel.setVisible(true);
        this.pinPanel.setLayout(new GridLayout());
        this.logPanel.setLayout(new BoxLayout(this.logPanel, 3));
        this.ec = new ExecControl(this);
        this.controlPanel.add(this.ec);
        this.jmenu = new JearduinoMenu(this, this, this);
        this.setJMenuBar(this.jmenu);
        this.board = new Board(this);
        this.searduino = new Searduino();
        this.infoPanel = new InfoPanel();
        this.logger = new Logger("Log");
        this.serial = new Logger("Serial");
        this.lcd = new LCD("LCD");
        this.serial.setMaximumSize(new Dimension(200, 400));
        this.logger.setMaximumSize(new Dimension(200, 400));
        this.lcd.setMaximumSize(new Dimension(200, 400));
        this.serial.setPreferredSize(new Dimension(200, 100));
        this.logger.setPreferredSize(new Dimension(200, 100));
        this.lcd.setPreferredSize(new Dimension(200, 100));
        this.logPanel.add(this.serial);
        this.logPanel.add(this.lcd);
        this.logPanel.add(this.logger);
        this.pins = new PinTable(this, this.searduino);
        this.pins.setVisible(true);
        this.pinPanel.add(this.pins);
        this.setTitle("Jearduino - Searduino's Java frontend for Arduino simulation");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.searduino.setWriteTimelimit(0);
        this.searduino.disableStreamedOutput();
        this.searduino.registerPinModeCallback((SearduinoObserver)this);
        this.searduino.registerPinOutCallback((SearduinoObserver)this);
        this.searduino.registerPinTypeCallback((SearduinoObserver)this);
        this.searduino.registerLogCallback((SearduinoObserver)this);
        this.searduino.registerLCDCallback((SearduinoObserver)this);
        this.infoPanel.setArduinoCodeName(this.searduino.getArduinoCodeName());
        this.infoPanel.setSearduinoVersion(this.searduino.getSearduinoVersion());
        this.setupSizes();
    }

    public void setupSizes() {
        this.infoPanel.setMinimumSize(new Dimension(400, 50));
        this.infoPanel.setMaximumSize(new Dimension(400, 50));
        this.pinPanel.setMaximumSize(new Dimension(400, 600));
        this.pinPanel.setMinimumSize(new Dimension(400, 600));
        this.controlPanel.setMaximumSize(new Dimension(400, 80));
        this.controlPanel.setMinimumSize(new Dimension(400, 80));
        this.logger.setMaximumSize(new Dimension(300, 300));
        this.logger.setMinimumSize(new Dimension(300, 300));
        this.serial.setMaximumSize(new Dimension(300, 300));
        this.serial.setMinimumSize(new Dimension(300, 300));
        int n = 0;
        this.c.fill = 2;
        this.c.ipady = n;
        this.c.ipadx = 1;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.pane.add((Component)this.pinPanel, this.c);
        this.c.fill = 2;
        this.c.ipady = n;
        this.c.ipadx = 0;
        this.c.weightx = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.pane.add((Component)this.logPanel, this.c);
        this.c.fill = 2;
        this.c.ipady = n;
        this.c.ipadx = 0;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        this.pane.add((Component)this.controlPanel, this.c);
        this.c.fill = 2;
        this.c.ipady = 0;
        this.c.weightx = 0.0;
        this.c.gridwidth = 1;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        this.pane.add((Component)this.infoPanel, this.c);
    }

    private void setupBoard(String string) {
        String string2 = this.searduino.getSearduinoVersion();
        this.searduino.setBoardName(string);
        this.jpref.setBoard(string);
        this.infoPanel.setBoardName(string);
        this.nrpins = this.searduino.getNrOfPins();
        this.version = this.searduino.getSearduinoVersion();
        this.pins.setupPins();
    }

    public void handlePinTypeEvent(int n, int n2) {
        System.out.println("EVENT: PIN TYPE-------------> JAVA (really) pin[" + n + "]: type=" + n2);
        this.pins.setTypeInputPin(n, n2, true);
    }

    public void handleLogEvent(int n, String string) {
        this.serial.addLog(string);
    }

    public void handleLCDEvent(String string, String string2) {
        this.lcd.setText(string, string2);
    }

    @Override
    public void handleBoardChoiceEvent(String string) {
        this.setupBoard(string);
    }

    public void handlePinModeEvent(int n, int n2) {
        if (n == 0) {
            return;
        }
        this.logger.addLog("EVENT: PIN MODE JAVA (really) pin[" + n + "]: mode=" + n2 + "\n");
        this.pins.setMode(n, n2);
    }

    public void handlePinOutEvent(int n, int n2, int n3) {
        this.pins.setPinValue(n, n2, n3);
    }

    @Override
    public void inputValueEvent(int n, int n2) {
        this.searduino.setInputPinValue(n, n2, this.pins.getInputPinTypeLocal(n));
    }

    @Override
    public void ExecEvent(int n) {
        if (n == 2) {
            this.logger.addLog("PAUSE");
            this.searduino.pauseArduinoCode();
        } else if (n == 3) {
            this.logger.addLog("RESUME");
            this.searduino.resumeArduinoCode();
        } else if (n == 4) {
            this.logger.addLog("HALT");
            this.searduino.haltArduinoCode();
            this.logger.addLog("HALTED");
        } else if (n == 1) {
            this.logger.addLog("START");
            this.searduino.startArduinoCode();
        }
    }

    public void getAndUseArduinoCodeName(String string) {
        String string2 = string == null ? this.jpref.getArduinoCodeName(1) : string;
        int n = this.searduino.setArduinoCodeName(string2);
        if (n != 0) {
            return;
        }
        this.infoPanel.setArduinoCodeName(string2);
        File file = new File(string2);
        if (file == null) {
            return;
        }
        this.handleArduinoFileEvent(file);
    }

    public void showArduinoCodeNameMenu() {
        this.jmenu.removeCodeItems();
        for (int i = 0; i < this.codeNamesToStore; ++i) {
            this.jmenu.updateCodeItem(i, this.jpref.getArduinoCodeName(i));
        }
    }

    public void saveArduinoCodeName(String string, String string2) {
        int n;
        int n2 = this.searduino.setArduinoCodeName(string);
        if (n2 != 0) {
            return;
        }
        for (n = this.codeNamesToStore - 1; n > -1; --n) {
        }
        for (n = this.codeNamesToStore - 1; n > -1; --n) {
            this.jpref.setArduinoCodeName(n + 1, this.jpref.getArduinoCodeName(n));
        }
        this.jpref.setArduinoCodeName(0, string);
        this.infoPanel.setArduinoCodeName(string2);
        this.searduino.setArduinoCodeName(string);
        this.showArduinoCodeNameMenu();
    }

    @Override
    public void handleArduinoFileEvent(File file) {
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            System.out.println("Uh oh... could not get file name");
        }
        int n = 0;
        try {
            n = this.searduino.setArduinoCodeName(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("EXCEPTION!  - FAILED SETTING arduino code -------------> BOARD: " + string);
            this.infoPanel.setArduinoCodeName("");
            return;
        }
        this.saveArduinoCodeName(string, file.getName());
        this.ec.setStartable();
    }

    @Override
    public void handleArduinoCodeNameEvent(int n) {
        this.infoPanel.setArduinoCodeName(this.jpref.getArduinoCodeName(n));
        this.searduino.setArduinoCodeName(this.jpref.getArduinoCodeName(n));
        this.ec.setStartable();
    }

    public static void main(String[] stringArray) {
        final Jearduino jearduino = new Jearduino();
        boolean bl = false;
        int n = stringArray.length;
        String string = null;
        String string2 = null;
        System.out.println("ARGS: " + n);
        for (int i = 0; i < n; ++i) {
            System.out.println("Parse... " + stringArray[i] + "\n");
            if (stringArray[i].equals("--board")) {
                System.out.println("found\n");
                if (i + 1 < n) {
                    System.out.println("BOARD: " + stringArray[i + 1]);
                    string = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.out.println("Missing args to --board");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--arduino-code")) {
                System.out.println("found\n");
                if (i + 1 < n) {
                    System.out.println("CODE: " + stringArray[i + 1]);
                    string2 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.out.println("Missing args to --arduino-code");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--start")) {
                bl = true;
                continue;
            }
            System.out.println("Error when pasing command line '" + stringArray[i] + "'");
            System.exit(1);
        }
        if (string == null) {
            jearduino.setupBoard(jearduino.jpref.getBoard());
        } else {
            jearduino.setupBoard(string);
        }
        jearduino.getAndUseArduinoCodeName(string2);
        jearduino.showArduinoCodeNameMenu();
        System.out.println("Searduino version: " + jearduino.version);
        System.out.println("Searduino board:   " + jearduino.searduino.getBoardName());
        if (bl) {
            jearduino.ec.sendStart();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jearduino.setVisible(true);
            }
        });
    }
}

