/*
 * MicroEngine - A microkernel inspired game engine
 * Copyright (C) 2008 "Slinger" ("Sould Slinger" @ gorcx.net/forum),
 * _unless where otherwise stated_
 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

#include "plugin.h"

//each command needs one function for processing and one for preprocessing
//args is everything after the command name (including the blank)
//data is a pointer which will be given to the real function on running

int print_test_preproc (char **data, char *args)
{
	if (args[0]!='\0')
	{
		*data = calloc (strlen (args) +1, sizeof(char));
		strcpy(*data, args +1);	//get rid of the initial ' '
					//and store the result in "data"
	}
	else//no arguments...
	{
		*data = calloc (15, sizeof(char));
		strcpy(*data, "<no arguments>");
	}

	return 0;
}
void print_test (char * data)	//the same 'data' as in prepros
				//will write inside of data 'til '\0'
{
	printf("* print_test saying: %s\n", data);
}

int print_test_number_preproc (char ** data, char * args)
{
	if (args[0]!='\0')
	{
		*data = calloc (1, sizeof (int));
		int *tmp = (int *) data;
		sscanf (args, " %i", tmp);
	}
	else
	{
		*data = 0;
	}
	return 0;
}
void print_test_number (char * data)
{
	printf("* print_test_number: %i\n", data);
}

