/*
 * MicroEngine - A microkernel inspired game engine
 * Copyright (C) 2008 "Slinger" ("Sould Slinger" @ gorcx.net/forum),
 * _unless where otherwise stated_
 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/*
 * Functions for loading plugins (shared objects)
 */

#define plugin_suffix ".plugin"
#define max_lenght 20 //max filename lenght
#define max_plugins 10

static struct{
	void * handle;
	/*space for more stuff*/
} plugin[max_plugins];
static int plugin_counter;

void * plugin_command_lookup (char*name)
{
	int i;
	void * function;
	for (i=0; i<plugin_counter; i++)
	{
		if (function = SDL_LoadFunction(plugin[i].handle, name))
			break;
	}
	return function; //will be NULL if not found
}

void unload_plugins(void)
{
	printf("> Unloading plugins... ");
	int i;
	for (i=0; i<plugin_counter; i++)
	{
		SDL_UnloadObject(plugin[i].handle);
	}
	printf("Done!\n\n");
}

int load_plugins(char * PATH)
{
	printf("> Loading plugin dir: %s\n", PATH); 

	DIR *plugin_dir = opendir (PATH);
	if (!plugin_dir)
	{
		printf("> Couldn't open directory\n");
		return -1;
	}

	//directory exists!
	plugin_counter = 0;
	struct dirent *plugin_file;
	while (plugin_file = readdir (plugin_dir))
	{
		char * tmp_str = plugin_file->d_name; //pointer to filename
		char * tmp_suffix = rindex (tmp_str, '.'); //filename suffix
		//_complete_ path to file, not just filename
		char * tmp_path = calloc(sizeof(char),strlen(PATH)+max_lenght);

		if (tmp_suffix) //file got suffix
		{
			if (strcmp (tmp_suffix, plugin_suffix) == 0) //correct
			{
				//build path
				strcpy(tmp_path, PATH);
				strcat(tmp_path, "/");
				strcat(tmp_path, tmp_str);

				printf("  > %s: ", tmp_str);

				if(plugin[plugin_counter].handle =
					       	SDL_LoadObject(tmp_path))
				{
					printf("SUCCESS!\n");
					plugin_counter++;
				}
				else
				{
					printf("fail...\n    %s\n",
						       	SDL_GetError());
					return -1;
				}
			}
		}
	}
	
	if (plugin_counter==0)
		printf("> Meh, no plugins?!\n");
	else
		printf("> Done!\n\n");
	return 0;
}

