/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Tray
extends Widget {
    int itemCount;
    TrayItem[] items = new TrayItem[4];

    Tray(Display display, int style) {
        this.display = display;
        this.reskinWidget();
    }

    void createItem(TrayItem item2, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            TrayItem[] newItems = new TrayItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item2;
    }

    void destroyItem(TrayItem item2) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    public TrayItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TrayItem[] getItems() {
        this.checkWidget();
        TrayItem[] result2 = new TrayItem[this.itemCount];
        System.arraycopy(this.items, 0, result2, 0, result2.length);
        return result2;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                TrayItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.display.tray == this) {
            this.display.tray = null;
        }
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i2 = 0;
            while (i2 < this.items.length) {
                TrayItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }
}

