/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebPolicyDecisionListener;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.MessageBox;

class WebPolicyDelegate {
    COMObject iWebPolicyDelegate;
    int refCount = 0;
    Browser browser;

    WebPolicyDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 5;
        nArray[4] = 5;
        nArray[5] = 5;
        nArray[6] = 3;
        this.iWebPolicyDelegate = new COMObject(nArray){

            @Override
            public long method0(long[] args2) {
                return WebPolicyDelegate.this.QueryInterface(args2[0], args2[1]);
            }

            @Override
            public long method1(long[] args2) {
                return WebPolicyDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args2) {
                return WebPolicyDelegate.this.Release();
            }

            @Override
            public long method3(long[] args2) {
                return WebPolicyDelegate.this.decidePolicyForNavigationAction(args2[0], args2[1], args2[2], args2[3], args2[4]);
            }

            @Override
            public long method4(long[] args2) {
                return WebPolicyDelegate.this.decidePolicyForNewWindowAction(args2[0], args2[1], args2[2], args2[3], args2[4]);
            }

            @Override
            public long method5(long[] args2) {
                return WebPolicyDelegate.this.decidePolicyForMIMEType(args2[0], args2[1], args2[2], args2[3], args2[4]);
            }

            @Override
            public long method6(long[] args2) {
                return WebPolicyDelegate.this.unableToImplementPolicyWithError(args2[0], args2[1], args2[2]);
            }
        };
    }

    int decidePolicyForMIMEType(long webView, long type2, long request, long frame, long listener2) {
        IWebView iwebView = new IWebView(webView);
        int[] canShow = new int[1];
        iwebView.canShowMIMEType(type2, canShow);
        IWebPolicyDecisionListener pdListener = new IWebPolicyDecisionListener(listener2);
        if (canShow[0] != 0) {
            pdListener.use();
        } else {
            pdListener.download();
        }
        return 0;
    }

    int decidePolicyForNavigationAction(long webView, long actionInformation, long request, long frame, long listener2) {
        IWebURLRequest iwebUrlRequest = new IWebURLRequest(request);
        long[] result2 = new long[1];
        int hr = iwebUrlRequest.URL(result2);
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        String url = WebKit.extractBSTR(result2[0]);
        COM.SysFreeString(result2[0]);
        IWebPolicyDecisionListener pdListener = new IWebPolicyDecisionListener(listener2);
        WebKit webKit = (WebKit)this.browser.webBrowser;
        if (webKit.loadingText) {
            pdListener.use();
            return 0;
        }
        if (url.length() == 0) {
            pdListener.ignore();
            return 0;
        }
        if (url.startsWith("file://") && webKit.getUrl().startsWith("about:blank") && webKit.untrustedText) {
            pdListener.ignore();
            return 0;
        }
        if (url.equals("file:///")) {
            url = "about:blank";
        } else {
            int length = "file:///".length();
            if (url.startsWith("file:///") && url.charAt(length) == '#') {
                url = "about:blank" + url.substring(length);
            }
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url;
        newEvent.doit = true;
        LocationListener[] locationListeners = webKit.locationListeners;
        if (locationListeners != null) {
            int i2 = 0;
            while (i2 < locationListeners.length) {
                locationListeners[i2].changing(newEvent);
                ++i2;
            }
        }
        if (newEvent.doit) {
            if (webKit.jsEnabled != webKit.jsEnabledOnNextPage) {
                webKit.jsEnabled = webKit.jsEnabledOnNextPage;
                IWebView view = new IWebView(webView);
                result2[0] = 0L;
                hr = view.preferences(result2);
                if (hr == 0 && result2[0] != 0L) {
                    IWebPreferences preferences = new IWebPreferences(result2[0]);
                    hr = preferences.setJavaScriptEnabled(webKit.jsEnabled ? 1 : 0);
                    view.setPreferences(preferences.getAddress());
                    preferences.Release();
                }
            }
            pdListener.use();
            webKit.lastNavigateURL = url;
        } else {
            pdListener.ignore();
        }
        return 0;
    }

    int decidePolicyForNewWindowAction(long webView, long actionInformation, long request, long frameName, long listener2) {
        IWebPolicyDecisionListener pdListener = new IWebPolicyDecisionListener(listener2);
        pdListener.use();
        return 0;
    }

    protected void disposeCOMInterfaces() {
        if (this.iWebPolicyDelegate != null) {
            this.iWebPolicyDelegate.dispose();
            this.iWebPolicyDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebPolicyDelegate.getAddress();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebPolicyDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebPolicyDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebPolicyDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebPolicyDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int unableToImplementPolicyWithError(long webView, long error2, long frame) {
        if (this.browser.isDisposed()) {
            return 0;
        }
        IWebError iweberror = new IWebError(error2);
        String failingURL = null;
        long[] result2 = new long[1];
        int hr = iweberror.failingURL(result2);
        if (hr == 0 && result2[0] != 0L) {
            failingURL = WebKit.extractBSTR(result2[0]);
            COM.SysFreeString(result2[0]);
        }
        result2[0] = 0L;
        hr = iweberror.localizedDescription(result2);
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        String description2 = WebKit.extractBSTR(result2[0]);
        COM.SysFreeString(result2[0]);
        String message2 = failingURL != null ? String.valueOf(failingURL) + "\n\n" : "";
        message2 = String.valueOf(message2) + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{description2});
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
        messageBox.setMessage(message2);
        messageBox.open();
        return 0;
    }
}

