/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.xhtmlrenderer.util.XRLog;

public class GeneralUtil {
    public static final DecimalFormat PADDED_HASH_FORMAT = new DecimalFormat("0000000000");

    public static InputStream openStreamFromClasspath(Object obj, String resource) {
        InputStream readStream = null;
        try {
            URL stream;
            ClassLoader loader2 = obj.getClass().getClassLoader();
            readStream = loader2 == null ? ClassLoader.getSystemResourceAsStream(resource) : loader2.getResourceAsStream(resource);
            if (readStream == null && (stream = resource.getClass().getResource(resource)) != null) {
                readStream = stream.openStream();
            }
        }
        catch (Exception ex) {
            XRLog.exception("Could not open stream from CLASSPATH: " + resource, ex);
        }
        return readStream;
    }

    public static URL getURLFromClasspath(Object obj, String resource) {
        URL url = null;
        try {
            ClassLoader loader2 = obj.getClass().getClassLoader();
            url = loader2 == null ? ClassLoader.getSystemResource(resource) : loader2.getResource(resource);
            if (url == null) {
                url = resource.getClass().getResource(resource);
            }
        }
        catch (Exception ex) {
            XRLog.exception("Could not get URL from CLASSPATH: " + resource, ex);
        }
        return url;
    }

    public static void dumpShortException(Exception ex) {
        String s2 = ex.getMessage();
        if (s2 == null || s2.trim().equals("null")) {
            s2 = "{no ex. message}";
        }
        System.out.println(s2 + ", " + ex.getClass());
        StackTraceElement[] stes = ex.getStackTrace();
        for (int i2 = 0; i2 < stes.length && i2 < 5; ++i2) {
            StackTraceElement ste = stes[i2];
            System.out.println("  " + ste.getClassName() + "." + ste.getMethodName() + "(ln " + ste.getLineNumber() + ")");
        }
    }

    public static String trackBack(int cnt) {
        Exception ex = new Exception();
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list2 = new ArrayList<String>(cnt);
        StackTraceElement[] stes = ex.getStackTrace();
        if (cnt >= stes.length) {
            cnt = stes.length - 1;
        }
        for (int i2 = cnt; i2 >= 1; --i2) {
            StackTraceElement ste = stes[i2];
            sb.append(GeneralUtil.classNameOnly(ste.getClassName()));
            sb.append(".");
            sb.append(ste.getMethodName());
            sb.append("(ln ").append(ste.getLineNumber()).append(")");
            list2.add(sb.toString());
            sb = new StringBuffer();
        }
        Iterator iter = list2.iterator();
        StringBuffer padding = new StringBuffer("");
        StringBuffer trackback = new StringBuffer();
        while (iter.hasNext()) {
            String s2 = (String)iter.next();
            trackback.append(padding).append(s2).append("\n");
            padding.append("   ");
        }
        return trackback.toString();
    }

    public static String classNameOnly(Object o2) {
        String s2 = "[null object ref]";
        if (o2 != null) {
            s2 = GeneralUtil.classNameOnly(o2.getClass().getName());
        }
        return s2;
    }

    public static String classNameOnly(String cname) {
        String s2 = "[null object ref]";
        if (cname != null) {
            s2 = cname.substring(cname.lastIndexOf(46) + 1);
        }
        return s2;
    }

    public static String paddedHashCode(Object o2) {
        String s2 = "0000000000";
        if (o2 != null) {
            s2 = PADDED_HASH_FORMAT.format(o2.hashCode());
        }
        return s2;
    }

    public static boolean isMacOSX() {
        try {
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                return true;
            }
        }
        catch (SecurityException e2) {
            System.err.println(e2.getLocalizedMessage());
        }
        return false;
    }

    public static StringBuffer htmlEscapeSpace(String uri) {
        StringBuffer sbURI = new StringBuffer((int)((double)uri.length() * 1.5));
        for (int i2 = 0; i2 < uri.length(); ++i2) {
            char ch = uri.charAt(i2);
            if (ch == ' ') {
                sbURI.append("%20");
                continue;
            }
            if (ch == '\\') {
                sbURI.append('/');
                continue;
            }
            sbURI.append(ch);
        }
        return sbURI;
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        int n2;
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringWriter sw = new StringWriter();
        char[] c2 = new char[1024];
        while ((n2 = br.read(c2, 0, c2.length)) >= 0) {
            sw.write(c2, 0, n2);
        }
        isr.close();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String content, String encoding, String fileName) throws IOException {
        File f2 = new File(fileName);
        FileOutputStream fos = new FileOutputStream(f2);
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            PrintWriter pw = new PrintWriter(bw);
            try {
                pw.print(content);
                pw.flush();
                bw.flush();
            }
            finally {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e2) {
            throw e2;
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
        System.out.println("Wrote file: " + f2.getAbsolutePath());
    }

    public static int parseIntRelaxed(String s2) {
        if (s2 == null || s2.length() == 0 || s2.trim().length() == 0) {
            return 0;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (Character.isDigit(c2)) {
                buffer.append(c2);
                continue;
            }
            if (buffer.length() > 0) break;
        }
        if (buffer.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException exception) {
            return Integer.MAX_VALUE;
        }
    }

    public static String escapeHTML(String s2) {
        if (s2 == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int n2 = s2.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block7;
                }
                default: {
                    sb.append(c2);
                }
            }
        }
        return sb.toString();
    }
}

