/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DesktopPropertyTypes;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.CellVoltageValuesDialog;
import gde.ui.menu.TabAreaContextMenu;
import gde.ui.tab.CellVoltageDisplay;
import gde.utils.CellVoltageValues;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class CellVoltageWindow
extends CTabItem {
    static final String $CLASS_NAME = CellVoltageWindow.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    Composite cellVoltageMainComposite;
    Composite coverComposite;
    Group voltageLimitsSelection;
    Composite digitalComposite;
    CLabel capacityUnit;
    CLabel capacitiyValue;
    CLabel voltageUnit;
    CLabel voltageValue;
    Button liPoButton;
    Button liIoButton;
    Button liFeButton;
    Button niMhButton;
    Button individualButton;
    final DataExplorer application;
    final Channels channels;
    final CTabFolder displayTab;
    final CellVoltageValuesDialog lithiumValuesDialog;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;
    RecordSet oldRecordSet = null;
    Channel oldChannel = null;
    Color surroundingBackground;
    Color textColor;
    String info = Messages.getString("GDE_MSGT0230");
    Vector<CellVoltageDisplay> displays = new Vector();
    int voltageAvg = 0;
    int[] voltageLimits = CellVoltageValues.getVoltageLimits();
    Vector<CellInfo> voltageVector = new Vector();
    int voltageDelta = 0;
    Point displayCompositeSize = new Point(0, 0);
    int firstMeasurement = 0;
    int secondMeasurement = 2;

    public CellVoltageWindow(CTabFolder currentDisplayTab, int style, int position) {
        super(currentDisplayTab, style, position);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.displayTab = currentDisplayTab;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0232"));
        this.lithiumValuesDialog = new CellVoltageValuesDialog(this.application, 34912);
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.surroundingBackground = Settings.getInstance().getCellVoltageSurroundingAreaBackground();
        this.textColor = Settings.getInstance().getHeaderCommentColor();
    }

    public void create() {
        String $METHOD_NAME = "create";
        this.cellVoltageMainComposite = new Composite((Composite)this.displayTab, 0);
        this.setControl((Control)this.cellVoltageMainComposite);
        this.cellVoltageMainComposite.setMenu(this.popupmenu);
        this.cellVoltageMainComposite.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINEST, "cellVoltageMainComposite.helpRequested " + String.valueOf(evt));
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_9.html");
            }
        });
        this.cellVoltageMainComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "cellVoltageMainComposite.paintControl, event=" + String.valueOf(evt));
                CellVoltageWindow.this.contextMenu.createMenu(CellVoltageWindow.this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
                CellVoltageWindow.this.updateAndResize();
            }
        });
        this.voltageLimitsSelection = new Group(this.cellVoltageMainComposite, 0);
        if (!GDE.IS_MAC) {
            this.voltageLimitsSelection.setBackground(this.surroundingBackground);
        }
        this.voltageLimitsSelection.setText(Messages.getString("GDE_MSGT0369"));
        this.voltageLimitsSelection.setToolTipText(Messages.getString("GDE_MSGT0370"));
        RowLayout thisLayout = new RowLayout(256);
        this.voltageLimitsSelection.setLayout((Layout)thisLayout);
        this.voltageLimitsSelection.setBounds(0, 0, 420, GDE.IS_WINDOWS ? 40 : 45);
        this.voltageLimitsSelection.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINEST, "voltageLimitsSelection.helpRequested " + String.valueOf(evt));
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_9.html");
            }
        });
        this.voltageLimitsSelection.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                String $METHOD_NAME1 = "paintControl";
                log.logp(Level.FINEST, $CLASS_NAME, "paintControl", "voltageLimitsSelection.paintControl, event=" + String.valueOf(evt));
                log.logp(Level.FINER, $CLASS_NAME, "paintControl", "" + CellVoltageValues.compareVoltageLimits(CellVoltageValues.liPoLimits));
                CellVoltageWindow.this.liPoButton.setSelection(CellVoltageValues.compareVoltageLimits(CellVoltageValues.liPoLimits));
                log.logp(Level.FINER, $CLASS_NAME, "paintControl", "" + CellVoltageValues.compareVoltageLimits(CellVoltageValues.liIoLimits));
                CellVoltageWindow.this.liIoButton.setSelection(CellVoltageValues.compareVoltageLimits(CellVoltageValues.liIoLimits));
                log.logp(Level.FINER, $CLASS_NAME, "paintControl", "" + CellVoltageValues.compareVoltageLimits(CellVoltageValues.liFeLimits));
                CellVoltageWindow.this.liFeButton.setSelection(CellVoltageValues.compareVoltageLimits(CellVoltageValues.liFeLimits));
                log.logp(Level.FINER, $CLASS_NAME, "paintControl", "" + CellVoltageValues.compareVoltageLimits(CellVoltageValues.niMhLimits));
                CellVoltageWindow.this.niMhButton.setSelection(CellVoltageValues.compareVoltageLimits(CellVoltageValues.niMhLimits));
                log.logp(Level.FINER, $CLASS_NAME, "paintControl", "" + (!CellVoltageWindow.this.liPoButton.getSelection() && !CellVoltageWindow.this.liIoButton.getSelection() && !CellVoltageWindow.this.liFeButton.getSelection()));
                CellVoltageWindow.this.individualButton.setSelection(!CellVoltageWindow.this.liPoButton.getSelection() && !CellVoltageWindow.this.liIoButton.getSelection() && !CellVoltageWindow.this.liFeButton.getSelection() && !CellVoltageWindow.this.niMhButton.getSelection());
            }
        });
        RowData liPoButtonLData = new RowData();
        liPoButtonLData.width = 70;
        liPoButtonLData.height = 18;
        this.liPoButton = new Button((Composite)this.voltageLimitsSelection, 0x1000020);
        this.liPoButton.setLayoutData((Object)liPoButtonLData);
        if (!GDE.IS_MAC) {
            this.liPoButton.setBackground(this.surroundingBackground);
        }
        this.liPoButton.setForeground(this.textColor);
        this.liPoButton.setText(Messages.getString("GDE_MSGT0371"));
        this.liPoButton.setToolTipText(Messages.getString("GDE_MSGT0370"));
        this.liPoButton.setSelection(false);
        this.liPoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet recordSet;
                log.logp(Level.FINEST, $CLASS_NAME, "create", "buttonLiPo.widgetSelected, event=" + String.valueOf(evt));
                CellVoltageWindow.this.liPoButton.setSelection(true);
                CellVoltageWindow.this.liIoButton.setSelection(false);
                CellVoltageWindow.this.liFeButton.setSelection(false);
                CellVoltageWindow.this.niMhButton.setSelection(false);
                CellVoltageWindow.this.individualButton.setSelection(false);
                CellVoltageValues.setVoltageLimits(CellVoltageValues.getVoltageLimits(CellVoltageValues.CellVoltageTypes.LiPo));
                Channel activeChannel = CellVoltageWindow.this.channels.getActiveChannel();
                RecordSet recordSet2 = recordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
                if (recordSet != null) {
                    recordSet.setVoltageLimits();
                }
                CellVoltageWindow.this.update(true, true);
            }
        });
        RowData button1LData = new RowData();
        button1LData.width = 70;
        button1LData.height = 18;
        this.liIoButton = new Button((Composite)this.voltageLimitsSelection, 0x1000020);
        this.liIoButton.setLayoutData((Object)button1LData);
        if (!GDE.IS_MAC) {
            this.liIoButton.setBackground(this.surroundingBackground);
        }
        this.liIoButton.setForeground(this.textColor);
        this.liIoButton.setText(Messages.getString("GDE_MSGT0372"));
        this.liIoButton.setToolTipText(Messages.getString("GDE_MSGT0370"));
        this.liIoButton.setSelection(false);
        this.liIoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet recordSet;
                log.logp(Level.FINEST, $CLASS_NAME, "create", "buttonLiPo.widgetSelected, event=" + String.valueOf(evt));
                CellVoltageWindow.this.liIoButton.setSelection(true);
                CellVoltageWindow.this.liPoButton.setSelection(false);
                CellVoltageWindow.this.liFeButton.setSelection(false);
                CellVoltageWindow.this.niMhButton.setSelection(false);
                CellVoltageWindow.this.individualButton.setSelection(false);
                CellVoltageValues.setVoltageLimits(CellVoltageValues.getVoltageLimits(CellVoltageValues.CellVoltageTypes.LiIo));
                Channel activeChannel = CellVoltageWindow.this.channels.getActiveChannel();
                RecordSet recordSet2 = recordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
                if (recordSet != null) {
                    recordSet.setVoltageLimits();
                }
                CellVoltageWindow.this.update(true, true);
            }
        });
        RowData button2LData = new RowData();
        button2LData.width = 70;
        button2LData.height = 18;
        this.liFeButton = new Button((Composite)this.voltageLimitsSelection, 0x1000020);
        this.liFeButton.setLayoutData((Object)button2LData);
        if (!GDE.IS_MAC) {
            this.liFeButton.setBackground(this.surroundingBackground);
        }
        this.liFeButton.setForeground(this.textColor);
        this.liFeButton.setText(Messages.getString("GDE_MSGT0373"));
        this.liFeButton.setToolTipText(Messages.getString("GDE_MSGT0370"));
        this.liFeButton.setSelection(false);
        this.liFeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet recordSet;
                log.logp(Level.FINEST, $CLASS_NAME, "create", "buttonLiPo.widgetSelected, event=" + String.valueOf(evt));
                CellVoltageWindow.this.liFeButton.setSelection(true);
                CellVoltageWindow.this.liPoButton.setSelection(false);
                CellVoltageWindow.this.liIoButton.setSelection(false);
                CellVoltageWindow.this.niMhButton.setSelection(false);
                CellVoltageWindow.this.individualButton.setSelection(false);
                CellVoltageValues.setVoltageLimits(CellVoltageValues.getVoltageLimits(CellVoltageValues.CellVoltageTypes.LiFe));
                Channel activeChannel = CellVoltageWindow.this.channels.getActiveChannel();
                RecordSet recordSet2 = recordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
                if (recordSet != null) {
                    recordSet.setVoltageLimits();
                }
                CellVoltageWindow.this.update(true, true);
            }
        });
        button2LData = new RowData();
        button2LData.width = 70;
        button2LData.height = 18;
        this.niMhButton = new Button((Composite)this.voltageLimitsSelection, 0x1000020);
        this.niMhButton.setLayoutData((Object)button2LData);
        if (!GDE.IS_MAC) {
            this.niMhButton.setBackground(this.surroundingBackground);
        }
        this.niMhButton.setForeground(this.textColor);
        this.niMhButton.setText(Messages.getString("GDE_MSGT0377"));
        this.niMhButton.setToolTipText(Messages.getString("GDE_MSGT0370"));
        this.niMhButton.setSelection(false);
        this.niMhButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet recordSet;
                log.logp(Level.FINEST, $CLASS_NAME, "create", "buttonLiPo.widgetSelected, event=" + String.valueOf(evt));
                CellVoltageWindow.this.liFeButton.setSelection(false);
                CellVoltageWindow.this.liPoButton.setSelection(false);
                CellVoltageWindow.this.liIoButton.setSelection(false);
                CellVoltageWindow.this.niMhButton.setSelection(true);
                CellVoltageWindow.this.individualButton.setSelection(false);
                CellVoltageValues.setVoltageLimits(CellVoltageValues.getVoltageLimits(CellVoltageValues.CellVoltageTypes.NiMh));
                Channel activeChannel = CellVoltageWindow.this.channels.getActiveChannel();
                RecordSet recordSet2 = recordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
                if (recordSet != null) {
                    recordSet.setVoltageLimits();
                }
                CellVoltageWindow.this.update(true, true);
            }
        });
        RowData button1LData1 = new RowData();
        button1LData1.width = 100;
        button1LData1.height = 18;
        this.individualButton = new Button((Composite)this.voltageLimitsSelection, 0x1000020);
        this.individualButton.setLayoutData((Object)button1LData1);
        if (!GDE.IS_MAC) {
            this.individualButton.setBackground(this.surroundingBackground);
        }
        this.individualButton.setForeground(this.textColor);
        this.individualButton.setText(Messages.getString("GDE_MSGT0375"));
        this.individualButton.setToolTipText(Messages.getString("GDE_MSGT0370"));
        this.individualButton.setSelection(false);
        this.individualButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet recordSet;
                log.logp(Level.FINEST, $CLASS_NAME, "create", "buttonLiPo.widgetSelected, event=" + String.valueOf(evt));
                CellVoltageWindow.this.individualButton.setSelection(true);
                CellVoltageWindow.this.liPoButton.setSelection(false);
                CellVoltageWindow.this.liIoButton.setSelection(false);
                CellVoltageWindow.this.liFeButton.setSelection(false);
                CellVoltageWindow.this.niMhButton.setSelection(false);
                CellVoltageValues.setVoltageLimits(new CellVoltageValuesDialog(DataExplorer.getInstance(), 34912).open());
                Channel activeChannel = CellVoltageWindow.this.channels.getActiveChannel();
                RecordSet recordSet2 = recordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
                if (recordSet != null) {
                    recordSet.setVoltageLimits();
                }
                CellVoltageWindow.this.update(true, true);
            }
        });
        this.voltageLimitsSelection.layout();
        this.coverComposite = new Composite(this.cellVoltageMainComposite, 0);
        this.coverComposite.setMenu(this.popupmenu);
        FillLayout fillLayout = new FillLayout(256);
        this.coverComposite.setLayout((Layout)fillLayout);
        this.cellVoltageMainComposite.setBackground(this.surroundingBackground);
        this.cellVoltageMainComposite.layout();
        this.digitalComposite = new Composite(this.cellVoltageMainComposite, 0);
        FillLayout digitalCompositeLayout = new FillLayout(256);
        this.digitalComposite.setLayout((Layout)digitalCompositeLayout);
        this.digitalComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "actualDigitalLabel.paintControl, event=" + String.valueOf(evt));
                CellVoltageWindow.this.updateVoltageAndCapacity();
            }
        });
        this.voltageValue = new CLabel(this.digitalComposite, 0x1000000);
        this.voltageValue.setText("00.00");
        this.voltageValue.setBackground(this.surroundingBackground);
        this.voltageValue.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 15, 0));
        this.voltageValue.setMenu(this.popupmenu);
        this.voltageUnit = new CLabel(this.digitalComposite, 0x1000000);
        this.voltageUnit.setText("[V]");
        this.voltageUnit.setBackground(this.surroundingBackground);
        this.voltageUnit.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 8, 0));
        this.voltageUnit.setMenu(this.popupmenu);
        this.capacitiyValue = new CLabel(this.digitalComposite, 0x1000000);
        this.capacitiyValue.setText("0000");
        this.capacitiyValue.setBackground(this.surroundingBackground);
        this.capacitiyValue.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 15, 0));
        this.capacitiyValue.setMenu(this.popupmenu);
        this.capacityUnit = new CLabel(this.digitalComposite, 0x1000000);
        this.capacityUnit.setText("[mAh]");
        this.capacityUnit.setBackground(this.surroundingBackground);
        this.capacityUnit.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 8, 0));
        this.capacityUnit.setMenu(this.popupmenu);
        this.cellVoltageMainComposite.layout();
        this.coverComposite.layout();
    }

    public void updateChilds() {
        this.updateCellVoltageVector();
        this.updateVoltageAndCapacity();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "voltageValues.length = " + this.voltageVector.size() + " displays.size() = " + this.displays.size());
        }
        if (this.voltageVector.size() > 0 && this.voltageVector.size() == this.displays.size()) {
            this.voltageDelta = this.calculateVoltageDelta(this.voltageVector);
            for (int i = 0; i < this.voltageVector.size(); ++i) {
                if (this.displays.get(i).getVoltage() == this.voltageVector.get(i).getVoltage()) continue;
                this.displays.get(i).setVoltage(this.voltageVector.get(i).getVoltage());
                this.displays.get(i).redraw();
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "setVoltage cell " + i + " - " + this.voltageVector.get(i).getVoltage());
            }
        } else if (this.coverComposite.isVisible()) {
            this.updateAndResize();
        }
    }

    public void update(boolean needUpdate, boolean forceClean) {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet = activeChannel.getActiveRecordSet();
            if (recordSet != null && recordSet.getDevice().isVoltagePerCellTabRequested() && !this.voltageVector.isEmpty()) {
                boolean isCleanRequired;
                boolean bl = isCleanRequired = forceClean || this.oldRecordSet == null || !recordSet.getName().equals(this.oldRecordSet.getName()) || this.oldChannel == null || !this.oldChannel.getName().equals(activeChannel.getName()) || this.displays.size() != this.voltageVector.size();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "isCleanRequired = " + isCleanRequired);
                }
                if (isCleanRequired) {
                    for (CellVoltageDisplay display : this.displays) {
                        if (display == null || display.isDisposed()) continue;
                        display.dispose();
                        display = null;
                    }
                    this.displays.removeAllElements();
                    CellVoltageValues.setVoltageLimits(recordSet.getVoltageLimits());
                    this.voltageLimitsSelection.redraw();
                    for (int i = 0; this.voltageVector != null && i < this.voltageVector.size(); ++i) {
                        CellVoltageDisplay display;
                        display = new CellVoltageDisplay(this.application, this.coverComposite, this.voltageVector.get(i).getVoltage(), this.voltageVector.get(i).getName(), this.voltageVector.get(i).getUnit(), this);
                        display.create();
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "created cellVoltage display for " + this.voltageVector.get(i).getVoltage());
                        }
                        this.displays.add(display);
                    }
                    this.oldRecordSet = recordSet;
                    this.oldChannel = activeChannel;
                    this.updateChilds();
                    this.cellVoltageMainComposite.layout();
                    this.coverComposite.layout();
                } else if (needUpdate) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "updateCellVoltageVector = true");
                    }
                    this.updateChilds();
                }
            } else {
                for (CellVoltageDisplay display : this.displays) {
                    if (display == null || display.isDisposed()) continue;
                    display.dispose();
                    display = null;
                }
                this.displays.removeAllElements();
                this.cellVoltageMainComposite.layout();
                this.coverComposite.layout();
            }
        }
    }

    boolean updateCellVoltageVector() {
        RecordSet recordSet;
        boolean isCellVoltageChanged = false;
        Vector<Integer> tmpCellVoltageVector = new Vector<Integer>(2);
        if (this.voltageVector.size() > 0) {
            for (CellInfo cellInfo : this.voltageVector) {
                tmpCellVoltageVector.add(cellInfo.getVoltage());
            }
        }
        this.voltageVector = new Vector();
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (recordSet = activeChannel.getActiveRecordSet()) != null && recordSet.getDevice().isVoltagePerCellTabRequested()) {
            this.voltageAvg = 0;
            int cellCount = 0;
            int cellVoltageReferenceMasterOrdinal = recordSet.getDevice().getDesktopTargetReferenceOrdinal(DesktopPropertyTypes.VOLTAGE_PER_CELL_TAB);
            if (cellVoltageReferenceMasterOrdinal >= 0 && recordSet.getScaleSyncedRecords(cellVoltageReferenceMasterOrdinal) != null) {
                for (Record record : recordSet.getScaleSyncedRecords(cellVoltageReferenceMasterOrdinal)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "record " + record.getName() + " symbol " + record.getSymbol());
                    }
                    if (!record.isDisplayable()) continue;
                    this.voltageVector.add(new CellInfo(record.getLast(), record.getName(), record.getUnit()));
                    this.voltageAvg += record.getLast().intValue();
                    ++cellCount;
                }
                if (cellCount > 0) {
                    this.voltageAvg /= cellCount;
                }
                for (int i = 0; i < tmpCellVoltageVector.size() && i < this.voltageVector.size(); ++i) {
                    if (((Integer)tmpCellVoltageVector.get(i)).intValue() == this.voltageVector.get(i).getVoltage()) continue;
                    isCellVoltageChanged = true;
                    if (!log.isLoggable(Level.FINER)) break;
                    log.log(Level.FINER, "updateCellVoltageVector -> changed");
                    break;
                }
            }
        }
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (CellInfo cellInfo : this.voltageVector) {
                sb.append(cellInfo.getVoltage()).append(" ");
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "updateCellVoltageVector -> " + sb.toString());
            }
        }
        return isCellVoltageChanged;
    }

    int addCellVoltages4Test(int[] values, String measurementName) {
        this.voltageVector = new Vector();
        for (int i = 0; i < values.length; ++i) {
            this.voltageVector.add(new CellInfo(values[i], measurementName + (i + 1), "V"));
        }
        return values.length;
    }

    private int calculateVoltageDelta(Vector<CellInfo> newValues) {
        int min = newValues.firstElement().getVoltage();
        int max = newValues.firstElement().getVoltage();
        for (CellInfo cellInfo : newValues) {
            if (cellInfo.voltage < min) {
                min = cellInfo.voltage;
                continue;
            }
            if (cellInfo.voltage <= max) continue;
            max = cellInfo.voltage;
        }
        return max - min;
    }

    public int getVoltageDelta() {
        return this.voltageDelta;
    }

    public Point getDisplayCompositeSize() {
        return this.displayCompositeSize;
    }

    void updateAndResize() {
        boolean isSomeVoltagechanged = this.updateCellVoltageVector();
        Rectangle mainSize = this.cellVoltageMainComposite.getClientArea();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "mainSize = " + mainSize.toString());
        }
        if (this.voltageVector.size() > 0) {
            int cellWidth = mainSize.width / this.voltageVector.size();
            cellWidth = Math.min(cellWidth, 180);
            int x = (mainSize.width - this.voltageVector.size() * cellWidth) / 2;
            int width = mainSize.width - 2 * x;
            Rectangle bounds = new Rectangle(x, 45, width, mainSize.height - 100);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "cover bounds = " + bounds.toString());
            }
            this.coverComposite.setBounds(bounds);
            this.digitalComposite.setBounds((mainSize.width - 350) / 2, mainSize.height - 50, 350, 50);
        } else {
            this.coverComposite.setSize(0, 0);
            this.clearVoltageAndCapacity();
        }
        this.update(isSomeVoltagechanged, false);
    }

    public Composite getCellVoltageMainComposite() {
        return this.cellVoltageMainComposite;
    }

    public int getVoltageAvg() {
        return this.voltageAvg;
    }

    void updateVoltageAndCapacity() {
        Channel activeChannel = this.channels.getActiveChannel();
        IDevice device = DataExplorer.getInstance().getActiveDevice();
        if (activeChannel != null) {
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            if (activeRecordSet != null) {
                String[] recordKeys = activeRecordSet.getActiveRecordNames();
                try {
                    Record record_U = activeRecordSet.get(recordKeys[this.firstMeasurement]);
                    if (record_U != null) {
                        this.voltageValue.setForeground(SWTResourceManager.getColor(record_U.getRGB()));
                        this.voltageValue.setText(new DecimalFormat("0.00").format(device.translateValue(record_U, (double)record_U.getLast().intValue() / 1000.0)));
                        this.voltageUnit.setText("[" + record_U.getUnit() + "]");
                        this.voltageValue.redraw();
                    }
                }
                catch (Exception record_U) {
                    // empty catch block
                }
                try {
                    Record record_C = activeRecordSet.get(recordKeys[this.secondMeasurement]);
                    if (record_C != null) {
                        this.capacitiyValue.setForeground(SWTResourceManager.getColor(record_C.getRGB()));
                        this.capacitiyValue.setText(new DecimalFormat("0").format(device.translateValue(record_C, (double)record_C.getLast().intValue() / 1000.0)));
                        this.capacityUnit.setText("[" + record_C.getUnit() + "]");
                        this.capacitiyValue.redraw();
                    }
                }
                catch (Exception exception) {}
            } else {
                this.clearVoltageAndCapacity();
            }
        } else {
            this.clearVoltageAndCapacity();
        }
    }

    void clearVoltageAndCapacity() {
        this.voltageValue.setText("");
        this.voltageUnit.setText("");
        this.capacitiyValue.setText("");
        this.capacityUnit.setText("");
    }

    public void updateVoltageLimitsSelection() {
        this.voltageLimitsSelection.redraw();
    }

    public void setMeasurements(int firstMeasurementOrdinal, int secondMeasurementOrdinal) {
        this.firstMeasurement = firstMeasurementOrdinal;
        this.secondMeasurement = secondMeasurementOrdinal;
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.cellVoltageMainComposite.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.cellVoltageMainComposite.print(imageGC);
        if (GDE.IS_MAC) {
            this.cellVoltageMainComposite.print(imageGC);
        }
        imageGC.dispose();
        return tabContentImage;
    }

    public void setInnerAreaBackground(Color newInnerAreaBackground) {
        this.update(true, true);
    }

    public void setSurroundingAreaBackground(Color newSurroundingBackground) {
        this.surroundingBackground = newSurroundingBackground;
        this.cellVoltageMainComposite.setBackground(newSurroundingBackground);
        this.voltageLimitsSelection.setBackground(newSurroundingBackground);
        this.voltageUnit.setBackground(newSurroundingBackground);
        this.voltageValue.setBackground(newSurroundingBackground);
        this.capacityUnit.setBackground(newSurroundingBackground);
        this.capacitiyValue.setBackground(newSurroundingBackground);
        this.liPoButton.setBackground(newSurroundingBackground);
        this.liIoButton.setBackground(newSurroundingBackground);
        this.liFeButton.setBackground(newSurroundingBackground);
        this.niMhButton.setBackground(newSurroundingBackground);
        this.individualButton.setBackground(newSurroundingBackground);
        this.cellVoltageMainComposite.redraw();
    }

    static class CellInfo {
        final int voltage;
        final String name;
        final String unit;

        CellInfo(int newVoltage, String newName, String newUnit) {
            this.voltage = newVoltage;
            this.name = newName;
            this.unit = newUnit;
        }

        public int getVoltage() {
            return this.voltage;
        }

        public String getName() {
            return this.name;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

