/*
 * Decompiled with CFR 0.152.
 */
package gde.device.htronic;

import gde.data.Record;
import gde.data.RecordSet;
import gde.log.Level;
import gde.ui.DataExplorer;
import java.util.logging.Logger;

public class AkkuMasterCalculationThread
extends Thread {
    static final Logger log = Logger.getLogger(AkkuMasterCalculationThread.class.getName());
    String recordKey;
    RecordSet recordSet;
    final DataExplorer application;

    public AkkuMasterCalculationThread(String useRecordKey, RecordSet useRecordSet) {
        super("calculation");
        this.recordKey = useRecordKey;
        this.recordSet = useRecordSet;
        this.application = DataExplorer.getInstance();
    }

    @Override
    public void run() {
        log.log(Level.FINE, "start data calculation for record = " + this.recordKey);
        Record record = this.recordSet.get((Object)this.recordKey);
        if (this.recordKey.equals(this.recordSet.get(3).getName())) {
            Record recordVoltage = this.recordSet.get(0);
            Record recordCurrent = this.recordSet.get(1);
            record.clear();
            for (int i = 0; i < recordVoltage.size(); ++i) {
                record.add(Integer.valueOf(Double.valueOf((double)recordVoltage.realGet(i).intValue() / 1000.0 * ((double)recordCurrent.realGet(i).intValue() / 1000.0) * 1000.0).intValue()));
                log.log(Level.FINEST, "adding value = " + record.realGet(i));
            }
            record.setDisplayable(true);
        } else if (this.recordKey.equals(this.recordSet.get(4).getName())) {
            Record recordVoltage = this.recordSet.get(0);
            Record recordCharge = this.recordSet.get(2);
            record.clear();
            for (int i = 0; i < recordVoltage.size(); ++i) {
                record.add(Integer.valueOf(Double.valueOf((double)recordVoltage.realGet(i).intValue() / 1000.0 * ((double)recordCharge.realGet(i).intValue() / 1000.0)).intValue()));
                log.log(Level.FINEST, "adding value = " + record.realGet(i));
            }
            record.setDisplayable(true);
        } else {
            log.log(Level.WARNING, "only supported records are " + this.recordSet.get(3).getName() + ", " + this.recordSet.get(4).getName());
        }
        this.application.updateGraphicsWindow();
        log.log(Level.FINE, "finished data calculation for record = " + this.recordKey);
    }
}

