/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.device.IChannelItem;
import gde.device.MeasurementType;
import gde.device.StatisticsType;
import gde.device.resource.DeviceXmlResource;
import gde.messages.Messages;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="trail_types")
@XmlEnum
public enum TrailTypes {
    REAL_AVG(0, false, "GDE_MSGT0750"),
    REAL_COUNT(12, false, "GDE_MSGT0751"),
    REAL_MAX(1, false, "GDE_MSGT0754"),
    REAL_MIN(2, false, "GDE_MSGT0755"),
    REAL_SD(3, true, "GDE_MSGT0756"),
    REAL_FIRST(4, false, "GDE_MSGT0752"),
    REAL_LAST(5, false, "GDE_MSGT0753"),
    REAL_SUM_TRIGGERED(6, true, "GDE_MSGT0758"),
    REAL_MAX_RATIO_TRIGGERED(9, true, "GDE_MSGT0761"),
    REAL_TIME_SUM_TRIGGERED(7, true, "GDE_MSGT0759"),
    REAL_COUNT_TRIGGERED(10, true, "GDE_MSGT0757"),
    REAL_SUM(11, true, "GDE_MSGT0762"),
    AVG(13, "GDE_MSGT0763"),
    MAX(14, "GDE_MSGT0764"),
    MIN(15, "GDE_MSGT0765"),
    SD(16, "GDE_MSGT0766"),
    Q0(17, "GDE_MSGT0767"),
    Q1(18, "GDE_MSGT0768"),
    Q2(19, "GDE_MSGT0769"),
    Q3(20, "GDE_MSGT0770"),
    Q4(21, "GDE_MSGT0771"),
    Q_25_PERMILLE(22, "GDE_MSGT0772"),
    Q_975_PERMILLE(23, "GDE_MSGT0773"),
    Q_LOWER_WHISKER(24, "GDE_MSGT0774"),
    Q_UPPER_WHISKER(25, "GDE_MSGT0775"),
    FIRST(30, "GDE_MSGT0776"),
    LAST(31, "GDE_MSGT0777"),
    SUM(32, "GDE_MSGT0778"),
    COUNT(33, "GDE_MSGT0779"),
    RAW_MAX(34, "GDE_MSGT0760"),
    RAW_BITS(35, "GDE_MSGT0801"),
    SUITE_REAL_AVG_SD(101, "GDE_MSGT0780", false, new TrailTypes[]{REAL_AVG, REAL_SD, REAL_SD}),
    SUITE_REAL_AVG_MIN_MAX(102, "GDE_MSGT0781", false, new TrailTypes[]{REAL_AVG, REAL_MIN, REAL_MAX}),
    SUITE_AVG_SD(108, "GDE_MSGT0782", true, new TrailTypes[]{AVG, SD, SD}),
    SUITE_AVG_MIN_MAX(109, "GDE_MSGT0783", true, new TrailTypes[]{AVG, MIN, MAX}),
    SUITE_BOX_PLOT(104, "GDE_MSGT0784", true, new TrailTypes[]{Q0, Q1, Q2, Q3, Q4, Q_LOWER_WHISKER, Q_UPPER_WHISKER}),
    SUITE_BOX_PLOT_95(105, "GDE_MSGT0785", true, new TrailTypes[]{Q0, Q1, Q2, Q3, Q4, Q_25_PERMILLE, Q_975_PERMILLE}),
    SUITE_Q0_Q2_Q4(106, "GDE_MSGT0786", true, new TrailTypes[]{Q2, Q0, Q4}),
    SUITE_Q1_Q2_Q3(107, "GDE_MSGT0787", true, new TrailTypes[]{Q2, Q1, Q3});

    public static final int RANGE_PLOT_SIZE = 3;
    public static final int BOX_PLOT_SIZE = 7;
    private final int displaySequence;
    private final boolean isTriggered;
    private final String displayId;
    private final boolean isSmartStatistics;
    private final TrailTypes[] suiteMembers;
    private final int suiteMasterIndex;
    private final int suiteLowerIndex;
    private final int suiteUpperIndex;
    public static final TrailTypes[] VALUES;
    public static final EnumSet<TrailTypes> ODD_RANGE_TRAILS;
    public static final EnumSet<TrailTypes> OPTIONAL_TRAILS;
    public static final TrailTypes[] DISPLAY_VALUES;
    private static final EnumSet<TrailTypes> PRIMITIVES;
    private static final EnumSet<TrailTypes> SUITES;
    private static final EnumSet<TrailTypes> SUBSTITUTES;
    private static final Function<TrailTypes, String> MSG;

    private TrailTypes(int displaySequence, boolean isTriggered, String displayId) {
        this.displaySequence = displaySequence;
        this.isTriggered = isTriggered;
        this.displayId = displayId;
        this.isSmartStatistics = false;
        this.suiteMembers = new TrailTypes[0];
        this.suiteMasterIndex = 0;
        this.suiteLowerIndex = 0;
        this.suiteUpperIndex = 0;
    }

    private TrailTypes(int displaySequence, String displayId) {
        this.displaySequence = displaySequence;
        this.isTriggered = false;
        this.displayId = displayId;
        this.isSmartStatistics = true;
        this.suiteMembers = new TrailTypes[0];
        this.suiteMasterIndex = 0;
        this.suiteLowerIndex = 0;
        this.suiteUpperIndex = 0;
    }

    private TrailTypes(int displaySequence, String displayId, boolean isSmartStatistics, TrailTypes[] suiteMembers) {
        this.displaySequence = displaySequence;
        this.isTriggered = false;
        this.displayId = displayId;
        this.isSmartStatistics = isSmartStatistics;
        this.suiteMembers = suiteMembers;
        if (this.isBoxPlot()) {
            this.suiteMasterIndex = 2;
            this.suiteLowerIndex = 5;
            this.suiteUpperIndex = 6;
        } else {
            this.suiteMasterIndex = 0;
            this.suiteLowerIndex = 1;
            this.suiteUpperIndex = 2;
        }
    }

    public static TrailTypes fromDisplayName(String displayName) {
        if (displayName != null) {
            for (TrailTypes trailType : VALUES) {
                if (!displayName.equalsIgnoreCase(MSG.apply(trailType))) continue;
                return trailType;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TrailTypes fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public static TrailTypes getSubstitute(boolean smartStatistics) {
        return SUBSTITUTES.stream().filter(t -> t.isSmartStatistics == smartStatistics).findFirst().orElseThrow(UnsupportedOperationException::new);
    }

    public static EnumSet<TrailTypes> getPrimitives() {
        return PRIMITIVES;
    }

    public static EnumSet<TrailTypes> getSuites() {
        return SUITES;
    }

    public String getSuiteMembersToString() {
        return Arrays.toString((Object[])this.suiteMembers);
    }

    public List<TrailTypes> getSuiteMembers() {
        return Arrays.asList(this.suiteMembers);
    }

    public TrailTypes getSuiteMember(int index) {
        return this.suiteMembers[index];
    }

    public TrailTypes[] getMembers() {
        if (this.suiteMembers.length == 0) {
            return new TrailTypes[]{this};
        }
        return this.suiteMembers;
    }

    public boolean isRangePlot() {
        return this.suiteMembers.length == 3;
    }

    public boolean isBoxPlot() {
        return this.suiteMembers.length == 7;
    }

    public boolean isSuite() {
        return this.suiteMembers.length > 1;
    }

    public String getDisplayName() {
        return MSG.apply(this);
    }

    public String getDisplayNameWithTriggerText(IChannelItem channelItem) {
        if (this.isTriggered()) {
            StatisticsType measurementStatistics = ((MeasurementType)channelItem).getStatistics();
            if (this.equals((Object)REAL_COUNT_TRIGGERED)) {
                return this.getDeviceXmlReplacement(measurementStatistics.getCountTriggerText());
            }
            if (this.equals((Object)REAL_SUM_TRIGGERED)) {
                return this.getDeviceXmlReplacement(measurementStatistics.getSumTriggerText());
            }
            if (this.equals((Object)REAL_TIME_SUM_TRIGGERED)) {
                return this.getDeviceXmlReplacement(measurementStatistics.getSumTriggerTimeText());
            }
            if (this.equals((Object)REAL_MAX_RATIO_TRIGGERED)) {
                return this.getDeviceXmlReplacement(measurementStatistics.getRatioText());
            }
            throw new UnsupportedOperationException("TrailTypes.isTriggered");
        }
        return this.getDisplayName();
    }

    private String getDeviceXmlReplacement(String replacementKey) {
        return replacementKey != null ? DeviceXmlResource.getInstance().getReplacement(replacementKey) : "";
    }

    public boolean isTriggered() {
        return this.isTriggered;
    }

    public int getDisplaySequence() {
        return this.displaySequence;
    }

    public boolean isSmartStatistics() {
        return this.isSmartStatistics;
    }

    public int getSuiteMasterIndex() {
        return this.suiteMasterIndex;
    }

    public int getSuiteLowerIndex() {
        return this.suiteLowerIndex;
    }

    public int getSuiteUpperIndex() {
        return this.suiteUpperIndex;
    }

    static {
        VALUES = TrailTypes.values();
        ODD_RANGE_TRAILS = EnumSet.noneOf(TrailTypes.class);
        OPTIONAL_TRAILS = EnumSet.noneOf(TrailTypes.class);
        DISPLAY_VALUES = (TrailTypes[])TrailTypes.values().clone();
        PRIMITIVES = EnumSet.noneOf(TrailTypes.class);
        SUITES = EnumSet.noneOf(TrailTypes.class);
        SUBSTITUTES = EnumSet.noneOf(TrailTypes.class);
        MSG = t -> Messages.getString(t.displayId);
        OPTIONAL_TRAILS.add(RAW_MAX);
        OPTIONAL_TRAILS.add(RAW_BITS);
        ODD_RANGE_TRAILS.add(REAL_COUNT);
        ODD_RANGE_TRAILS.add(REAL_SD);
        ODD_RANGE_TRAILS.add(REAL_SUM_TRIGGERED);
        ODD_RANGE_TRAILS.add(REAL_MAX_RATIO_TRIGGERED);
        ODD_RANGE_TRAILS.add(REAL_TIME_SUM_TRIGGERED);
        ODD_RANGE_TRAILS.add(REAL_COUNT_TRIGGERED);
        ODD_RANGE_TRAILS.add(REAL_SUM);
        ODD_RANGE_TRAILS.add(SD);
        ODD_RANGE_TRAILS.add(SUM);
        ODD_RANGE_TRAILS.add(COUNT);
        ODD_RANGE_TRAILS.add(RAW_MAX);
        ODD_RANGE_TRAILS.add(RAW_BITS);
        Arrays.sort(DISPLAY_VALUES, (o1, o2) -> o1.displaySequence < o2.displaySequence ? -1 : (o1.displaySequence > o2.displaySequence ? 1 : 0));
        for (TrailTypes trailType : VALUES) {
            if (!trailType.isSuite()) {
                PRIMITIVES.add(trailType);
            }
            if (trailType.isSuite()) {
                SUITES.add(trailType);
            }
            SUBSTITUTES.add(REAL_LAST);
            SUBSTITUTES.add(LAST);
        }
    }
}

