/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;

public class ServoDataBlock
extends DataBlock {
    private static final int MAX_NUMBER_OF_CHANNELS = 20;
    public static final short[] CHANNELVALUES = new short[20];
    private short[] channelValues;
    private int availableChannelWithDataBitArray = 0;

    public ServoDataBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        int i = 0;
        while (i < 20) {
            this.measurementNames.add("Ch " + (i + 1));
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.measurementUnits.add("%");
            ++i;
        }
        i = 0;
        while (i < 20) {
            this.measurementFactors.add(1.0);
            ++i;
        }
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof ServoDataBlock) {
            ServoDataBlock servo = (ServoDataBlock)block;
            int i = 0;
            while (i < this.availableChannelWithDataBitArray) {
                if (servo.channelValues[i] != this.channelValues[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean hasChannel(int channelNumber) {
        return this.isBitSet(channelNumber);
    }

    private void decode(byte[] rawData) {
        this.channelValues = new short[20];
        this.decode11BitChannel(rawData[6], rawData[7]);
        this.decode11BitChannel(rawData[8], rawData[9]);
        this.decode11BitChannel(rawData[10], rawData[11]);
        this.decode11BitChannel(rawData[12], rawData[13]);
        this.decode11BitChannel(rawData[14], rawData[15]);
        this.decode11BitChannel(rawData[16], rawData[17]);
        this.decode9BitChannel(rawData[6], rawData[18], rawData[19]);
        int i = 0;
        while (i < 20) {
            if (this.isBitSet(i)) {
                this.measurementValues.add((int)this.getPercent(i, this.channelValues[i]));
                ServoDataBlock.CHANNELVALUES[i] = this.channelValues[i];
            } else {
                this.measurementValues.add((int)this.getPercent(i, CHANNELVALUES[i]));
            }
            ++i;
        }
    }

    private void decode11BitChannel(byte first, byte second) {
        int channelNumber = (first & 0x78) >> 3;
        short channelValue = (short)(((first & 7) << 8) + (second & 0xFF));
        this.setChannelValue(channelValue, channelNumber);
    }

    private void decode9BitChannel(byte blockByte, byte first, byte second) {
        int channelNumber = (first & 0x78) >> 3;
        int channelSubNumber = ((blockByte & 0x80) >> 5) + ((first & 6) >> 1);
        short channelValue = (short)(((first & 1) << 8) + (second & 0xFF));
        this.setChannelValue(channelValue, channelNumber + channelSubNumber);
    }

    public short getChannelValue(int channelNumber) {
        return this.channelValues[channelNumber];
    }

    private void setChannelValue(short channelValue, int completeChannelNumber) {
        this.channelValues[completeChannelNumber] = channelValue;
        this.setBit(completeChannelNumber);
    }

    private boolean isBitSet(int channelNumber) {
        return (this.availableChannelWithDataBitArray & 1 << channelNumber) != 0;
    }

    private void setBit(int channelNumber) {
        this.availableChannelWithDataBitArray |= 1 << channelNumber;
    }

    private float getPercent(Integer channelNumber, short channelValue) {
        int MAX_SERVO_TRAVEL_IN_PERCENT = 300;
        double maxValue = channelNumber < 12 ? Math.pow(2.0, 11.0) : Math.pow(2.0, 9.0);
        double middleValue = maxValue / 2.0;
        return (float)(((double)channelValue - middleValue) / (maxValue / 300.0));
    }
}

