/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import java.util.Collection;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapVisualization;

public class UnifiedDistanceMatrix
implements MapVisualization {
    private final boolean individualDistances;
    private final DistanceMeasure distance;

    public UnifiedDistanceMatrix(boolean individualDistances, DistanceMeasure distance) {
        this.individualDistances = individualDistances;
        this.distance = distance;
    }

    public double[][] computeImage(NeuronSquareMesh2D map2) {
        if (this.individualDistances) {
            return this.individualDistances(map2);
        }
        return this.averageDistances(map2);
    }

    private double[][] individualDistances(NeuronSquareMesh2D map2) {
        Object current;
        int jR;
        int j2;
        int iR;
        int i2;
        int numRows = map2.getNumberOfRows();
        int numCols = map2.getNumberOfColumns();
        double[][] uMatrix = new double[numRows * 2 + 1][numCols * 2 + 1];
        for (i2 = 0; i2 < numRows; ++i2) {
            iR = 2 * i2 + 1;
            for (j2 = 0; j2 < numCols; ++j2) {
                jR = 2 * j2 + 1;
                current = map2.getNeuron(i2, j2).getFeatures();
                Neuron neighbour = map2.getNeuron(i2, j2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER);
                if (neighbour != null) {
                    uMatrix[iR][jR + 1] = this.distance.compute((double[])current, neighbour.getFeatures());
                }
                if ((neighbour = map2.getNeuron(i2, j2, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN)) == null) continue;
                uMatrix[iR + 1][jR] = this.distance.compute((double[])current, neighbour.getFeatures());
            }
        }
        for (i2 = 0; i2 < numRows; ++i2) {
            iR = 2 * i2 + 1;
            for (j2 = 0; j2 < numCols; ++j2) {
                jR = 2 * j2 + 1;
                current = map2.getNeuron(i2, j2);
                Neuron right2 = map2.getNeuron(i2, j2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER);
                Neuron bottom2 = map2.getNeuron(i2, j2, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN);
                Neuron bottomRight = map2.getNeuron(i2, j2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.DOWN);
                double current2BottomRight = bottomRight == null ? 0.0 : this.distance.compute(((Neuron)current).getFeatures(), bottomRight.getFeatures());
                double right2Bottom = right2 == null || bottom2 == null ? 0.0 : this.distance.compute(right2.getFeatures(), bottom2.getFeatures());
                uMatrix[iR + 1][jR + 1] = 0.5 * (current2BottomRight + right2Bottom);
            }
        }
        int lastRow = uMatrix.length - 1;
        uMatrix[0] = uMatrix[lastRow];
        int lastCol = uMatrix[0].length - 1;
        for (int r2 = 0; r2 < lastRow; ++r2) {
            uMatrix[r2][0] = uMatrix[r2][lastCol];
        }
        return uMatrix;
    }

    private double[][] averageDistances(NeuronSquareMesh2D map2) {
        int numRows = map2.getNumberOfRows();
        int numCols = map2.getNumberOfColumns();
        double[][] uMatrix = new double[numRows][numCols];
        Network net = map2.getNetwork();
        for (int i2 = 0; i2 < numRows; ++i2) {
            for (int j2 = 0; j2 < numCols; ++j2) {
                Neuron neuron = map2.getNeuron(i2, j2);
                Collection<Neuron> neighbours = net.getNeighbours(neuron);
                double[] features = neuron.getFeatures();
                double d2 = 0.0;
                int count = 0;
                for (Neuron n2 : neighbours) {
                    ++count;
                    d2 += this.distance.compute(features, n2.getFeatures());
                }
                uMatrix[i2][j2] = d2 / (double)count;
            }
        }
        return uMatrix;
    }
}

