/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.el.ELContext;
import javax.el.ValueExpression;

public final class IteratedExpression {
    protected final ValueExpression orig;
    protected final String delims;
    private Object originalListObject = null;
    private Iterator currentListObject = null;
    private int currentIndex = 0;
    private int type = 0;

    public IteratedExpression(ValueExpression valueExpression, String stringTokenSeparator) {
        this.orig = valueExpression;
        this.delims = stringTokenSeparator;
    }

    public Object getItem(ELContext context, int i) {
        if (this.originalListObject == null) {
            this.originalListObject = this.orig.getValue(context);
            if (this.originalListObject instanceof Collection) {
                this.type = 1;
            } else if (this.originalListObject instanceof Iterator) {
                this.type = 2;
            } else if (this.originalListObject instanceof Enumeration) {
                this.type = 3;
            } else if (this.originalListObject instanceof Map) {
                this.type = 4;
            } else if (this.originalListObject instanceof String) {
                this.type = 5;
            } else {
                throw new RuntimeException("IteratedExpression.getItem: Object not of correct type.");
            }
            this.currentListObject = this.returnNewIterator(this.originalListObject, this.type);
        }
        Object currentObject = null;
        if (i < this.currentIndex) {
            this.currentListObject = this.returnNewIterator(this.originalListObject, this.type);
            this.currentIndex = 0;
        }
        while (this.currentIndex <= i) {
            if (!this.currentListObject.hasNext()) {
                throw new RuntimeException("IteratedExpression.getItem: Index out of Bounds");
            }
            currentObject = this.currentListObject.next();
            ++this.currentIndex;
        }
        return currentObject;
    }

    public ValueExpression getValueExpression() {
        return this.orig;
    }

    private Iterator returnNewIterator(Object o, int type) {
        Iterator<Object> i = null;
        switch (type) {
            case 1: {
                i = ((Collection)o).iterator();
                break;
            }
            case 2: {
                if (this.currentListObject == null) {
                    Vector v = new Vector();
                    Iterator myI = (Iterator)o;
                    while (myI.hasNext()) {
                        v.add(myI.next());
                    }
                    this.originalListObject = v;
                }
                i = ((Vector)this.originalListObject).iterator();
                break;
            }
            case 3: {
                if (this.currentListObject == null) {
                    Vector v = new Vector();
                    Enumeration myE = (Enumeration)o;
                    while (myE.hasMoreElements()) {
                        v.add(myE.nextElement());
                    }
                    this.originalListObject = v;
                }
                i = ((Vector)this.originalListObject).iterator();
                break;
            }
            case 4: {
                Set s = ((Map)o).entrySet();
                i = s.iterator();
                break;
            }
            case 5: {
                if (this.currentListObject == null) {
                    Vector<Object> v = new Vector<Object>();
                    StringTokenizer st = new StringTokenizer((String)o, this.delims);
                    while (st.hasMoreElements()) {
                        v.add(st.nextElement());
                    }
                    this.originalListObject = v;
                }
                i = ((Vector)this.originalListObject).iterator();
                break;
            }
        }
        return i;
    }
}

