/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.voice;

import de.treichels.hott.voice.ADPCMCodec;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/treichels/hott/voice/DecodingInputStream;", "Ljava/io/InputStream;", "inputStream", "(Ljava/io/InputStream;)V", "buffer", "", "codec", "Lde/treichels/hott/voice/ADPCMCodec;", "index", "", "available", "close", "", "mark", "readlimit", "markSupported", "", "read", "reset", "skip", "", "n", "HoTT-Voice"})
public final class DecodingInputStream
extends InputStream {
    private final ADPCMCodec codec;
    private final int[] buffer;
    private int index;
    private final InputStream inputStream;

    @Override
    public int available() {
        return this.inputStream.available() * 4;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() {
        if (this.index > 3) {
            int b2 = this.inputStream.read();
            if (b2 == -1) {
                return -1;
            }
            this.index = 0;
            byte lowNibble = (byte)(b2 & 0xF);
            byte highNibble = (byte)((b2 & 0xF0) >> 4);
            int pcm = 0;
            pcm = this.codec.decode(lowNibble) * 16;
            this.buffer[0] = pcm & 0xFF;
            this.buffer[1] = (pcm & 0xFF00) >> 8;
            pcm = this.codec.decode(highNibble) * 16;
            this.buffer[2] = pcm & 0xFF;
            this.buffer[3] = (pcm & 0xFF00) >> 8;
        }
        int n2 = this.index;
        this.index = n2 + 1;
        return this.buffer[n2];
    }

    @Override
    public synchronized void reset() {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n2) {
        return this.inputStream.skip(n2);
    }

    public DecodingInputStream(@NotNull InputStream inputStream2) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        this.inputStream = inputStream2;
        this.codec = new ADPCMCodec();
        this.buffer = new int[4];
        this.index = 4;
    }
}

