/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.config.Settings;
import gde.messages.Messages;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;

public final class LocalizedDateTime {
    public static void testUtc() {
        long ts = System.currentTimeMillis();
        Date localTime = new Date(ts);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        SimpleDateFormat sdfUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        System.out.println(LocalizedDateTime.getFormatedTime(DateTimePattern.yyyyMMdd_HHmmssSSS, ts) + "  " + sdf.format(localTime));
        System.out.println(LocalizedDateTime.getFormatedTime(DateTimePattern.yyyyMMdd_HHmmssSSS, ts) + "  " + sdfUTC.format(localTime));
        sdfUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        System.out.println(LocalizedDateTime.getFormatedTime(DateTimePattern.yyyyMMdd_HHmmssSSS, ts) + "  " + sdfUTC.format(localTime) + "  " + sdfUTC.format(ts));
    }

    public static String getFormatedTime(DateTimePattern formatPattern, long timeStamp_ms) {
        if (timeStamp_ms <= 346896000000L) {
            return LocalizedDateTime.getFormatedDuration(DurationPattern.get(formatPattern), timeStamp_ms);
        }
        return formatPattern.getFormatter().format(timeStamp_ms);
    }

    public static String getFormatedTime(DateTimePattern formatPattern, double timeStamp_ms) {
        return LocalizedDateTime.getFormatedTime(formatPattern, (long)timeStamp_ms);
    }

    public static String getFormatedDuration(DurationPattern formatPattern, long duration_ms) {
        if (duration_ms > 346896000000L) {
            throw new UnsupportedOperationException();
        }
        return formatPattern.getFormatter().format(duration_ms);
    }

    public static String getFormatedDistance(long timestamp1_ms, long timestamp2_ms) {
        if (Math.abs(timestamp1_ms - timestamp2_ms) > 86400000L) {
            Period y = Period.between(Instant.ofEpochMilli(timestamp2_ms).atZone(ZoneId.systemDefault()).toLocalDate(), Instant.ofEpochMilli(timestamp1_ms).atZone(ZoneId.systemDefault()).toLocalDate());
            if (Math.abs(y.toTotalMonths()) > 0L) {
                return String.format("%d%s %d%s", Math.abs(y.toTotalMonths()), Messages.getString("GDE_MSGT0868"), Math.abs(y.getDays()), Messages.getString("GDE_MSGT0869"));
            }
            return String.format("%d%s %s", Math.abs(y.getDays()), Messages.getString("GDE_MSGT0869"), LocalizedDateTime.getFormatedDuration(DurationPattern.HH_mm, Math.abs(timestamp1_ms - timestamp2_ms)));
        }
        return LocalizedDateTime.getFormatedDuration(DurationPattern.HH_mm, Math.abs(timestamp1_ms - timestamp2_ms));
    }

    public static enum DateTimePattern {
        yyyyMMdd_HHmmssSSS(0, "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"),
        yyyyMMdd_HHmmss(1, "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss'Z'"),
        yyyyMMdd_HHmm(2, "yyyy-MM-dd HH:mm", "yyyy-MM-dd'T'HH:mm'Z'"),
        yyyyMMdd(4, "yyyy-MM-dd", "yyyy-MM-dd'T'"),
        yyyyMM(5, "yyyy-MM", "yyyy-MM'T'"),
        yyMMdd(6, "yy-MM-dd", "yy-MM-dd'T'"),
        MMdd_HH(13, "MM-dd HH", "MM-dd'T'HH'Z'"),
        MMdd(14, "MM-dd", "MM-dd'T'"),
        dd_HHmm(16, "dd HH:mm", "dd'T'HH:mm'Z'"),
        HHmmssSSS(17, "HH:mm:ss.SSS", "HH:mm:ss.SSS'Z'"),
        HHmmss(18, "HH:mm:ss", "HH:mm:ss'Z'"),
        HHmm(19, "HH:mm", "HH:mm'Z'"),
        mmssSSS(20, "mm:ss.SSS", "mm:ss.SSS'Z'"),
        ssSSS(28, "ss.SSS", "ss.SSS'Z'");

        private final String userPattern;
        private final String userUtcPattern;

        private DateTimePattern(int displaySequence, String userPattern, String userUtcPattern) {
            this.userPattern = userPattern;
            this.userUtcPattern = userUtcPattern;
        }

        public String toString() {
            return this.userPattern;
        }

        public SimpleDateFormat getFormatter() {
            SimpleDateFormat sdf;
            if (Settings.getInstance().isDateTimeUtc()) {
                sdf = new SimpleDateFormat(this.userUtcPattern);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                sdf = new SimpleDateFormat(this.userPattern);
            }
            return sdf;
        }
    }

    public static enum DurationPattern {
        yy_MM_dd_HH_mm_ss_SSS(0, "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSS"),
        yy_MM_dd_HH_mm(2, "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm'Z'"),
        yy_MM_dd(6, "yy-MM-dd", "yy-MM-dd"),
        MM_dd_HH_mm_ss_SSS(9, "MM-dd HH:mm:ss.SSS", "MM-dd HH:mm:ss.SSSZ"),
        MM_dd_HH(13, "MM-dd HH", "MM-dd HH"),
        MM_dd(14, "MM-dd HH", "MM-dd HH"),
        dd_HH_mm_ss_SSS(15, "dd HH:mm:ss.SSS", "dd HH:mm:ss.SSSZ"),
        dd_HH_mm(16, "dd HH:mm", "dd HH:mm"),
        HH_mm_ss_SSS(17, "HH:mm:ss.SSS", "HH:mm:ss.SSS"),
        HH_mm_ss(18, "HH:mm:ss", "HH:mm:ss"),
        HH_mm(19, "HH:mm", "HH:mm"),
        mm_ss_SSS(24, "mm:ss.SSS", "mm:ss.SSS"),
        ss_SSS(28, "ss.SSS", "ss.SSS");

        private final String userPattern;
        private final String userUtcPattern;
        public static final DurationPattern[] VALUES;

        private DurationPattern(int displaySequence, String userPattern, String userUtcPattern) {
            this.userPattern = userPattern;
            this.userUtcPattern = userUtcPattern;
        }

        public String toString() {
            return this.userPattern;
        }

        public SimpleDateFormat getFormatter() {
            SimpleDateFormat sdf = Settings.getInstance().isDateTimeUtc() ? new SimpleDateFormat(this.userUtcPattern) : new SimpleDateFormat(this.userPattern);
            sdf.getTimeZone().setRawOffset(0);
            return sdf;
        }

        public static DurationPattern get(DateTimePattern dateTimePattern) {
            DurationPattern result = dd_HH_mm;
            for (DurationPattern durationPattern : VALUES) {
                if (!durationPattern.toString().equals(dateTimePattern.toString())) continue;
                result = durationPattern;
                break;
            }
            return result;
        }

        static {
            VALUES = DurationPattern.values();
        }
    }
}

