/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math3.stat.clustering.Clusterable;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EuclideanIntegerPoint
implements Clusterable<EuclideanIntegerPoint>,
Serializable {
    private static final long serialVersionUID = 3946024775784901369L;
    private final int[] point;

    public EuclideanIntegerPoint(int[] point) {
        this.point = point;
    }

    public int[] getPoint() {
        return this.point;
    }

    @Override
    public double distanceFrom(EuclideanIntegerPoint p2) {
        return MathArrays.distance(this.point, p2.getPoint());
    }

    @Override
    public EuclideanIntegerPoint centroidOf(Collection<EuclideanIntegerPoint> points) {
        int[] centroid = new int[this.getPoint().length];
        for (EuclideanIntegerPoint p2 : points) {
            for (int i2 = 0; i2 < centroid.length; ++i2) {
                int n2 = i2;
                centroid[n2] = centroid[n2] + p2.getPoint()[i2];
            }
        }
        int i3 = 0;
        while (i3 < centroid.length) {
            int n3 = i3++;
            centroid[n3] = centroid[n3] / points.size();
        }
        return new EuclideanIntegerPoint(centroid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EuclideanIntegerPoint)) {
            return false;
        }
        return Arrays.equals(this.point, ((EuclideanIntegerPoint)other).point);
    }

    public int hashCode() {
        return Arrays.hashCode(this.point);
    }

    public String toString() {
        return Arrays.toString(this.point);
    }
}

