/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptstereodelay";
declare description "stereo delay filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.12";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
fi = library("effect.lib");
ma = library("maths.lib");
cptbasics = library("lib/basics.lib");

// constanta used in this program
constant = environment {
	     nchannels = 2;// number of channels; do not change this - this is a stereo filter
	   };

//a slider for the gain
gain = hslider("[1]gain",1,0,1,0.01) : si.smoo;

//a slider for the feedback
feedback = hslider("[4]feedback", 0.5,0,1,0.01) : si.smoo;

//a slider for the delay on the left channel
M = 60 / hslider("[3][lv2: integer]delay bpm left",120,1,300,1);// M in seconds

//a slider for the delay on the right channel
N = 60 / hslider("[5][lv2: integer]delay bpm right",120,1,300,1);// N in seconds

//calculating the echo
monoecho(d,f) = +~bounce(d,f) with {
    bounce(d,f) = @(d) : *(f);
};

// the process, that is going to be executed
process = (cptbasics.bargraphinput(0) :
	   cptbasics.stereodrywetmonofx(0, monoecho(ma.SR*M,feedback)) :
	   cptbasics.bargraphoutput(0)),
	  (cptbasics.bargraphinput(1) :
	   cptbasics.stereodrywetmonofx(1, monoecho(ma.SR*N,feedback) @(ma.SR*(N/2)) ) :
	   cptbasics.bargraphoutput(1)) :
	  
	  // constant.nchannels in parallel
	  par(i, constant.nchannels, _ * gain);
