/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptbitcrusher";
declare description "bitcrusher filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.11";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
re = library("reverbs.lib");
ba = library("basics.lib");
fi = library("filters.lib");
ef = library("misceffects.lib");
co = library("compressors.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
	     fb1 = 1; //coefficient of the lowpass comb filters for reverb effect
	     fb2 = 1; //coefficient of the lowpass comb filters for reverb effect
};

// a slider for negated value of damping of the lowpass comb filter
room = hslider("[1]room",0,0,100,1)*((-1)/1000)+1 : si.smoo;

// a slider for  bit-depth
b = hslider("[2][lv2:integer]bits", 8, 1, 24, 1): si.smoo;

// a slider for halftones the signal is going to be transposed
s = hslider("[3][lv2:integer]shift",0,-50,+50,1) : si.smoo;

// a slider for ceiling of the limiter
ceiling = hslider("[4]limiter ceiling",1,0,10,0.1) : si.smoo;

// a slider for attack of the limiter
att = hslider("[5]limiter attack",1,0,10,0.1) : si.smoo;

// a slider for hold of the limiter
hol = hslider("[6]limiter hold",1,0,10,0.1) : si.smoo;

// a slider for release of the limiter
rel = hslider("[7]limiter release",1,0,10,0.1) : si.smoo;

// transposing the signal
shift =  ef.transpose(b, b, s);

// applying the bitrcrusher
bitcrusher =  ba.bitcrusher(b);

// applying the reverb
reverb = re.mono_freeverb(constant.fb1, constant.fb2, room, 0);

// applying the limiter
limiter = co.limiter_lad_mono(0, ceiling, att, hol, rel);

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par( i, constant.nchannels,cptbasics.bargraphinput(i) :
				     cptbasics.drywetmono( reverb : bitcrusher : shift : limiter) :
				     cptbasics.bargraphoutput(i));
