/* 
    Copyright (C) 2024, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptspectrumanalyzer";
declare description "spectrum analyzer";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.11";
declare license "GPL 3.0 or later";

//link the librarys
cptanalyzers = library("lib/analyzers.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
	     ftop = 20000; //frequency top
	     N = 16; //number of bands
	     peakrelease = 1; // peak release in seconds
	   };

// the process, that is going to be executed; contains the functions that are described before
process = cptanalyzers.multispectrumanalyzer(constant.nchannels,constant.N,constant.ftop,constant.peakrelease,0);
