#-------------------------------------------------
#
# Project created by QtCreator 2011-03-02T13:54:12
#
#-------------------------------------------------



greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

QT       += core gui

VERSION     = 1.2.1
TARGET      = speckletool
TEMPLATE    = app


RC_FILE = speckletool.rc
DESTDIR=bin
CONFIG += release


win32{

    OPENCV_DLL_PATH="C:/OpenCV/install/x86/mingw/bin"
    OPENCV_INCLUDE_PATH="C:\OpenCV\install\include"
    QT_MINGW_TOOL_CHAIN_PATH="C:/Qt/Qt5.8.0/Tools/mingw530_32/libexec/gcc/i686-w64-mingw32/5.3.0"

    message("We are asuming that OpenCV libs are located in $$OPENCV_DLL_PATH")
    message("We are asuming that Qt tool chain are located in $$QT_MINGW_TOOL_CHAIN_PATH ")

    LIBS += -llibopencv_calib3d2413
    LIBS += -llibopencv_contrib2413
    LIBS += -llibopencv_core2413
    LIBS += -llibopencv_features2d2413
    LIBS += -llibopencv_flann2413
    LIBS += -llibopencv_highgui2413
    LIBS += -llibopencv_imgproc2413
    LIBS += -llibopencv_legacy2413
    LIBS += -llibopencv_ml2413
    LIBS += -llibopencv_nonfree2413
    LIBS += -llibopencv_objdetect2413
    LIBS += -llibopencv_ocl2413
    LIBS += -llibopencv_photo2413
    LIBS += -llibopencv_stitching2413
    LIBS += -llibopencv_superres2413
    LIBS += -llibopencv_video2413
    LIBS += -llibopencv_videostab2413
    LIBS += -lopencv_ffmpeg2413

    LIBS += -L$$OPENCV_DLL_PATH
    INCLUDEPATH = $$OPENCV_INCLUDE_PATH

    LIBS += -L$$QT_MINGW_TOOL_CHAIN_PATH

    DEFINES += __OS_WINDOWS__

    isEmpty(PREFIX) {
        PREFIX = c://
        message("")
        message("The current 'make install' path is $$PREFIX, to change write: qmake PREFIX=/another/path")
    }
}

unix{
    packagesExist(opencv){EXIST_OPENCV="true"}
    isEmpty(EXIST_OPENCV){error("OpenCV is not installed.")}

    CONFIG += link_pkgconfig
    PKGCONFIG += opencv
    DEFINES += __OS_UNIX__

    isEmpty(PREFIX) {
        PREFIX = /usr/local
        message("")
        message("The current 'make install' path is $$PREFIX, to change write: qmake PREFIX=/another/path")
    }
}

SOURCES += src/main.cpp\
    src/mainwindow.cpp \
    src/auximagem.cpp \
    src/lasca.cpp \
    src/mhi.cpp \
    src/saveimagesequenceinterface.cpp \
    src/savevideointerface.cpp \
    src/dialogsobre.cpp

HEADERS  += src/mainwindow.h \
    src/auximagem.h \
    src/lasca.h \
    src/mhi.h \
    src/saveimagesequenceinterface.h \
    src/savevideointerface.h \
    src/dialogsobre.h \
    src/extras.h


FORMS    += ui/mainwindow.ui \
    ui/saveimagesequenceinterface.ui \
    ui/savevideointerface.ui \
    ui/dialogsobre.ui


# ICONS
iconos.path = $$PREFIX/share/speckletool/icons
iconos.files += \
    share/speckletool/icons/camera.ico \
    share/speckletool/icons/document-open.png \
    share/speckletool/icons/document-save-as.png \
    share/speckletool/icons/help-about.png \
    share/speckletool/icons/camera.png \
    share/speckletool/icons/document-properties.png \
    share/speckletool/icons/document-save.png \
    share/speckletool/icons/help-contents.png

# DOCS
documentation.path   = $$PREFIX/share/doc/speckletool
documentation.files += \
    share/doc/speckletool/SpeckleTool-UserGuide.pdf



DISTFILES += share/*/*/* \
    snap/* \
    win/* \
    debian/* \
    clean_all.sh  \
    README.md \
    speckletool.rc

## Intallation files

myapp.path   = $$PREFIX/bin
myapp.files += bin/speckletool


INSTALLS    += myapp\
    documentation \
    iconos


DEFINES += APP_VERSION=\\\"$$VERSION\\\"

unix{
QMAKE_CLEAN += -r bin
}

APPARCHITECTURE = $$QMAKE_HOST.arch
equals(APPARCHITECTURE , "x86_64") {
    APPARCHITECTURE = "amd64"
}
equals(APPARCHITECTURE , "x86") {
    APPARCHITECTURE = "i386"
}
equals(APPARCHITECTURE , "i686") {
    APPARCHITECTURE = "i386"
}

message("")
message("SpeckleTool filename: $$TARGET")
message(" SpeckleTool version: $$VERSION")
message("   Host architecture: $$APPARCHITECTURE")
message("")

NSI_FILE_STRING=$$cat(win/speckletool.nsi.input,blob)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPVERSION, $$VERSION)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPFILENAME, $$TARGET)
NSI_FILE_STRING=$$replace(NSI_FILE_STRING, QMAKE_VAR_APPARCH, $$APPARCHITECTURE)
write_file(win/speckletool.nsi, NSI_FILE_STRING)
QMAKE_CLEAN += win/speckletool.nsi

DEBIAN_CONTROL_FILE_STRING=$$cat(debian/control.input,blob)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPVERSION , $$VERSION)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPFILENAME, $$TARGET)
DEBIAN_CONTROL_FILE_STRING=$$replace(DEBIAN_CONTROL_FILE_STRING, QMAKE_VAR_APPARCH    , $$APPARCHITECTURE)
write_file(debian/control, DEBIAN_CONTROL_FILE_STRING)
QMAKE_CLEAN += debian/control


